/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.lars.drugs.commands.DrugsCommand;
import de.lars.drugs.commands.HarvestCommand;
import de.lars.drugs.commands.LanguageProvidedCommand;
import de.lars.drugs.commands.LanguageSwitchCommand;
import de.lars.drugs.config.Configuration;
import de.lars.drugs.config.CraftingConfiguration;
import de.lars.drugs.crafting.CigaretteCrafting;
import de.lars.drugs.crafting.DrugtestCrafting;
import de.lars.drugs.crafting.Ecstasy.EcstasyCrafting;
import de.lars.drugs.crafting.Ecstasy.IsoSafroleCrafting;
import de.lars.drugs.crafting.Ecstasy.PiperonalCrafting;
import de.lars.drugs.crafting.Ecstasy.SafroleCrafting;
import de.lars.drugs.crafting.GlueRecipeCrafting;
import de.lars.drugs.crafting.Heroin.HeroinCrafting;
import de.lars.drugs.crafting.Heroin.HeroinLiquidCrafting;
import de.lars.drugs.crafting.Heroin.SyringeCrafting;
import de.lars.drugs.crafting.JointCrafting;
import de.lars.drugs.crafting.LSD.HydrogenCrafting;
import de.lars.drugs.crafting.LSD.LSDCrafting;
import de.lars.drugs.crafting.LSD.LysergicAcidCrafting;
import de.lars.drugs.crafting.LSD.NatriumCrafting;
import de.lars.drugs.crafting.LSD.PropanolamineCrafting;
import de.lars.drugs.crafting.LongPapeCrafting;
import de.lars.drugs.crafting.PapeCrafting;
import de.lars.drugs.crafting.Speed.PhenylCrafting;
import de.lars.drugs.crafting.Speed.SpeedCrafting;
import de.lars.drugs.crafting.ZippoCrafting;
import de.lars.drugs.data.DataManager;
import de.lars.drugs.handler.CreatedItems;
import de.lars.drugs.handler.MessageHandler;
import de.lars.drugs.handler.languagehandler.CNHandler;
import de.lars.drugs.handler.languagehandler.DEHandler;
import de.lars.drugs.handler.languagehandler.ENHandler;
import de.lars.drugs.handler.languagehandler.ESHandler;
import de.lars.drugs.handler.languagehandler.FRHandler;
import de.lars.drugs.handler.languagehandler.FirstStartLanguageInitializer;
import de.lars.drugs.handler.languagehandler.RUHandler;
import de.lars.drugs.handler.languagehandler.TRHandler;
import de.lars.drugs.handler.languagehandler.infohandler.InfoHandler;
import de.lars.drugs.listener.BlackMarketListener;
import de.lars.drugs.listener.DrugEffectListener.CocaineEffectListener;
import de.lars.drugs.listener.DrugEffectListener.EcstasyEffectListener;
import de.lars.drugs.listener.DrugEffectListener.HeroinEffectListener;
import de.lars.drugs.listener.DrugEffectListener.LSDEffectListener;
import de.lars.drugs.listener.DrugEffectListener.ShroomsEffectListener;
import de.lars.drugs.listener.DrugEffectListener.SpeedEffectListener;
import de.lars.drugs.listener.DrugEffectListener.TobaccoEffectListener;
import de.lars.drugs.listener.DrugEffectListener.WeedEffectListener;
import de.lars.drugs.listener.DrugListener.CocaineListener;
import de.lars.drugs.listener.DrugListener.TobaccoListener;
import de.lars.drugs.listener.DrugListener.WeedListener;
import de.lars.drugs.listener.DrugTestListener;
import de.lars.drugs.listener.ErrorLogListener;
import de.lars.drugs.listener.GrassBreakListener;
import de.lars.drugs.listener.GrindstoneBlockListener;
import de.lars.drugs.listener.PlantHarvestListener;
import de.lars.drugs.listener.RenameBlockListener;
import de.lars.drugs.listener.ShroomBreakListener;
import de.lars.drugs.listener.SleepBlockListener;
import de.lars.drugs.listener.resourcepack.ResourcePackListener;
import de.lars.drugs.manager.BlackMarketManager;
import de.lars.drugs.manager.CustomWeedManager;
import de.lars.drugs.manager.OptionalTypeAdapterFactory;
import de.lars.drugs.manager.SalesDataManager;
import de.lars.drugs.placeholders.DrugPlaceholderExpansion;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Drugs
extends JavaPlugin
implements Listener {
    private Configuration config;
    private CraftingConfiguration craftingconfig;
    private static Economy econ = null;
    private JointCrafting jointCrafting;
    private GlueRecipeCrafting glueRecipeCrafting;
    private PapeCrafting papeCrafting;
    private LongPapeCrafting longPapeCrafting;
    private CigaretteCrafting cigaretteCrafting;
    private ZippoCrafting zippoCrafting;
    private NatriumCrafting natriumCrafting;
    private PropanolamineCrafting propanolamineCrafting;
    private LysergicAcidCrafting lysergicAcidCrafting;
    private HydrogenCrafting hydrogenCrafting;
    private LSDCrafting lsdCrafting;
    private EcstasyCrafting ecstasyCrafting;
    private IsoSafroleCrafting isoSafroleCrafting;
    private PiperonalCrafting piperonalCrafting;
    private SafroleCrafting safroleCrafting;
    private PhenylCrafting phenylCrafting;
    private SpeedCrafting speedCrafting;
    private MessageHandler messageHandler;
    private CNHandler cnHandler;
    private DEHandler deHandler;
    private ENHandler enHandler;
    private ESHandler esHandler;
    private FRHandler frHandler;
    private RUHandler ruHandler;
    private TRHandler trHandler;
    private InfoHandler infoHandler;
    private HeroinCrafting heroinCrafting;
    private HeroinLiquidCrafting heroinLiquidCrafting;
    private SyringeCrafting syringeCrafting;
    private DrugtestCrafting drugtestCrafting;
    private BlackMarketManager blackMarketManager;
    private Gson gson;
    private SalesDataManager salesDataManager;
    private static Drugs instance;
    private DataManager dataManager;
    private CustomWeedManager customWeedManager;
    private CreatedItems createdItems;
    private PlantHarvestListener plantHarvestListener;

    public void onEnable() {
        this.config = new Configuration(new File(this.getDataFolder(), "config.yml"));
        this.config.setTemplateName("/config.yml");
        this.config.load();
        this.craftingconfig = new CraftingConfiguration(new File(this.getDataFolder(), "craftings.yml"));
        this.craftingconfig.setTemplateName("/craftings.yml");
        this.craftingconfig.load();
        if (!this.setupEconomy()) {
            this.getLogger().warning("Vault Economy not found. Some features may not work.");
        } else {
            this.getLogger().info("Vault Economy found and enabled.");
        }
        instance = this;
        this.messageHandler = new MessageHandler(this);
        Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new OptionalTypeAdapterFactory()).create();
        this.gson = new Gson();
        this.dataManager = new DataManager();
        try {
            this.dataManager.loadHarvestData();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        PlantHarvestListener listener = new PlantHarvestListener();
        this.getServer().getPluginManager().registerEvents((Listener)listener, (Plugin)this);
        this.getCommand("harvested").setExecutor((CommandExecutor)new HarvestCommand(listener, this));
        this.registerlanguages();
        CocaineEffectListener cocaineEffectListener = new CocaineEffectListener(this, this.config);
        EcstasyEffectListener ecstasyEffectListener = new EcstasyEffectListener(this, this.config);
        HeroinEffectListener heroinEffectListener = new HeroinEffectListener(this, this.config);
        LSDEffectListener lsdEffectListener = new LSDEffectListener(this, this.config);
        ShroomsEffectListener shroomsEffectListener = new ShroomsEffectListener(this, this.config);
        SpeedEffectListener speedEffectListener = new SpeedEffectListener(this, this.config);
        TobaccoEffectListener tobaccoEffectListener = new TobaccoEffectListener(this, this.config);
        WeedEffectListener weedEffectListener = new WeedEffectListener(this, this.config);
        this.getServer().getPluginManager().registerEvents((Listener)new RenameBlockListener(this, this.config), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GrindstoneBlockListener(this, this.config), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WeedListener(this, this.config), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CocaineListener(this, this.config), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)weedEffectListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GrassBreakListener(this, this.config), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ShroomBreakListener(this, this.config), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CocaineListener(this, this.config), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)cocaineEffectListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)tobaccoEffectListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new TobaccoListener(this, this.config), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)shroomsEffectListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)lsdEffectListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)ecstasyEffectListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)speedEffectListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)heroinEffectListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SleepBlockListener(this), (Plugin)this);
        ResourcePackListener.registerIfEnabled(this);
        this.getServer().getPluginManager().registerEvents((Listener)new ErrorLogListener(this.getDataFolder()), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new DrugTestListener(this, lsdEffectListener, weedEffectListener, cocaineEffectListener, shroomsEffectListener, heroinEffectListener, ecstasyEffectListener, speedEffectListener, tobaccoEffectListener), (Plugin)this);
        this.getCommand("drugs").setExecutor((CommandExecutor)new DrugsCommand(this, this.config, this.craftingconfig, econ));
        this.getCommand("languageswitch").setExecutor((CommandExecutor)new LanguageSwitchCommand(this, this.config));
        this.getCommand("languageprovided").setExecutor((CommandExecutor)new LanguageProvidedCommand(this, this.config));
        this.salesDataManager = new SalesDataManager(this);
        this.salesDataManager.loadSalesData();
        this.blackMarketManager = new BlackMarketManager(this.salesDataManager, this, econ, this.config);
        BlackMarketManager manager = new BlackMarketManager(this.salesDataManager, this, econ, this.config);
        this.getServer().getPluginManager().registerEvents((Listener)new BlackMarketListener(this.blackMarketManager, this), (Plugin)this);
        this.blackMarketManager.loadMarketItems();
        this.getCommand("blackmarket").setExecutor((sender, command, label, args2) -> {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.getMessageHandler().getMessage("only_players").orElse("%prefix% \u00a7cOnly Players can execute this command").replace("%prefix%", this.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                return true;
            }
            Player player = (Player)sender;
            if (args2.length == 0) {
                this.blackMarketManager.openBlackMarket(player, 0);
                return true;
            }
            switch (args2[0].toLowerCase()) {
                case "insert": {
                    if (args2.length < 2) {
                        sender.sendMessage(this.getMessageHandler().getMessage("wrong_usage").orElse("%prefix% \u00a7cWrong usage! Correct usage: %usage%").replace("%usage%", "/blackmarket insert <price>").replace("%prefix%", this.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                        return true;
                    }
                    try {
                        int price = Integer.parseInt(args2[1]);
                        this.blackMarketManager.insertItem(player, price);
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(this.getMessageHandler().getMessage("invalid_price").orElse("%prefix% \u00a7cInvalid price. Please enter a number").replace("%prefix%", this.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                    }
                    break;
                }
                case "top": {
                    this.blackMarketManager.showTopSales(player);
                    break;
                }
                case "list": {
                    if (args2.length < 2) {
                        player.sendMessage(this.getMessageHandler().getMessage("wrong_usage").orElse("%prefix% \u00a7cWrong usage! Correct usage: %usage%").replace("%usage%", "/blackmarket list <page number").replace("%prefix%", this.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                        return true;
                    }
                    try {
                        int page = Integer.parseInt(args2[1]);
                        this.blackMarketManager.showSalesList(player, page);
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(this.getMessageHandler().getMessage("invalid_page").orElse("%prefix% \u00a7cInvalid page").replace("%prefix%", this.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                    }
                    break;
                }
                case "me": {
                    this.blackMarketManager.showMySales(player);
                    break;
                }
                default: {
                    player.sendMessage(this.getMessageHandler().getMessage("wrong_usage").orElse("%prefix% \u00a7cWrong usage! Correct usage: %usage%").replace("%usage%", "/blackmarket <insert/top/list/me>").replace("%prefix%", this.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                    player.sendMessage(ChatColor.RED + "Unknown subcommand. Available: insert, top, list, me");
                }
            }
            return true;
        });
        FirstStartLanguageInitializer initializer = new FirstStartLanguageInitializer(this, this.config);
        initializer.initializeLanguageOnFirstStart();
        this.registerCraftingRecipes();
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new DrugPlaceholderExpansion(this, this.config).register();
            this.getLogger().info("PlaceholderAPI support enabled!");
        } else {
            this.getLogger().warning("PlaceholderAPI not found! Placeholders will not work.");
        }
    }

    public void onDisable() {
        this.removeCustomRecipes();
        this.blackMarketManager.saveMarketItems();
        this.salesDataManager.saveSalesData();
        PlantHarvestListener listener = new PlantHarvestListener();
        listener.savePlayerData();
        if (this.blackMarketManager != null) {
            this.blackMarketManager.saveMarketItems();
        }
    }

    public NamespacedKey getKey(String key) {
        return new NamespacedKey((Plugin)this, key);
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    private void loadLanguageFiles(File folder) {
        if (folder.isDirectory()) {
            for (File file : folder.listFiles()) {
                if (!file.isFile()) continue;
                this.getLogger().info("Loading languages: " + file.getName());
            }
        }
    }

    public DEHandler getDeHandler() {
        return this.deHandler;
    }

    public ENHandler getEnHandler() {
        return this.enHandler;
    }

    public ESHandler getEsHandler() {
        return this.esHandler;
    }

    public RUHandler getCnHandler() {
        return this.ruHandler;
    }

    public FRHandler getFrHandler() {
        return this.frHandler;
    }

    public TRHandler getTrHandler() {
        return this.trHandler;
    }

    private void registerlanguages() {
        this.cnHandler = new CNHandler(this);
        this.deHandler = new DEHandler(this);
        this.enHandler = new ENHandler(this);
        this.esHandler = new ESHandler(this);
        this.frHandler = new FRHandler(this);
        this.ruHandler = new RUHandler(this);
        this.trHandler = new TRHandler(this);
        this.infoHandler = new InfoHandler(this);
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        econ = (Economy)rsp.getProvider();
        return econ != null;
    }

    public static Economy getEconomy() {
        return econ;
    }

    public void registerCraftingRecipes() {
        this.zippoCrafting = new ZippoCrafting(this, this.config, this.craftingconfig);
        this.zippoCrafting.registerRecipes();
        this.papeCrafting = new PapeCrafting(this, this.config, this.craftingconfig);
        this.papeCrafting.registerRecipes();
        this.jointCrafting = new JointCrafting(this, this.config, this.craftingconfig);
        this.jointCrafting.registerRecipes();
        this.cigaretteCrafting = new CigaretteCrafting(this, this.config, this.craftingconfig);
        this.cigaretteCrafting.registerRecipes();
        this.glueRecipeCrafting = new GlueRecipeCrafting(this, this.config, this.craftingconfig);
        this.glueRecipeCrafting.registerRecipes();
        this.longPapeCrafting = new LongPapeCrafting(this, this.config, this.craftingconfig);
        this.longPapeCrafting.registerRecipes();
        this.natriumCrafting = new NatriumCrafting(this, this.config, this.craftingconfig);
        this.natriumCrafting.registerRecipes();
        this.hydrogenCrafting = new HydrogenCrafting(this, this.config, this.craftingconfig);
        this.hydrogenCrafting.registerRecipes();
        this.lsdCrafting = new LSDCrafting(this, this.config, this.craftingconfig);
        this.lsdCrafting.registerRecipes();
        this.lysergicAcidCrafting = new LysergicAcidCrafting(this, this.config, this.craftingconfig);
        this.lysergicAcidCrafting.registerRecipes();
        this.propanolamineCrafting = new PropanolamineCrafting(this, this.config, this.craftingconfig);
        this.propanolamineCrafting.registerRecipes();
        this.ecstasyCrafting = new EcstasyCrafting(this, this.config, this.craftingconfig);
        this.ecstasyCrafting.registerRecipes();
        this.isoSafroleCrafting = new IsoSafroleCrafting(this, this.config, this.craftingconfig);
        this.isoSafroleCrafting.registerRecipes();
        this.piperonalCrafting = new PiperonalCrafting(this, this.config, this.craftingconfig);
        this.piperonalCrafting.registerRecipes();
        this.safroleCrafting = new SafroleCrafting(this, this.config, this.craftingconfig);
        this.safroleCrafting.registerRecipes();
        this.phenylCrafting = new PhenylCrafting(this, this.config, this.craftingconfig);
        this.phenylCrafting.registerRecipes();
        this.speedCrafting = new SpeedCrafting(this, this.config, this.craftingconfig);
        this.speedCrafting.registerRecipes();
        this.heroinCrafting = new HeroinCrafting(this, this.config, this.craftingconfig);
        this.heroinCrafting.registerRecipes();
        this.heroinLiquidCrafting = new HeroinLiquidCrafting(this, this.config, this.craftingconfig);
        this.heroinLiquidCrafting.registerRecipes();
        this.syringeCrafting = new SyringeCrafting(this, this.config, this.craftingconfig);
        this.syringeCrafting.registerRecipes();
        this.drugtestCrafting = new DrugtestCrafting(this, this.config, this.craftingconfig);
        this.drugtestCrafting.registerRecipes();
    }

    public Gson getGson() {
        return this.gson;
    }

    public static Drugs getInstance() {
        return instance;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public CreatedItems getCreateditems() {
        return this.createdItems;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    private void removeCustomRecipes() {
        NamespacedKey ecstasy = new NamespacedKey((Plugin)this, "ecstasy_recipe");
        Bukkit.removeRecipe((NamespacedKey)ecstasy);
        NamespacedKey isosafrole = new NamespacedKey((Plugin)this, "isosafrole_recipe");
        Bukkit.removeRecipe((NamespacedKey)isosafrole);
        NamespacedKey piperonal = new NamespacedKey((Plugin)this, "piperonal_recipe");
        Bukkit.removeRecipe((NamespacedKey)piperonal);
        NamespacedKey safrole = new NamespacedKey((Plugin)this, "safrole_recipe");
        Bukkit.removeRecipe((NamespacedKey)safrole);
        NamespacedKey heroin = new NamespacedKey((Plugin)this, "heroin_recipe");
        Bukkit.removeRecipe((NamespacedKey)heroin);
        NamespacedKey heroinliquid = new NamespacedKey((Plugin)this, "heroin_liquid_recipe");
        Bukkit.removeRecipe((NamespacedKey)heroinliquid);
        NamespacedKey syringe = new NamespacedKey((Plugin)this, "syringe_recipe");
        Bukkit.removeRecipe((NamespacedKey)syringe);
        NamespacedKey lsd = new NamespacedKey((Plugin)this, "lsd_recipe");
        Bukkit.removeRecipe((NamespacedKey)lsd);
        NamespacedKey hydrogen = new NamespacedKey((Plugin)this, "hydrogen_recipe");
        Bukkit.removeRecipe((NamespacedKey)hydrogen);
        NamespacedKey lysergicacid = new NamespacedKey((Plugin)this, "lysergicacid_recipe");
        Bukkit.removeRecipe((NamespacedKey)lysergicacid);
        NamespacedKey natrium = new NamespacedKey((Plugin)this, "sodium_recipe");
        Bukkit.removeRecipe((NamespacedKey)natrium);
        NamespacedKey propanolamine = new NamespacedKey((Plugin)this, "propanolamine_recipe");
        Bukkit.removeRecipe((NamespacedKey)propanolamine);
        NamespacedKey meth = new NamespacedKey((Plugin)this, "meth_recipe");
        Bukkit.removeRecipe((NamespacedKey)meth);
        NamespacedKey speed = new NamespacedKey((Plugin)this, "speed_recipe");
        Bukkit.removeRecipe((NamespacedKey)speed);
        NamespacedKey phenyl = new NamespacedKey((Plugin)this, "phenyl_recipe");
        Bukkit.removeRecipe((NamespacedKey)phenyl);
        NamespacedKey cigarette = new NamespacedKey((Plugin)this, "cigarette_recipe");
        Bukkit.removeRecipe((NamespacedKey)cigarette);
        NamespacedKey drugtest = new NamespacedKey((Plugin)this, "drugtest_recipe");
        Bukkit.removeRecipe((NamespacedKey)drugtest);
        NamespacedKey glue = new NamespacedKey((Plugin)this, "glue_recipe");
        Bukkit.removeRecipe((NamespacedKey)glue);
        NamespacedKey joint = new NamespacedKey((Plugin)this, "joint_recipe");
        Bukkit.removeRecipe((NamespacedKey)joint);
        NamespacedKey longpape = new NamespacedKey((Plugin)this, "longpape_recipe");
        Bukkit.removeRecipe((NamespacedKey)longpape);
        NamespacedKey pape = new NamespacedKey((Plugin)this, "pape_recipe");
        Bukkit.removeRecipe((NamespacedKey)pape);
        NamespacedKey zippo = new NamespacedKey((Plugin)this, "zippo_recipe");
        Bukkit.removeRecipe((NamespacedKey)zippo);
    }

    public class OptionalTypeAdapter<T>
    extends TypeAdapter<Optional<T>> {
        private final TypeAdapter<T> delegate;

        public OptionalTypeAdapter(Gson gson, TypeToken<T> typeToken) {
            this.delegate = gson.getAdapter(typeToken);
        }

        public void write(JsonWriter out, Optional<T> value) throws IOException {
            if (value == null || !value.isPresent()) {
                out.nullValue();
            } else {
                this.delegate.write(out, value.get());
            }
        }

        public Optional<T> read(JsonReader in) throws IOException {
            Object value = this.delegate.read(in);
            return Optional.ofNullable(value);
        }
    }
}

