/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.GUI.LSD;

import de.lars.drugs.Drugs;
import de.lars.drugs.config.Configuration;
import de.lars.drugs.config.CraftingConfiguration;
import de.lars.drugs.handler.CreatedItems;
import de.lars.inventoryframework.gui.GuiItem;
import de.lars.inventoryframework.gui.type.ChestGui;
import de.lars.inventoryframework.pane.StaticPane;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class LysergicAcidGUI {
    private final Configuration config;
    private final Drugs plugin;
    private final CraftingConfiguration craftingconfig;

    public LysergicAcidGUI(Drugs plugin, Configuration config, CraftingConfiguration craftingconfig) {
        this.config = config;
        this.plugin = plugin;
        this.craftingconfig = craftingconfig;
    }

    public void open(Player player) {
        int i;
        ChestGui gui = new ChestGui(5, this.plugin.getMessageHandler().getMessage("lysergicacid_gui_name").orElse("\u00a7aLSD Crafting GUI"));
        StaticPane pane = new StaticPane(0, 0, 9, 5);
        ItemStack borderitem = CreatedItems.createGUIBorder(this.plugin, this.config);
        GuiItem borderItem = new GuiItem(borderitem, event -> event.setCancelled(true));
        ItemStack resultsitem = CreatedItems.resultGuiItem(this.plugin, this.config);
        GuiItem resultsItem = new GuiItem(resultsitem, event -> event.setCancelled(true));
        ItemStack resultitem = CreatedItems.createLysergicAcid(this.plugin, this.config);
        GuiItem resultItem = new GuiItem(resultitem, event -> event.setCancelled(true));
        ItemStack[] ingredientItems = new ItemStack[9];
        for (char c = 'A'; c <= 'I'; c = (char)(c + '\u0001')) {
            Material material;
            ItemStack customItem;
            String materialKey = "lysergicacid_material_" + Character.toLowerCase(c);
            String materialString = this.craftingconfig.getString(materialKey, "AIR");
            if (this.plugin.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
                materialString = PlaceholderAPI.setPlaceholders((Player)player, (String)materialString);
            }
            ingredientItems[c - 65] = (customItem = this.getCustomItem(materialString)) != null ? customItem : ((material = Material.matchMaterial((String)materialString)) != null && material != Material.AIR ? new ItemStack(material) : new ItemStack(Material.AIR));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (ingredientItems[i * 3 + j].getType() == Material.AIR) continue;
                GuiItem ingredientGuiItem = new GuiItem(ingredientItems[i * 3 + j], event -> event.setCancelled(true));
                pane.addItem(ingredientGuiItem, j + 1, i + 1);
            }
        }
        pane.addItem(resultsItem, 5, 2);
        pane.addItem(resultItem, 7, 2);
        for (i = 0; i < 9; ++i) {
            pane.addItem(borderItem, i, 0);
            pane.addItem(borderItem, i, 4);
        }
        for (i = 1; i < 4; ++i) {
            pane.addItem(borderItem, 0, i);
            pane.addItem(borderItem, 8, i);
        }
        gui.addPane(pane);
        gui.setOnGlobalClick(event -> {
            event.setCancelled(true);
            if (event.getClickedInventory() != null && event.getClickedInventory().equals(player.getOpenInventory().getTopInventory())) {
                event.setCancelled(true);
            }
        });
        gui.show((HumanEntity)player);
    }

    private ItemStack getCustomItem(String placeholder) {
        switch (placeholder.toLowerCase()) {
            case "%hydrogen%": {
                return CreatedItems.createHydrogen(this.plugin, this.config);
            }
            case "%lsd%": {
                return CreatedItems.createLSD(this.plugin, this.config);
            }
            case "%lysergicacid%": {
                return CreatedItems.createLysergicAcid(this.plugin, this.config);
            }
            case "%sodium%": {
                return CreatedItems.createNatrium(this.plugin, this.config);
            }
            case "%propanolamine%": {
                return CreatedItems.createpropanolamine(this.plugin, this.config);
            }
            case "%cigarette%": {
                return CreatedItems.createcigarette(this.plugin, this.config);
            }
            case "%glue%": {
                return CreatedItems.createGlue(this.plugin, this.config);
            }
            case "%joint%": {
                return CreatedItems.createjoint(this.plugin, this.config);
            }
            case "%longpapes%": {
                return CreatedItems.createLongPapes(this.plugin, this.config);
            }
            case "%papes%": {
                return CreatedItems.getPapeItem(this.plugin, this.config);
            }
            case "%zippo%": {
                return CreatedItems.createZippo(this.plugin, this.config);
            }
            case "%weedseed%": {
                return CreatedItems.getSuperSeedItem(this.plugin);
            }
            case "%cocaineseed%": {
                return CreatedItems.getCocainePlantItem(this.plugin);
            }
            case "%tobaccoseed%": {
                return CreatedItems.getTobaccoPlant(this.plugin);
            }
            case "%weed%": {
                return CreatedItems.getSuperWheatItem(this.plugin);
            }
            case "%shroom%": {
                return CreatedItems.getShroomItem(this.plugin);
            }
            case "%cocaine%": {
                return CreatedItems.getCocaineItem(this.plugin);
            }
            case "%tobacco%": {
                return CreatedItems.getTobaccoItem(this.plugin);
            }
            case "%ecstasy%": {
                return CreatedItems.createXTC(this.plugin, this.config);
            }
            case "%xtc%": {
                return CreatedItems.createXTC(this.plugin, this.config);
            }
            case "%isosafrole%": {
                return CreatedItems.createIsoSafrole(this.plugin, this.config);
            }
            case "%piperonal%": {
                return CreatedItems.createpiperonal(this.plugin, this.config);
            }
            case "%safrole%": {
                return CreatedItems.createSafrole(this.plugin, this.config);
            }
            case "%phenyl%": {
                return CreatedItems.createPhenyl(this.plugin, this.config);
            }
            case "%speed%": {
                return CreatedItems.createSpeed(this.plugin, this.config);
            }
            case "%heroinliquid%": {
                return CreatedItems.createLiquid(this.plugin, this.config);
            }
            case "%heroin%": {
                return CreatedItems.createHeroin(this.plugin, this.config);
            }
            case "%syringe%": {
                return CreatedItems.createSyringe(this.plugin, this.config);
            }
            case "%drugtest%": {
                return CreatedItems.createDrugtest(this.plugin, this.config);
            }
            case "%crack%": {
                return CreatedItems.getCrackitem(this.plugin);
            }
        }
        return null;
    }
}

