/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.commands;

import de.lars.drugs.Drugs;
import de.lars.drugs.GUI.CigaretteGUI;
import de.lars.drugs.GUI.DrugtestGUI;
import de.lars.drugs.GUI.GlueGUI;
import de.lars.drugs.GUI.JointGUI;
import de.lars.drugs.GUI.LSD.HydrogenGUI;
import de.lars.drugs.GUI.LSD.LSDGUI;
import de.lars.drugs.GUI.LSD.LysergicAcidGUI;
import de.lars.drugs.GUI.LSD.NatriumGUI;
import de.lars.drugs.GUI.LSD.PropanolamineGUI;
import de.lars.drugs.GUI.LongPapeGUI;
import de.lars.drugs.GUI.PapeGUI;
import de.lars.drugs.GUI.Speed.PhenylGUI;
import de.lars.drugs.GUI.Speed.SpeedGUI;
import de.lars.drugs.GUI.ZippoGUI;
import de.lars.drugs.GUI.ecstasy.EcstasyGUI;
import de.lars.drugs.GUI.ecstasy.IsoSafroleGUI;
import de.lars.drugs.GUI.ecstasy.PiperonalGUI;
import de.lars.drugs.GUI.ecstasy.SafroleGUI;
import de.lars.drugs.GUI.heroin.HeroinGUI;
import de.lars.drugs.GUI.heroin.HeroinLiquidGUI;
import de.lars.drugs.GUI.heroin.SyringeGUI;
import de.lars.drugs.commands.GiveDrugsCommand;
import de.lars.drugs.commands.MainhandCommand;
import de.lars.drugs.commands.OffhandCommand;
import de.lars.drugs.commands.ReloadCommand;
import de.lars.drugs.config.Configuration;
import de.lars.drugs.config.CraftingConfiguration;
import de.lars.drugs.drugshop.commands.BuyCommand;
import de.lars.drugs.drugshop.commands.SellCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;

public class DrugsCommand
implements CommandExecutor,
TabCompleter {
    private final GiveDrugsCommand giveDrugsCommand;
    private final BuyCommand buyCommand;
    private final SellCommand sellCommand;
    private final ReloadCommand reloadCommand;
    private final Drugs plugin;
    private final OffhandCommand offhandCommand;
    private final MainhandCommand mainhandCommand;
    private Configuration config;
    private final CraftingConfiguration craftingconfig;
    private final Economy economy;
    private final HashMap<UUID, PermissionAttachment> playerPermissions = new HashMap();

    public DrugsCommand(Drugs plugin, Configuration config, CraftingConfiguration craftingconfig, Economy economy) {
        this.plugin = plugin;
        this.giveDrugsCommand = new GiveDrugsCommand(plugin, config);
        this.buyCommand = new BuyCommand(plugin, config);
        this.sellCommand = new SellCommand(plugin, economy, config);
        this.offhandCommand = new OffhandCommand(plugin);
        this.mainhandCommand = new MainhandCommand(plugin);
        this.reloadCommand = new ReloadCommand(plugin, config);
        this.config = config;
        this.craftingconfig = craftingconfig;
        this.economy = economy;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        Player player = (Player)sender;
        if (command.getName().equalsIgnoreCase("drugs")) {
            if (args2.length == 0) {
                sender.sendMessage(this.plugin.getMessageHandler().getMessage("wrong_usage").orElse("%prefix% \u00a7cWrong usage! Correct usage: %usage%").replace("%usage%", "/drugs <give|buy|info|reload|permission>").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                return false;
            }
            String subCommand = args2[0];
            switch (subCommand.toLowerCase()) {
                case "give": {
                    return this.giveDrugsCommand.execute(sender, args2);
                }
                case "buy": {
                    return this.buyCommand.execute(sender, args2);
                }
                case "sell": {
                    return this.sellCommand.execute(sender, args2);
                }
                case "offhand": {
                    return this.offhandCommand.execute(sender, args2);
                }
                case "mainhand": {
                    return this.mainhandCommand.execute(sender, args2);
                }
                case "reload": {
                    try {
                        return this.reloadCommand.execute(sender, args2);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                case "info": {
                    if (args2.length < 2) {
                        sender.sendMessage(this.plugin.getMessageHandler().getMessage("wrong_usage").orElse("%prefix% \u00a7cWrong usage! Correct usage: %usage%").replace("%usage%", "/drugs info <drug>").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                        return false;
                    }
                    String drug = args2[1].toLowerCase();
                    this.openDrugInfoGUI(drug, player);
                    return true;
                }
                case "permission": {
                    if (args2.length < 4) {
                        sender.sendMessage(this.plugin.getMessageHandler().getMessage("wrong_usage").orElse("%prefix% \u00a7cWrong usage! Correct usage: %usage%").replace("%usage%", "/drugs permission <add|remove> <PLAYER|ALL> <INGREDIENT>").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                        return false;
                    }
                    if (!player.hasPermission("drugs.permission")) {
                        return true;
                    }
                    String action = args2[1].toLowerCase();
                    String target = args2[2];
                    String ingredient = args2[3].toLowerCase();
                    String permission = "drugs.craft." + ingredient;
                    if (action.equals("add")) {
                        if (target.equalsIgnoreCase("ALL")) {
                            this.addPermissionToAll(permission);
                            sender.sendMessage(this.plugin.getMessageHandler().getMessage("permission_added").orElse("%prefix% \u00a7aPermission added: %permission%").replace("%permission%", permission).replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                        } else {
                            Player targetPlayer = Bukkit.getPlayer((String)target);
                            if (targetPlayer != null) {
                                this.addPermission(targetPlayer, permission);
                                sender.sendMessage(this.plugin.getMessageHandler().getMessage("permission_added_player").orElse("%prefix% \u00a7aAdded permission %permission% to %player%").replace("%permission%", permission).replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]").replace("%player%", targetPlayer.getName())));
                            } else {
                                sender.sendMessage(this.plugin.getMessageHandler().getMessage("player_not_found").orElse("%prefix% \u00a7cPlayer not found!").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                            }
                        }
                    } else if (action.equals("remove")) {
                        if (target.equalsIgnoreCase("ALL")) {
                            this.removePermissionFromAll(permission);
                            sender.sendMessage(this.plugin.getMessageHandler().getMessage("permission_removed").orElse("%prefix% \u00a7aPermission removed: %permission%").replace("%permission%", permission).replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                        } else {
                            Player targetPlayer = Bukkit.getPlayer((String)target);
                            if (targetPlayer != null) {
                                this.removePermission(targetPlayer, permission);
                                sender.sendMessage(this.plugin.getMessageHandler().getMessage("permission_removed_player").orElse("%prefix% \u00a7aAdded permission %permission% to %player%").replace("%permission%", permission).replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]").replace("%player%", targetPlayer.getName())));
                            } else {
                                sender.sendMessage(this.plugin.getMessageHandler().getMessage("player_not_found").orElse("%prefix% \u00a7cPlayer not found!").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                            }
                        }
                    } else {
                        sender.sendMessage(this.plugin.getMessageHandler().getMessage("invalid_action").orElse("%prefix% \u00a7cInvalid action please use add/remove").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                    }
                    return true;
                }
            }
            sender.sendMessage(this.plugin.getMessageHandler().getMessage("wrong_usage").orElse("%prefix% \u00a7cWrong usage! Correct usage: %usage%").replace("%usage%", "/drugs <give|buy|info|reload|permission|sell>").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return false;
        }
        return false;
    }

    private void addPermission(Player player, String permission) {
        PermissionAttachment attachment = player.addAttachment((Plugin)this.plugin);
        attachment.setPermission(permission, true);
        this.playerPermissions.put(player.getUniqueId(), attachment);
    }

    private void removePermission(Player player, String permission) {
        PermissionAttachment attachment = this.playerPermissions.get(player.getUniqueId());
        if (attachment != null) {
            attachment.unsetPermission(permission);
        }
    }

    private void addPermissionToAll(String permission) {
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            this.addPermission(onlinePlayer, permission);
        }
    }

    private void removePermissionFromAll(String permission) {
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            this.removePermission(onlinePlayer, permission);
        }
    }

    private void openDrugInfoGUI(String drug, Player player) {
        switch (drug) {
            case "ecstasy": {
                new EcstasyGUI(this.plugin, this.config, this.craftingconfig).open(player);
                break;
            }
            case "isosafrole": {
                new IsoSafroleGUI(this.plugin, this.config, this.craftingconfig).open(player);
                break;
            }
            case "safrole": {
                new SafroleGUI(this.plugin, this.config, this.craftingconfig).open(player);
                break;
            }
            case "piperonal": {
                new PiperonalGUI(this.plugin, this.config, this.craftingconfig).open(player);
                break;
            }
            case "xtc": {
                new EcstasyGUI(this.plugin, this.config, this.craftingconfig).open(player);
                break;
            }
            case "joint": {
                new JointGUI(this.plugin, this.config, this.craftingconfig).open(player);
                break;
            }
            case "longpapes": {
                new LongPapeGUI(this.plugin, this.config, this.craftingconfig).open(player);
                break;
            }
            case "glue": {
                new GlueGUI(this.plugin, this.config, this.craftingconfig).open(player);
                break;
            }
            case "zippo": {
                new ZippoGUI(this.plugin, this.config, this.craftingconfig).open(player);
                break;
            }
            case "lsd": {
                new LSDGUI(this.plugin, this.config, this.craftingconfig).open(player);
                break;
            }
            case "hydrogen": {
                new HydrogenGUI(this.plugin, this.config, this.craftingconfig).open(player);
                break;
            }
            case "lysergicacid": {
                new LysergicAcidGUI(this.plugin, this.config, this.craftingconfig).open(player);
                break;
            }
            case "propanolamine": {
                new PropanolamineGUI(this.plugin, this.config, this.craftingconfig).open(player);
                break;
            }
            case "sodium": {
                new NatriumGUI(this.plugin, this.config, this.craftingconfig).open(player);
                break;
            }
            case "cigarette": {
                new CigaretteGUI(this.plugin, this.config, this.craftingconfig).open(player);
                break;
            }
            case "papes": {
                new PapeGUI(this.plugin, this.config, this.craftingconfig).open(player);
                break;
            }
            case "speed": {
                new SpeedGUI(this.plugin, this.config, this.craftingconfig).open(player);
                break;
            }
            case "phenyl": {
                new PhenylGUI(this.plugin, this.config, this.craftingconfig).open(player);
                break;
            }
            case "heroin": {
                new HeroinGUI(this.plugin, this.config, this.craftingconfig).open(player);
                break;
            }
            case "heroinliquid": {
                new HeroinLiquidGUI(this.plugin, this.config, this.craftingconfig).open(player);
                break;
            }
            case "syringe": {
                new SyringeGUI(this.plugin, this.config, this.craftingconfig).open(player);
                break;
            }
            case "drugtest": {
                new DrugtestGUI(this.plugin, this.config, this.craftingconfig).open(player);
                break;
            }
            default: {
                player.sendMessage(this.plugin.getMessageHandler().getMessage("unkown_drug").orElse("%prefix% \u00a7cUnkown drug. Available options %options%").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]").replace("%options%", "ecstasy, xtc, lsd, cigarette, speed, heroin.")));
            }
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args2) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args2.length == 3 && args2[1].equalsIgnoreCase("ecstasy")) {
            completions.add("IsoSafrole");
            completions.add("safrole");
            completions.add("piperonal");
            completions.add("XTC");
        } else if (args2.length == 3 && args2[1].equalsIgnoreCase("lsd")) {
            completions.add("Hydrogen");
            completions.add("LSD");
            completions.add("Lysergicacid");
            completions.add("propanolamine");
            completions.add("Sodium");
        } else if (args2.length == 3 && args2[1].equalsIgnoreCase("cigarette")) {
            completions.add("Cigarette");
            completions.add("papes");
            completions.add("Tobacco");
            completions.add("TobaccoSeed");
            completions.add("Zippo");
        } else if (args2.length == 3 && args2[1].equalsIgnoreCase("weed")) {
            completions.add("Glue");
            completions.add("Joint");
            completions.add("Longpapes");
            completions.add("Weed");
            completions.add("WeedSeed");
            completions.add("Zippo");
        } else if (args2.length == 3 && args2[1].equalsIgnoreCase("cocaine")) {
            completions.add("Cocaine");
            completions.add("CocaineSeed");
        } else if (args2.length == 3 && args2[1].equalsIgnoreCase("speed")) {
            completions.add("Speed");
            completions.add("Phenyl");
        } else if (args2.length == 3 && args2[1].equalsIgnoreCase("heroin")) {
            completions.add("Heroin");
            completions.add("Heroinliquid");
            completions.add("Syringe");
        } else if (args2.length == 3 && args2[1].equalsIgnoreCase("shrooms")) {
            completions.add("Shroom");
        } else if (args2.length == 3 && args2[1].equalsIgnoreCase("drugtest")) {
            completions.add("drugtest");
        } else if (args2.length == 3 && args2[0].equalsIgnoreCase("give")) {
            completions.add("IsoSafrole");
            completions.add("safrole");
            completions.add("piperonal");
            completions.add("XTC");
            completions.add("Hydrogen");
            completions.add("LSD");
            completions.add("Lysergicacid");
            completions.add("propanolamine");
            completions.add("Sodium");
            completions.add("Cigarette");
            completions.add("papes");
            completions.add("Tobacco");
            completions.add("TobaccoSeed");
            completions.add("Glue");
            completions.add("Joint");
            completions.add("Longpapes");
            completions.add("Weed");
            completions.add("WeedSeed");
            completions.add("Zippo");
            completions.add("Cocaine");
            completions.add("CocaineSeed");
            completions.add("Speed");
            completions.add("Phenyl");
            completions.add("Heroin");
            completions.add("Heroinliquid");
            completions.add("Syringe");
            completions.add("Shroom");
        } else if (args2.length == 2 && args2[0].equalsIgnoreCase("buy")) {
            completions.add("cigarette");
            completions.add("cocaine");
            completions.add("ecstasy");
            completions.add("lsd");
            completions.add("shrooms");
            completions.add("weed");
            completions.add("speed");
            completions.add("heroin");
        } else if (args2.length == 1) {
            completions.add("give");
            completions.add("buy");
            completions.add("info");
            completions.add("reload");
            completions.add("permission");
        } else if (args2.length == 2 && args2[0].equalsIgnoreCase("info")) {
            completions.add("ecstasy");
            completions.add("isosafrole");
            completions.add("safrole");
            completions.add("piperonal");
            completions.add("xtc");
            completions.add("joint");
            completions.add("longpapes");
            completions.add("glue");
            completions.add("zippo");
            completions.add("lsd");
            completions.add("hydrogen");
            completions.add("lysergicacid");
            completions.add("propanolamine");
            completions.add("sodium");
            completions.add("cigarette");
            completions.add("papes");
            completions.add("speed");
            completions.add("phenyl");
            completions.add("heroin");
            completions.add("heroinliquid");
            completions.add("syringe");
            completions.add("drugtest");
        } else if (args2.length == 2 && args2[0].equalsIgnoreCase("permission")) {
            completions.add("add");
            completions.add("remove");
        } else if (args2.length == 3 && args2[0].equalsIgnoreCase("permission")) {
            completions.add("ALL");
            for (Player player : Bukkit.getOnlinePlayers()) {
                completions.add(player.getName());
            }
        } else if (args2.length == 1) {
            completions.add("give");
            completions.add("buy");
            completions.add("sell");
            completions.add("offhand");
            completions.add("mainhand");
            completions.add("info");
            completions.add("reload");
            completions.add("permission");
        } else if (args2.length == 2 && args2[0].equalsIgnoreCase("permission")) {
            completions.add("add");
            completions.add("remove");
        } else if (args2.length == 3 && args2[0].equalsIgnoreCase("permission")) {
            completions.add("ALL");
            for (Player player : Bukkit.getOnlinePlayers()) {
                completions.add(player.getName());
            }
        } else if (args2.length == 4 && args2[0].equalsIgnoreCase("permission")) {
            completions.add("ecstasy");
            completions.add("isosafrole");
            completions.add("safrole");
            completions.add("piperonal");
            completions.add("xtc");
            completions.add("joint");
            completions.add("longpapes");
            completions.add("glue");
            completions.add("zippo");
            completions.add("lsd");
            completions.add("hydrogen");
            completions.add("lysergicacid");
            completions.add("propanolamine");
            completions.add("sodium");
            completions.add("cigarette");
            completions.add("papes");
            completions.add("speed");
            completions.add("phenyl");
            completions.add("heroin");
            completions.add("heroinliquid");
            completions.add("syringe");
            completions.add("drugtest");
        }
        return completions;
    }
}

