/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.commands;

import de.lars.drugs.Drugs;
import de.lars.drugs.config.Configuration;
import de.lars.drugs.handler.CreatedItems;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GiveDrugsCommand {
    private final Configuration config;
    private final Drugs plugin;

    public GiveDrugsCommand(Drugs plugin, Configuration config) {
        this.config = config;
        this.plugin = plugin;
    }

    public boolean execute(CommandSender sender, String[] args2) {
        ItemStack drugItem;
        int amount;
        Player player = (Player)sender;
        if (args2.length < 4) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("wrong_usage").orElse("%prefix% \u00a7cWrong usage! Correct usage: %usage%").replace("%usage%", "/drugs give PLAYERNAME DRUG DRUG_AMOUNT").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return true;
        }
        if (!player.hasPermission("drugs.give")) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("no_authorization").orElse("%prefix% \u00a7cYou don't have the rights to do this!").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return true;
        }
        String targetPlayerName = args2[1];
        String drugCategory = args2[2].toLowerCase();
        try {
            amount = Integer.parseInt(args2[3]);
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("invalid_amount").orElse("%prefix% \u00a7eInvalid amount specified!").replace("prefix", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return true;
        }
        Player targetPlayer = this.plugin.getServer().getPlayer(targetPlayerName);
        if (targetPlayer == null) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("player_not_found").orElse("%prefix% \u00a7cPlayer not found!").replace("prefix", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return true;
        }
        String drugname = drugCategory;
        switch (drugCategory) {
            case "hydrogen": {
                drugItem = CreatedItems.createHydrogen(this.plugin, this.config);
                break;
            }
            case "lsd": {
                drugItem = CreatedItems.createLSD(this.plugin, this.config);
                break;
            }
            case "lysergicacid": {
                drugItem = CreatedItems.createLysergicAcid(this.plugin, this.config);
                break;
            }
            case "sodium": {
                drugItem = CreatedItems.createNatrium(this.plugin, this.config);
                break;
            }
            case "propanolamine": {
                drugItem = CreatedItems.createpropanolamine(this.plugin, this.config);
                break;
            }
            case "cigarette": {
                drugItem = CreatedItems.createcigarette(this.plugin, this.config);
                break;
            }
            case "glue": {
                drugItem = CreatedItems.createGlue(this.plugin, this.config);
                break;
            }
            case "joint": {
                drugItem = CreatedItems.createjoint(this.plugin, this.config);
                break;
            }
            case "longpapes": {
                drugItem = CreatedItems.createLongPapes(this.plugin, this.config);
                break;
            }
            case "papes": {
                drugItem = CreatedItems.getPapeItem(this.plugin, this.config);
                break;
            }
            case "zippo": {
                drugItem = CreatedItems.createZippo(this.plugin, this.config);
                break;
            }
            case "weedseed": {
                drugItem = CreatedItems.getSuperSeedItem(this.plugin);
                break;
            }
            case "cocaineseed": {
                drugItem = CreatedItems.getCocainePlantItem(this.plugin);
                break;
            }
            case "tobaccoseed": {
                drugItem = CreatedItems.getTobaccoPlant(this.plugin);
                break;
            }
            case "weed": {
                drugItem = CreatedItems.getSuperWheatItem(this.plugin);
                break;
            }
            case "shroom": {
                drugItem = CreatedItems.getShroomItem(this.plugin);
                break;
            }
            case "cocaine": {
                drugItem = CreatedItems.getCocaineItem(this.plugin);
                break;
            }
            case "tobacco": {
                drugItem = CreatedItems.getTobaccoItem(this.plugin);
                break;
            }
            case "xtc": {
                drugItem = CreatedItems.createXTC(this.plugin, this.config);
                break;
            }
            case "isosafrole": {
                drugItem = CreatedItems.createIsoSafrole(this.plugin, this.config);
                break;
            }
            case "piperonal": {
                drugItem = CreatedItems.createpiperonal(this.plugin, this.config);
                break;
            }
            case "safrole": {
                drugItem = CreatedItems.createSafrole(this.plugin, this.config);
                break;
            }
            case "speed": {
                drugItem = CreatedItems.createSpeed(this.plugin, this.config);
                break;
            }
            case "phenyl": {
                drugItem = CreatedItems.createPhenyl(this.plugin, this.config);
                break;
            }
            case "heroinliquid": {
                drugItem = CreatedItems.createLiquid(this.plugin, this.config);
                break;
            }
            case "heroin": {
                drugItem = CreatedItems.createHeroin(this.plugin, this.config);
                break;
            }
            case "syringe": {
                drugItem = CreatedItems.createSyringe(this.plugin, this.config);
                break;
            }
            case "drugtest": {
                drugItem = CreatedItems.createDrugtest(this.plugin, this.config);
                break;
            }
            default: {
                player.sendMessage(this.plugin.getMessageHandler().getMessage("invalid_drug").orElse("%prefix% \u00a7eInvalid drug category specified!").replace("prefix", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                return true;
            }
        }
        drugItem.setAmount(amount);
        targetPlayer.getInventory().addItem(new ItemStack[]{drugItem});
        player.sendMessage(this.plugin.getMessageHandler().getMessage("drug_received").orElse("You gave %amount% %drugname% to %playername%").replace("%amount%", String.valueOf(amount)).replace("%drugname%", drugname).replace("%playername%", targetPlayerName));
        return true;
    }
}

