/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.commands;

import de.lars.drugs.Drugs;
import de.lars.drugs.data.HarvestData;
import de.lars.drugs.listener.PlantHarvestListener;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class HarvestCommand
implements CommandExecutor {
    private final PlantHarvestListener listener;
    private final Drugs plugin;

    public HarvestCommand(PlantHarvestListener listener, Drugs plugin) {
        this.plugin = plugin;
        this.listener = listener;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        if (args2.length < 2) {
            sender.sendMessage("\u00a7f\u00a7l--- \u00a7a\u00a7l\u00a7nUsage \u00a7f\u00a7l---");
            sender.sendMessage("\u00a7f\u00a7l----------------");
            sender.sendMessage("\u00a7a/harvested me all/tobacco/weed/cocaine harvested/planted");
            sender.sendMessage("\u00a7f\u00a7l----------------");
            sender.sendMessage("\u00a7a/harvested PLAYERNAME all/tobacco/weed/cocaine harvested/planted");
            sender.sendMessage("\u00a7f\u00a7l----------------");
            sender.sendMessage("\u00a7a/harvested top all/tobacco/weed/cocaine harvested/planted");
            sender.sendMessage("\u00a7f\u00a7l----------------");
            sender.sendMessage("\u00a7a/harvested list all/tobacco/weed/cocaine harvested/planted PAGE");
            return true;
        }
        String type = args2[1];
        String action = args2.length > 2 ? args2[2] : "harvested";
        Map<UUID, HarvestData> playerData = this.listener.getPlayerData();
        if (args2[0].equalsIgnoreCase("me") && sender instanceof Player) {
            Player player = (Player)sender;
            HarvestData data = playerData.getOrDefault(player.getUniqueId(), new HarvestData());
            this.displayData(sender, player.getName(), data, type, action);
        } else if (args2[0].equalsIgnoreCase("top")) {
            if (args2.length < 3) {
                sender.sendMessage("\u00a7f\u00a7l--- \u00a7a\u00a7l\u00a7nUsage \u00a7f\u00a7l---");
                sender.sendMessage("\u00a7f\u00a7l----------------");
                sender.sendMessage("\u00a7a/harvested me all/tobacco/weed/cocaine harvested/planted");
                sender.sendMessage("\u00a7f\u00a7l----------------");
                sender.sendMessage("\u00a7a/harvested PLAYERNAME all/tobacco/weed/cocaine harvested/planted");
                sender.sendMessage("\u00a7f\u00a7l----------------");
                sender.sendMessage("\u00a7a/harvested top all/tobacco/weed/cocaine harvested/planted");
                sender.sendMessage("\u00a7f\u00a7l----------------");
                sender.sendMessage("\u00a7a/harvested list all/tobacco/weed/cocaine harvested/planted PAGE");
            }
            String topType = args2[1];
            String topAction = args2[2];
            this.displayTopPlayers(sender, topType, topAction, playerData);
        } else if (args2[0].equalsIgnoreCase("list")) {
            if (args2.length < 4) {
                sender.sendMessage("\u00a7f\u00a7l--- \u00a7a\u00a7l\u00a7nUsage \u00a7f\u00a7l---");
                sender.sendMessage("\u00a7f\u00a7l----------------");
                sender.sendMessage("\u00a7a/harvested me all/tobacco/weed/cocaine harvested/planted");
                sender.sendMessage("\u00a7f\u00a7l----------------");
                sender.sendMessage("\u00a7a/harvested PLAYERNAME all/tobacco/weed/cocaine harvested/planted");
                sender.sendMessage("\u00a7f\u00a7l----------------");
                sender.sendMessage("\u00a7a/harvested top all/tobacco/weed/cocaine harvested/planted");
                sender.sendMessage("\u00a7f\u00a7l----------------");
                sender.sendMessage("\u00a7a/harvested list all/tobacco/weed/cocaine harvested/planted PAGE");
                return true;
            }
            String listType = args2[1];
            String listAction = args2[2];
            int page = Integer.parseInt(args2[3]);
            this.displayPagedList(sender, listType, listAction, page, playerData);
        } else {
            Player target = Bukkit.getPlayer((String)args2[0]);
            if (target == null) {
                sender.sendMessage(this.plugin.getMessageHandler().getMessage("player_not_found").orElse("%prefix% \u00a7cPlayer not found!").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                return true;
            }
            HarvestData data = playerData.getOrDefault(target.getUniqueId(), new HarvestData());
            this.displayData(sender, target.getName(), data, type, action);
        }
        return true;
    }

    private void displayData(CommandSender sender, String name, HarvestData data, String type, String action) {
        boolean isPlanted = action.equalsIgnoreCase("planted");
        switch (type.toLowerCase()) {
            case "weed": {
                sender.sendMessage(this.plugin.getMessageHandler().getMessage("planted_message").orElse("%prefix% &a%player% has %amount% %plant% %action%.").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")).replace("%player%", name).replace("%amount%", String.valueOf(isPlanted ? data.getWeedPlanted() : data.getWeedHarvested())).replace("%plant%", "weed plant").replace("%action%", action));
                break;
            }
            case "cocaine": {
                sender.sendMessage(this.plugin.getMessageHandler().getMessage("planted_message").orElse("%prefix% &a%player% has %amount% %plant% %action%.").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")).replace("%player%", name).replace("%amount%", String.valueOf(isPlanted ? data.getCocainePlanted() : data.getCocaineHarvested())).replace("%plant%", "cocaine plant").replace("%action%", action));
                break;
            }
            case "tobacco": {
                sender.sendMessage(this.plugin.getMessageHandler().getMessage("planted_message").orElse("%prefix% &a%player% has %amount% %plant% %action%.").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")).replace("%player%", name).replace("%amount%", String.valueOf(isPlanted ? data.getTobaccoPlanted() : data.getTobaccoHarvested())).replace("%plant%", "tobacco plant").replace("%action%", action));
                break;
            }
            case "all": {
                sender.sendMessage(this.plugin.getMessageHandler().getMessage("planted_message").orElse("%prefix% &a%player% has %amount% %plant% %action% in total.").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")).replace("%player%", name).replace("%amount%", String.valueOf(isPlanted ? data.getTotalPlanted() : data.getTotalHarvested())).replace("%plant%", "plants").replace("%action%", action));
                break;
            }
            default: {
                sender.sendMessage(this.plugin.getMessageHandler().getMessage("invalid_type").orElse("%prefix% \u00a7cInvalid type: %type%").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")).replace("%type%", type));
            }
        }
    }

    private void displayTopPlayers(CommandSender sender, String type, String action, Map<UUID, HarvestData> playerData) {
        boolean isPlanted = action.equalsIgnoreCase("planted");
        Comparator<Map.Entry<UUID, HarvestData>> comparator = this.getComparator(type, isPlanted);
        if (comparator == null) {
            sender.sendMessage(this.plugin.getMessageHandler().getMessage("invalid_type").orElse("%prefix% \u00a7cInvalid type: %type%").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")).replace("%type%", type));
            return;
        }
        List sortedEntries = playerData.entrySet().stream().sorted(comparator).limit(10L).collect(Collectors.toList());
        sender.sendMessage(this.plugin.getMessageHandler().getMessage("top_10").orElse("%prefix% \u00a7aTop 10 players by %type% %action%:").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")).replace("%type%", type).replace("%action%", action));
        for (int i = 0; i < sortedEntries.size(); ++i) {
            UUID playerUUID = (UUID)((Map.Entry)sortedEntries.get(i)).getKey();
            String playerName = Bukkit.getPlayer((UUID)playerUUID).getName();
            int count = this.getCount((HarvestData)((Map.Entry)sortedEntries.get(i)).getValue(), type, isPlanted);
            sender.sendMessage(this.plugin.getMessageHandler().getMessage("top_10_player").orElse("%prefix% \u00a7a%i% %player%: %count%").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")).replace("%i%", String.valueOf(i + 1)).replace("%player%", playerName).replace("%count%", String.valueOf(count)));
        }
    }

    private void displayPagedList(CommandSender sender, String type, String action, int page, Map<UUID, HarvestData> playerData) {
        boolean isPlanted = action.equalsIgnoreCase("planted");
        Comparator<Map.Entry<UUID, HarvestData>> comparator = this.getComparator(type, isPlanted);
        if (comparator == null) {
            sender.sendMessage(this.plugin.getMessageHandler().getMessage("invalid_type").orElse("%prefix% \u00a7cInvalid type: %type%").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")).replace("%type%", type));
            return;
        }
        List sortedEntries = playerData.entrySet().stream().sorted(comparator).collect(Collectors.toList());
        int start = (page - 1) * 10;
        int end = Math.min(start + 10, sortedEntries.size());
        if (start >= sortedEntries.size()) {
            sender.sendMessage(this.plugin.getMessageHandler().getMessage("invalid_page").orElse("%prefix% \u00a7cInvalid page").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return;
        }
        sender.sendMessage(this.plugin.getMessageHandler().getMessage("players_page").orElse("%prefix% \u00a7aPlayers by %type% %action% (Page %page%):").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")).replace("%type%", type).replace("%action%", action).replace("%page%", String.valueOf(page)));
        for (int i = start; i < end; ++i) {
            UUID playerUUID = (UUID)((Map.Entry)sortedEntries.get(i)).getKey();
            String playerName = Bukkit.getPlayer((UUID)playerUUID).getName();
            int count = this.getCount((HarvestData)((Map.Entry)sortedEntries.get(i)).getValue(), type, isPlanted);
            sender.sendMessage(i + 1 + ". " + playerName + ": " + count);
        }
    }

    private int getCount(HarvestData data, String type, boolean isPlanted) {
        switch (type.toLowerCase()) {
            case "weed": {
                return isPlanted ? data.getWeedPlanted() : data.getWeedHarvested();
            }
            case "cocaine": {
                return isPlanted ? data.getCocainePlanted() : data.getCocaineHarvested();
            }
            case "tobacco": {
                return isPlanted ? data.getTobaccoPlanted() : data.getTobaccoHarvested();
            }
            case "all": {
                return isPlanted ? data.getTotalPlanted() : data.getTotalHarvested();
            }
        }
        return 0;
    }

    private Comparator<Map.Entry<UUID, HarvestData>> getComparator(String type, boolean isPlanted) {
        switch (type.toLowerCase()) {
            case "weed": {
                return isPlanted ? Comparator.comparingInt(entry -> ((HarvestData)entry.getValue()).getWeedPlanted()) : Comparator.comparingInt(entry -> ((HarvestData)entry.getValue()).getWeedHarvested());
            }
            case "cocaine": {
                return isPlanted ? Comparator.comparingInt(entry -> ((HarvestData)entry.getValue()).getCocainePlanted()) : Comparator.comparingInt(entry -> ((HarvestData)entry.getValue()).getCocaineHarvested());
            }
            case "tobacco": {
                return isPlanted ? Comparator.comparingInt(entry -> ((HarvestData)entry.getValue()).getTobaccoPlanted()) : Comparator.comparingInt(entry -> ((HarvestData)entry.getValue()).getTobaccoHarvested());
            }
            case "all": {
                return isPlanted ? Comparator.comparingInt(entry -> ((HarvestData)entry.getValue()).getTotalPlanted()) : Comparator.comparingInt(entry -> ((HarvestData)entry.getValue()).getTotalHarvested());
            }
        }
        return null;
    }
}

