/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.commands;

import de.lars.drugs.Drugs;
import de.lars.drugs.config.Configuration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class LanguageSwitchCommand
implements CommandExecutor {
    private final Drugs plugin;
    private final Configuration config;
    private final String LANGUAGES_DIR = "plugins/Drugs/languages/";
    private final String MESSAGES_FILE = "plugins/Drugs/messages.yml";

    public LanguageSwitchCommand(Drugs plugin, Configuration config) {
        this.config = config;
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        if (args2.length != 1) {
            sender.sendMessage(this.plugin.getMessageHandler().getMessage("wrong_usage").orElse("%prefix% \u00a7cWrong usage! Correct usage: %usage%").replace("%usage%", "/languageswitch <LANGUAGE>").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return false;
        }
        if (!sender.hasPermission("drugs.changelanguage")) {
            sender.sendMessage(this.plugin.getMessageHandler().getMessage("no_authorization").orElse("%prefix% \u00a7cYou dont have the rights to do this!").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return true;
        }
        String language = args2[0].toLowerCase();
        if (!this.isValidLanguage(language)) {
            sender.sendMessage(this.plugin.getMessageHandler().getMessage("supported_languages").orElse("%prefix% \u00a7aSupported Languages %languages%").replace("%languages%", "de, en, es, fr, ru, tr.").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return false;
        }
        File languageFile = new File("plugins/Drugs/languages/" + language + ".yml");
        File messagesFile = new File("plugins/Drugs/messages.yml");
        if (!languageFile.exists()) {
            sender.sendMessage(this.plugin.getMessageHandler().getMessage("language_file_not_found").orElse("%prefix% \u00a7cLanguage file not found: %language%").replace("%language%", languageFile.getPath()).replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return false;
        }
        try {
            Files.copy(languageFile.toPath(), messagesFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            sender.sendMessage(this.plugin.getMessageHandler().getMessage("language_switch_start").orElse("%prefix% \u00a7aLanguage switch started").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            this.plugin.getMessageHandler().checkifexist();
            this.plugin.getMessageHandler().reloadMessages();
            this.config.load();
            sender.sendMessage(this.plugin.getMessageHandler().getMessage("language_switch_finish").orElse("%prefix% \u00a7aLanguage switch finished").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
        }
        catch (IOException e) {
            e.printStackTrace();
            sender.sendMessage(this.plugin.getMessageHandler().getMessage("error_while_switch").orElse("%prefix% \u00a7cAn Error occured while switching the languages.").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
        }
        return true;
    }

    private boolean isValidLanguage(String language) {
        switch (language) {
            case "de": 
            case "en": 
            case "es": 
            case "fr": 
            case "ru": 
            case "tr": {
                return true;
            }
        }
        return false;
    }
}

