/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class Configuration
extends YamlConfiguration {
    protected static final Logger LOGGER = Logger.getLogger("Drugs");
    protected final File configFile;
    protected String templateName = null;
    protected static final Charset UTF8 = StandardCharsets.UTF_8;
    private Class<?> resourceClass = Configuration.class;
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadExecutor();
    private final AtomicInteger pendingDiskWrites = new AtomicInteger(0);
    private final AtomicBoolean transaction = new AtomicBoolean(false);
    private final byte[] byteBuffer = new byte[1024];

    public Configuration(File configFile) {
        this.configFile = configFile.getAbsoluteFile();
    }

    public synchronized void load() {
        FileInputStream inputStream2;
        if (this.pendingDiskWrites.get() != 0) {
            LOGGER.log(Level.INFO, "File {0} not read, because it's not written to disk", this.configFile);
            return;
        }
        if (!this.configFile.getParentFile().exists() && !this.configFile.getParentFile().mkdirs()) {
            LOGGER.log(Level.SEVERE, "Failed to create config file: " + this.configFile);
        }
        if (this.configFile.exists() && this.configFile.length() != 0L) {
            try {
                inputStream2 = new FileInputStream(this.configFile);
                try {
                    if (((InputStream)inputStream2).read() == 0) {
                        ((InputStream)inputStream2).close();
                        this.configFile.delete();
                    }
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                }
                finally {
                    try {
                        ((InputStream)inputStream2).close();
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            }
            catch (FileNotFoundException ex) {
                LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        if (!this.configFile.exists()) {
            if (this.templateName != null) {
                LOGGER.log(Level.INFO, "Creating config file from template: " + this.templateName);
                this.createFromTemplate();
            } else {
                return;
            }
        }
        try {
            inputStream2 = new FileInputStream(this.configFile);
            try {
                int length;
                long startSize = this.configFile.length();
                if (startSize > Integer.MAX_VALUE) {
                    throw new InvalidConfigurationException("File too big");
                }
                ByteBuffer buffer = ByteBuffer.allocate((int)startSize);
                while ((length = inputStream2.read(this.byteBuffer)) != -1) {
                    if (length > buffer.remaining()) {
                        ByteBuffer resize = ByteBuffer.allocate(buffer.capacity() + length - buffer.remaining());
                        int resizePosition = buffer.position();
                        buffer.rewind();
                        resize.put(buffer);
                        resize.position(resizePosition);
                        buffer = resize;
                    }
                    buffer.put(this.byteBuffer, 0, length);
                }
                buffer.rewind();
                CharBuffer data = CharBuffer.allocate(buffer.capacity());
                CharsetDecoder decoder = UTF8.newDecoder();
                CoderResult result = decoder.decode(buffer, data, true);
                if (result.isError()) {
                    buffer.rewind();
                    data.clear();
                    LOGGER.log(Level.INFO, "File " + this.configFile + " is not utf-8 encoded, trying " + Charset.defaultCharset().displayName());
                    decoder = Charset.defaultCharset().newDecoder();
                    result = decoder.decode(buffer, data, true);
                    if (result.isError()) {
                        throw new InvalidConfigurationException("Invalid characters in file " + this.configFile.getAbsolutePath());
                    }
                    decoder.flush(data);
                } else {
                    decoder.flush(data);
                }
                int end = data.position();
                data.rewind();
                this.loadFromString(data.subSequence(0, end).toString());
            }
            finally {
                inputStream2.close();
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (InvalidConfigurationException ex) {
            File broken = new File(this.configFile.getAbsolutePath() + ".broken." + System.currentTimeMillis());
            this.configFile.renameTo(broken);
            LOGGER.log(Level.SEVERE, "The file " + this.configFile + " is broken, it has been renamed to " + broken, ex.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFromTemplate() {
        InputStream inputStream2 = null;
        OutputStream outputStream2 = null;
        try {
            inputStream2 = this.resourceClass.getResourceAsStream(this.templateName);
            if (inputStream2 == null) {
                LOGGER.log(Level.SEVERE, "Could not find template file: " + this.templateName);
                return;
            }
            outputStream2 = new FileOutputStream(this.configFile);
            byte[] buffer = new byte[1024];
            int length = inputStream2.read(buffer);
            while (length > 0) {
                outputStream2.write(buffer, 0, length);
                length = inputStream2.read(buffer);
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Failed to write config file: " + this.configFile, ex);
        }
        finally {
            try {
                if (inputStream2 != null) {
                    inputStream2.close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            }
            try {
                if (outputStream2 != null) {
                    outputStream2.close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "Failed to close config file: " + this.configFile, ex);
            }
        }
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public File getFile() {
        return this.configFile;
    }

    public void setTemplateName(String templateName, Class<?> resourceClass) {
        this.templateName = templateName;
        this.resourceClass = resourceClass;
    }

    public void startTransaction() {
        this.transaction.set(true);
    }

    public void stopTransaction() {
        this.transaction.set(false);
        this.save();
    }

    public void save() {
        try {
            this.save(this.configFile);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void saveWithError() throws IOException {
        this.save(this.configFile);
    }

    public synchronized void save(File file) throws IOException {
        if (!this.transaction.get()) {
            this.delayedSave(file);
        }
    }

    public synchronized void forceSave() {
        try {
            Future<?> future = this.delayedSave(this.configFile);
            if (future != null) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public synchronized void cleanup() {
        this.forceSave();
    }

    private Future<?> delayedSave(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        String data = this.saveToString();
        if (data.length() == 0) {
            return null;
        }
        Future<?> future = EXECUTOR_SERVICE.submit(new WriteRunner(this.configFile, data, this.pendingDiskWrites));
        return future;
    }

    public boolean hasProperty(String path) {
        return this.isSet(path);
    }

    private static class WriteRunner
    implements Runnable {
        private final File configFile;
        private final String data;
        private final AtomicInteger pendingDiskWrites;

        private WriteRunner(File configFile, String data, AtomicInteger pendingDiskWrites) {
            this.configFile = configFile;
            this.data = data;
            this.pendingDiskWrites = pendingDiskWrites;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            File file = this.configFile;
            synchronized (file) {
                if (this.pendingDiskWrites.get() > 1) {
                    this.pendingDiskWrites.decrementAndGet();
                    return;
                }
                try {
                    File parentDir = this.configFile.getParentFile();
                    if (!parentDir.exists() && !parentDir.mkdirs()) {
                        LOGGER.log(Level.SEVERE, "Failed to create config directories: " + parentDir);
                        return;
                    }
                    if (!this.configFile.exists()) {
                        LOGGER.log(Level.INFO, "Creating Empty config file: " + this.configFile);
                        if (!this.configFile.createNewFile()) {
                            LOGGER.log(Level.SEVERE, "Failed to create config file: " + this.configFile);
                            return;
                        }
                    }
                    try (FileOutputStream outputStream2 = new FileOutputStream(this.configFile);
                         OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream2, UTF8);){
                        writer.write(this.data);
                    }
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                }
                finally {
                    this.pendingDiskWrites.decrementAndGet();
                }
                return;
            }
        }
    }
}

