/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.crafting;

import de.lars.drugs.Drugs;
import de.lars.drugs.config.Configuration;
import de.lars.drugs.handler.CreatedItems;
import de.lars.drugs.manager.CustomWeedItem;
import de.lars.drugs.manager.CustomWeedManager;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class CustomWeedCrafting {
    private final Configuration config;
    private final Drugs plugin;

    public CustomWeedCrafting(Configuration config, Drugs plugin) {
        this.plugin = plugin;
        this.config = config;
    }

    public void loadCraftingRecipes() {
        ConfigurationSection weedSection = this.config.getConfigurationSection("CustomWeedSeed");
        if (weedSection == null) {
            this.plugin.getLogger().warning("No 'CustomWeedSeed' section found in config!");
            return;
        }
        CustomWeedManager customWeedManager = new CustomWeedManager(this.plugin);
        int recipeCount = 1;
        for (String key : weedSection.getKeys(false)) {
            NamespacedKey recipeKey;
            ConfigurationSection weedConfig = weedSection.getConfigurationSection(key);
            if (weedConfig == null) continue;
            String weedName = weedConfig.getString("WeedName", "Unknown Weed");
            int customModelData = weedConfig.getInt("WeedCustomModelData", 0);
            List<String> lore = Collections.singletonList(weedConfig.getString("WeedLore", ""));
            CustomWeedItem customWeedItem = customWeedManager.getWeed(weedName);
            if (customWeedItem == null) {
                this.plugin.getLogger().warning("No custom weed item found for " + weedName);
                continue;
            }
            ItemStack joint = customWeedManager.createWeedItem(customWeedItem);
            ItemMeta meta = joint.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(weedName + " Joint");
                meta.setLore(lore);
                meta.setCustomModelData(Integer.valueOf(customModelData));
                joint.setItemMeta(meta);
            }
            if (Bukkit.getRecipe((NamespacedKey)(recipeKey = new NamespacedKey((Plugin)this.plugin, "custom_weed_" + recipeCount))) != null) {
                this.plugin.getLogger().warning("Skipping duplicate recipe for: " + weedName);
                continue;
            }
            ShapedRecipe recipe = new ShapedRecipe(recipeKey, joint);
            recipe.shape(new String[]{"ABC", "DEF", "GHI"});
            boolean hasValidIngredient = false;
            Map<String, Character> materialMap = this.getMaterialMap();
            int slotIndex = 0;
            this.plugin.getLogger().info("Defining recipe for " + weedName + " joint...");
            for (Map.Entry<String, Character> entry : materialMap.entrySet()) {
                if (slotIndex >= 9) break;
                String materialKey = weedConfig.getString("Material" + entry.getKey(), "AIR");
                ItemStack item = this.getItemFromConfig(materialKey, customWeedManager);
                this.plugin.getLogger().info("Slot " + entry.getKey() + ": MaterialKey = " + materialKey + " -> " + item.getType());
                if (item.getType() != Material.AIR) {
                    recipe.setIngredient(entry.getValue().charValue(), item.getType());
                    hasValidIngredient = true;
                }
                ++slotIndex;
            }
            if (hasValidIngredient) {
                Bukkit.addRecipe((Recipe)recipe);
                this.plugin.getLogger().info("Registered crafting recipe for: " + weedName);
            } else {
                this.plugin.getLogger().warning("Skipped recipe for " + weedName + " (No valid ingredients)");
            }
            ++recipeCount;
        }
    }

    private Map<String, Character> getMaterialMap() {
        return Map.of("A", Character.valueOf('A'), "B", Character.valueOf('B'), "C", Character.valueOf('C'), "D", Character.valueOf('D'), "E", Character.valueOf('E'), "F", Character.valueOf('F'), "G", Character.valueOf('G'), "H", Character.valueOf('H'), "I", Character.valueOf('I'));
    }

    private ItemStack getItemFromConfig(String configValue, CustomWeedManager customWeedManager) {
        if (configValue.startsWith("%") && configValue.endsWith("%")) {
            this.plugin.getLogger().warning("Configvalue detected: " + configValue);
            String weedName = configValue.substring(1, configValue.length() - 1);
            weedName = ChatColor.stripColor((String)weedName);
            this.plugin.getLogger().warning("Configvalue now: " + weedName);
            CustomWeedItem customWeedItem = customWeedManager.getWeed(weedName);
            if (customWeedItem != null) {
                return customWeedManager.createWeedItem(customWeedItem);
            }
            if (weedName.equals("longpapes")) {
                return CreatedItems.createLongPapes(this.plugin, this.config);
            }
            if (weedName.equals("zippo")) {
                return CreatedItems.createZippo(this.plugin, this.config);
            }
            this.plugin.getLogger().warning("Custom weed not found: " + weedName);
            return new ItemStack(Material.AIR);
        }
        Material material = Material.matchMaterial((String)configValue);
        return material != null ? new ItemStack(material) : new ItemStack(Material.AIR);
    }
}

