/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.crafting.LSD;

import de.lars.drugs.Drugs;
import de.lars.drugs.config.Configuration;
import de.lars.drugs.config.CraftingConfiguration;
import de.lars.drugs.handler.CreatedItems;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;

public class NatriumCrafting
implements Listener {
    private final Drugs plugin;
    private final Configuration config;
    private final CraftingConfiguration craftingconfig;

    public NatriumCrafting(Drugs plugin, Configuration config, CraftingConfiguration craftingconfig) {
        this.plugin = plugin;
        this.config = config;
        this.craftingconfig = craftingconfig;
    }

    public void registerRecipes() {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "sodium_recipe");
        ShapedRecipe recipe = new ShapedRecipe(key, CreatedItems.createNatrium(this.plugin, this.config));
        recipe.shape(new String[]{"ABC", "DEF", "GHI"});
        this.setIngredientIfNotAir(recipe, 'A', this.craftingconfig.getString("sodium_material_a", "AIR"));
        this.setIngredientIfNotAir(recipe, 'B', this.craftingconfig.getString("sodium_material_b", "AIR"));
        this.setIngredientIfNotAir(recipe, 'C', this.craftingconfig.getString("sodium_material_c", "AIR"));
        this.setIngredientIfNotAir(recipe, 'D', this.craftingconfig.getString("sodium_material_d", "AIR"));
        this.setIngredientIfNotAir(recipe, 'E', this.craftingconfig.getString("sodium_material_e", "AIR"));
        this.setIngredientIfNotAir(recipe, 'F', this.craftingconfig.getString("sodium_material_f", "AIR"));
        this.setIngredientIfNotAir(recipe, 'G', this.craftingconfig.getString("sodium_material_g", "AIR"));
        this.setIngredientIfNotAir(recipe, 'H', this.craftingconfig.getString("sodium_material_h", "AIR"));
        this.setIngredientIfNotAir(recipe, 'I', this.craftingconfig.getString("sodium_material_i", "AIR"));
        Bukkit.addRecipe((Recipe)recipe);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    private void setIngredientIfNotAir(ShapedRecipe recipe, char key, String materialName) {
        Material material;
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            materialName = PlaceholderAPI.setPlaceholders(null, (String)materialName);
        }
        if ((material = Material.getMaterial((String)materialName)) != null && material != Material.AIR) {
            recipe.setIngredient(key, material);
        } else {
            ItemStack customItem = this.getCustomItem(materialName);
            if (customItem != null) {
                recipe.setIngredient(key, (RecipeChoice)new RecipeChoice.ExactChoice(customItem));
            }
        }
    }

    private ItemStack getCustomItem(String itemName) {
        switch (itemName.toLowerCase()) {
            case "%hydrogen%": {
                return CreatedItems.createHydrogen(this.plugin, this.config);
            }
            case "%lsd%": {
                return CreatedItems.createLSD(this.plugin, this.config);
            }
            case "%lysergicacid%": {
                return CreatedItems.createLysergicAcid(this.plugin, this.config);
            }
            case "%sodium%": {
                return CreatedItems.createNatrium(this.plugin, this.config);
            }
            case "%propanolamine%": {
                return CreatedItems.createpropanolamine(this.plugin, this.config);
            }
            case "%cigarette%": {
                return CreatedItems.createcigarette(this.plugin, this.config);
            }
            case "%glue%": {
                return CreatedItems.createGlue(this.plugin, this.config);
            }
            case "%joint%": {
                return CreatedItems.createjoint(this.plugin, this.config);
            }
            case "%longpapes%": {
                return CreatedItems.createLongPapes(this.plugin, this.config);
            }
            case "%papes%": {
                return CreatedItems.getPapeItem(this.plugin, this.config);
            }
            case "%zippo%": {
                return CreatedItems.createZippo(this.plugin, this.config);
            }
            case "%weedseed%": {
                return CreatedItems.getSuperSeedItem(this.plugin);
            }
            case "%cocaineseed%": {
                return CreatedItems.getCocainePlantItem(this.plugin);
            }
            case "%tobaccoseed%": {
                return CreatedItems.getTobaccoPlant(this.plugin);
            }
            case "%weed%": {
                return CreatedItems.getSuperWheatItem(this.plugin);
            }
            case "%shroom%": {
                return CreatedItems.getShroomItem(this.plugin);
            }
            case "%cocaine%": {
                return CreatedItems.getCocaineItem(this.plugin);
            }
            case "%tobacco%": {
                return CreatedItems.getTobaccoItem(this.plugin);
            }
            case "%ecstasy%": {
                return CreatedItems.createXTC(this.plugin, this.config);
            }
            case "%xtc%": {
                return CreatedItems.createXTC(this.plugin, this.config);
            }
            case "%isosafrole%": {
                return CreatedItems.createIsoSafrole(this.plugin, this.config);
            }
            case "%piperonal%": {
                return CreatedItems.createpiperonal(this.plugin, this.config);
            }
            case "%safrole%": {
                return CreatedItems.createSafrole(this.plugin, this.config);
            }
            case "%phenyl%": {
                return CreatedItems.createPhenyl(this.plugin, this.config);
            }
            case "%speed%": {
                return CreatedItems.createSpeed(this.plugin, this.config);
            }
            case "%heroinliquid%": {
                return CreatedItems.createLiquid(this.plugin, this.config);
            }
            case "%heroin%": {
                return CreatedItems.createHeroin(this.plugin, this.config);
            }
            case "%syringe%": {
                return CreatedItems.createSyringe(this.plugin, this.config);
            }
            case "%drugtest%": {
                return CreatedItems.createDrugtest(this.plugin, this.config);
            }
            case "%crack%": {
                return CreatedItems.getCrackitem(this.plugin);
            }
        }
        return null;
    }

    @EventHandler
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        HumanEntity player;
        CraftingInventory inventory = event.getInventory();
        ItemStack result = inventory.getResult();
        if (result != null && result.isSimilar(CreatedItems.createLiquid(this.plugin, this.config)) && !(player = event.getView().getPlayer()).hasPermission("drugs.craft.sodium")) {
            inventory.setResult(new ItemStack(Material.AIR));
        }
    }
}

