/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.data;

import de.lars.drugs.Drugs;
import de.lars.drugs.data.HarvestData;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class DataManager {
    private final File dataFile = new File(Drugs.getInstance().getDataFolder(), "saves/harvestdata.yml");
    private final FileConfiguration config;

    public DataManager() {
        if (!this.dataFile.exists()) {
            try {
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    public void saveHarvestData(Map<UUID, HarvestData> playerData) throws IOException {
        if (playerData.isEmpty()) {
            // empty if block
        }
        this.config.set("player_data", null);
        for (UUID uuid : playerData.keySet()) {
            HarvestData data = playerData.get(uuid);
            String path = "player_data." + uuid.toString();
            this.config.set(path + ".weed_planted", (Object)data.getWeedPlanted());
            this.config.set(path + ".weed_harvested", (Object)data.getWeedHarvested());
            this.config.set(path + ".tobacco_planted", (Object)data.getTobaccoPlanted());
            this.config.set(path + ".tobacco_harvested", (Object)data.getTobaccoHarvested());
            this.config.set(path + ".cocaine_planted", (Object)data.getCocainePlanted());
            this.config.set(path + ".cocaine_harvested", (Object)data.getCocaineHarvested());
            this.config.set(path + ".total_planted", (Object)data.getTotalPlanted());
            this.config.set(path + ".total_harvested", (Object)data.getTotalHarvested());
        }
        try {
            this.config.save(this.dataFile);
        }
        catch (IOException e) {
            Bukkit.getLogger().severe("[Drugs] Failed to save data: " + e.getMessage());
        }
    }

    public Map<UUID, HarvestData> loadHarvestData() throws IOException {
        HashMap<UUID, HarvestData> playerData = new HashMap<UUID, HarvestData>();
        try {
            if (this.config.contains("player_data")) {
                for (String uuidString : this.config.getConfigurationSection("player_data").getKeys(false)) {
                    try {
                        UUID uuid = UUID.fromString(uuidString);
                        int weedPlanted = this.config.getInt("player_data." + uuidString + ".weed_planted", 0);
                        int weedHarvested = this.config.getInt("player_data." + uuidString + ".weed_harvested", 0);
                        int tobaccoPlanted = this.config.getInt("player_data." + uuidString + ".tobacco_planted", 0);
                        int tobaccoHarvested = this.config.getInt("player_data." + uuidString + ".tobacco_harvested", 0);
                        int cocainePlanted = this.config.getInt("player_data." + uuidString + ".cocaine_planted", 0);
                        int cocaineHarvested = this.config.getInt("player_data." + uuidString + ".cocaine_harvested", 0);
                        int totalPlanted = this.config.getInt("player_data." + uuidString + ".total_planted", 0);
                        int totalHarvested = this.config.getInt("player_data." + uuidString + ".total_harvested", 0);
                        HarvestData data = new HarvestData(weedPlanted, weedHarvested, tobaccoPlanted, tobaccoHarvested, cocainePlanted, cocaineHarvested, totalPlanted, totalHarvested);
                        playerData.put(uuid, data);
                    }
                    catch (IllegalArgumentException e) {
                        Bukkit.getLogger().warning("[Drugs] Invalid UUID format in configuration: " + uuidString);
                    }
                }
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().severe("[Drugs] Error while loading harvest data: " + e.getMessage());
            e.printStackTrace();
            throw new IOException("Failed to load harvest data", e);
        }
        return playerData;
    }
}

