/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.drugshop.commands;

import de.lars.drugs.Drugs;
import de.lars.drugs.config.Configuration;
import de.lars.drugs.handler.CreatedItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BuyCommand {
    private final Configuration config;
    private final Drugs plugin;
    private final Map<String, Double> itemPrices;
    private boolean vaultInstalled;

    public BuyCommand(Drugs plugin, Configuration config) {
        this.config = config;
        this.plugin = plugin;
        this.itemPrices = new HashMap<String, Double>();
        this.itemPrices.put("hydrogen", config.getDouble("hydrogen_price", 100.0));
        this.itemPrices.put("lsd", config.getDouble("lsd_price", 100.0));
        this.itemPrices.put("lysergicacid", config.getDouble("lysergicacid_price", 100.0));
        this.itemPrices.put("sodium", config.getDouble("sodium_price", 100.0));
        this.itemPrices.put("propanolamine", config.getDouble("propanolamine", 100.0));
        this.itemPrices.put("cigarette", config.getDouble("cigarette", 100.0));
        this.itemPrices.put("glue", config.getDouble("glue", 100.0));
        this.itemPrices.put("joint", config.getDouble("joint", 100.0));
        this.itemPrices.put("longpapes", config.getDouble("longpapes", 100.0));
        this.itemPrices.put("papes", config.getDouble("papes", 100.0));
        this.itemPrices.put("zippo", config.getDouble("zippo", 100.0));
        this.itemPrices.put("weedseed", config.getDouble("weedseed", 100.0));
        this.itemPrices.put("cocaineseed", config.getDouble("cocaineseed", 100.0));
        this.itemPrices.put("tobaccoseed", config.getDouble("tobaccoseed", 100.0));
        this.itemPrices.put("weed", config.getDouble("weed", 100.0));
        this.itemPrices.put("shroom", config.getDouble("shroom", 100.0));
        this.itemPrices.put("cocaine", config.getDouble("cocaine", 100.0));
        this.itemPrices.put("tobacco", config.getDouble("tobacco", 100.0));
        this.itemPrices.put("xtc", config.getDouble("xtc", 100.0));
        this.itemPrices.put("isosafrole", config.getDouble("isosafrole", 100.0));
        this.itemPrices.put("piperonal", config.getDouble("piperonal", 100.0));
        this.itemPrices.put("safrole", config.getDouble("safrole", 100.0));
        this.itemPrices.put("speed", config.getDouble("speed", 100.0));
        this.itemPrices.put("phenyl", config.getDouble("phenyl", 100.0));
        this.itemPrices.put("heroinliquid", config.getDouble("heroinliquid", 100.0));
        this.itemPrices.put("heroin", config.getDouble("heroin", 100.0));
        this.itemPrices.put("syringe", config.getDouble("syringe", 100.0));
        this.vaultInstalled = plugin.getServer().getPluginManager().getPlugin("Vault") != null;
    }

    public boolean execute(CommandSender sender, String[] args2) {
        ItemStack drugItem;
        int amount;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessageHandler().getMessage("only_players").orElse("%prefix% \u00a7cOnly players can execute this command!").replace("prefix", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return true;
        }
        Player player = (Player)sender;
        if (args2.length < 4) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("wrong_usage").orElse("%prefix% \u00a7cWrong usage! Correct usage: %usage%").replace("%usage%", "/drugs buy DRUGTYPE DRUGNAME AMOUNT").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return true;
        }
        if (!player.hasPermission("drugs.economy.buy")) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("no_authorization").orElse("%prefix% \u00a7cYou don't have the rights to do this!").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return true;
        }
        if (!this.vaultInstalled) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("vault_not_installed").orElse("%prefix% \u00a7cVault is not installed! Contact an Administrator!").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return true;
        }
        String drug = args2[2].toLowerCase();
        try {
            amount = Integer.parseInt(args2[3]);
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("invalid_amount").orElse("%prefix% \u00a7eInvalid amount specified!").replace("prefix", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return true;
        }
        String drugname = args2[2];
        if (!this.itemPrices.containsKey(drug)) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("invalid_drug").orElse("%prefix% \u00a7eInvalid drug specified!").replace("prefix", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return true;
        }
        if (!player.hasPermission("drugs.economy.buy")) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("no_permission_to_buy").orElse("%prefix% \u00a7eInvalid drug specified!").replace("prefix", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
        }
        double price = this.itemPrices.get(drug) * (double)amount;
        BuyCommand buyCommand = this;
        if (!buyCommand.plugin.getEconomy().withdrawPlayer((OfflinePlayer)player, price).transactionSuccess()) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("not_enough_money").orElse("%prefix% \u00a7cYou don't have enough money to buy this!").replace("prefix", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return true;
        }
        switch (drug) {
            case "hydrogen": {
                drugItem = CreatedItems.createHydrogen(this.plugin, this.config);
                break;
            }
            case "lsd": {
                drugItem = CreatedItems.createLSD(this.plugin, this.config);
                break;
            }
            case "lysergicacid": {
                drugItem = CreatedItems.createLysergicAcid(this.plugin, this.config);
                break;
            }
            case "sodium": {
                drugItem = CreatedItems.createNatrium(this.plugin, this.config);
                break;
            }
            case "propanolamine": {
                drugItem = CreatedItems.createpropanolamine(this.plugin, this.config);
                break;
            }
            case "cigarette": {
                drugItem = CreatedItems.createcigarette(this.plugin, this.config);
                break;
            }
            case "glue": {
                drugItem = CreatedItems.createGlue(this.plugin, this.config);
                break;
            }
            case "joint": {
                drugItem = CreatedItems.createjoint(this.plugin, this.config);
                break;
            }
            case "longpapes": {
                drugItem = CreatedItems.createLongPapes(this.plugin, this.config);
                break;
            }
            case "papes": {
                drugItem = CreatedItems.getPapeItem(this.plugin, this.config);
                break;
            }
            case "zippo": {
                drugItem = CreatedItems.createZippo(this.plugin, this.config);
                break;
            }
            case "weedseed": {
                drugItem = CreatedItems.getSuperSeedItem(this.plugin);
                break;
            }
            case "cocaineseed": {
                drugItem = CreatedItems.getCocainePlantItem(this.plugin);
                break;
            }
            case "tobaccoseed": {
                drugItem = CreatedItems.getTobaccoPlant(this.plugin);
                break;
            }
            case "weed": {
                drugItem = CreatedItems.getSuperWheatItem(this.plugin);
                break;
            }
            case "shroom": {
                drugItem = CreatedItems.getShroomItem(this.plugin);
                break;
            }
            case "cocaine": {
                drugItem = CreatedItems.getCocaineItem(this.plugin);
                break;
            }
            case "tobacco": {
                drugItem = CreatedItems.getTobaccoItem(this.plugin);
                break;
            }
            case "xtc": {
                drugItem = CreatedItems.createXTC(this.plugin, this.config);
                break;
            }
            case "isosafrole": {
                drugItem = CreatedItems.createIsoSafrole(this.plugin, this.config);
                break;
            }
            case "piperonal": {
                drugItem = CreatedItems.createpiperonal(this.plugin, this.config);
                break;
            }
            case "safrole": {
                drugItem = CreatedItems.createSafrole(this.plugin, this.config);
                break;
            }
            case "speed": {
                drugItem = CreatedItems.createSpeed(this.plugin, this.config);
                break;
            }
            case "phenyl": {
                drugItem = CreatedItems.createPhenyl(this.plugin, this.config);
                break;
            }
            case "heroinliquid": {
                drugItem = CreatedItems.createLiquid(this.plugin, this.config);
                break;
            }
            case "heroin": {
                drugItem = CreatedItems.createHeroin(this.plugin, this.config);
                break;
            }
            case "syringe": {
                drugItem = CreatedItems.createSyringe(this.plugin, this.config);
                break;
            }
            default: {
                player.sendMessage(this.plugin.getMessageHandler().getMessage("invalid_drug").orElse("%prefix% \u00a7eInvalid drug specified!").replace("prefix", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                return true;
            }
        }
        drugItem.setAmount(amount);
        player.getInventory().addItem(new ItemStack[]{drugItem});
        player.sendMessage(this.plugin.getMessageHandler().getMessage("buy_success").orElse("%prefix% \u00a7aYou have successfully bought %amount% %item%!").replace("%amount%", String.valueOf(amount)).replace("%item%", drugname).replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args2) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args2.length == 3 && args2[1].equalsIgnoreCase("ecstasy")) {
            completions.add("IsoSafrole");
            completions.add("safrole");
            completions.add("piperonal");
            completions.add("XTC");
        } else if (args2.length == 3 && args2[1].equalsIgnoreCase("lsd")) {
            completions.add("Hydrogen");
            completions.add("LSD");
            completions.add("Lysergicacid");
            completions.add("propanolamine");
            completions.add("Sodium");
        } else if (args2.length == 3 && args2[1].equalsIgnoreCase("cigarette")) {
            completions.add("Cigarette");
            completions.add("papes");
            completions.add("Tobacco");
            completions.add("TobaccoSeed");
            completions.add("Zippo");
        } else if (args2.length == 3 && args2[1].equalsIgnoreCase("weed")) {
            completions.add("Glue");
            completions.add("Joint");
            completions.add("Longpapes");
            completions.add("Weed");
            completions.add("WeedSeed");
            completions.add("Zippo");
        } else if (args2.length == 3 && args2[1].equalsIgnoreCase("cocaine")) {
            completions.add("Cocaine");
            completions.add("CocaineSeed");
        } else if (args2.length == 3 && args2[1].equalsIgnoreCase("speed")) {
            completions.add("Speed");
            completions.add("Phenyl");
        } else if (args2.length == 3 && args2[1].equalsIgnoreCase("heroin")) {
            completions.add("Heroin");
            completions.add("Heroinliquid");
            completions.add("Syringe");
        } else if (args2.length == 3 && args2[1].equalsIgnoreCase("shrooms")) {
            completions.add("Shroom");
        } else if (args2.length == 2 && args2[0].equalsIgnoreCase("give")) {
            completions.add("cigarette");
            completions.add("cocaine");
            completions.add("ecstasy");
            completions.add("lsd");
            completions.add("shrooms");
            completions.add("weed");
            completions.add("speed");
            completions.add("heroin");
        } else if (args2.length == 1 && "drugs".startsWith(args2[0].toLowerCase())) {
            completions.add("buy");
        }
        return completions;
    }
}

