/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.drugshop.commands;

import de.lars.drugs.Drugs;
import de.lars.drugs.config.Configuration;
import de.lars.drugs.handler.CreatedItems;
import java.util.List;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SellCommand {
    private final Drugs plugin;
    private final Economy economy;
    private final Configuration config;

    public SellCommand(Drugs plugin, Economy economy, Configuration config) {
        this.plugin = plugin;
        this.economy = economy;
        this.config = config;
    }

    public boolean execute(CommandSender sender, String[] args2) {
        int amount;
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        if (args2.length != 3) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("wrong_usage").orElse("%prefix% \u00a7cWrong usage! Correct usage: %usage%").replace("%usage%", "/drugs sell DRUGNAME AMOUNT").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return true;
        }
        if (!player.hasPermission("drugs.economy.sell")) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("no_authorization").orElse("%prefix% \u00a7cYou don't have the rights to do this!").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return true;
        }
        String drugName = args2[1];
        try {
            amount = Integer.parseInt(args2[2]);
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("invalid_amount").orElse("%prefix% \u00a7eInvalid amount specified!").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return true;
        }
        List<ItemStack> allItems = CreatedItems.getAllItems(this.plugin, this.config);
        ItemStack targetItem = null;
        double pricePerItem = 0.0;
        for (ItemStack itemStack : allItems) {
            String displayName;
            if (itemStack == null || itemStack.getItemMeta() == null || !(displayName = ChatColor.stripColor((String)itemStack.getItemMeta().getDisplayName()).toLowerCase()).equals(drugName.toLowerCase())) continue;
            targetItem = itemStack;
            pricePerItem = this.config.getDouble("Sell." + drugName.toLowerCase() + ".Price", -1.0);
            break;
        }
        if (targetItem == null || pricePerItem <= 0.0) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("invalid_drug").orElse("%prefix% \u00a7eInvalid drug specified!").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return true;
        }
        int playerItemCount = 0;
        for (ItemStack inventoryItem : player.getInventory().getContents()) {
            if (inventoryItem == null || !inventoryItem.isSimilar(targetItem)) continue;
            playerItemCount += inventoryItem.getAmount();
        }
        if (playerItemCount < amount) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("not_enough_items").orElse("%prefix% \u00a7eYou dont have enough items in your inventory to sell them.").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return true;
        }
        int n = amount;
        for (ItemStack inventoryItem : player.getInventory().getContents()) {
            int n2;
            if (inventoryItem == null || !inventoryItem.isSimilar(targetItem)) continue;
            int inventoryAmount = inventoryItem.getAmount();
            if (inventoryAmount <= n2) {
                player.getInventory().remove(inventoryItem);
                n2 -= inventoryAmount;
            } else {
                inventoryItem.setAmount(inventoryAmount - n2);
                n2 = 0;
            }
            if (n2 <= 0) break;
        }
        double earnings = (double)amount * pricePerItem;
        SellCommand sellCommand = this;
        sellCommand.plugin.getEconomy().depositPlayer((OfflinePlayer)player, earnings);
        player.sendMessage(this.plugin.getMessageHandler().getMessage("sell_success").orElse("%prefix% \u00a7eYou successfully sold %amount% %drugname% for %earnings%!").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")).replace("%amount%", String.valueOf(amount)).replace("%drugname%", drugName).replace("%earnings%", String.valueOf(earnings)));
        return true;
    }
}

