/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.handler;

import de.lars.drugs.Drugs;
import de.lars.drugs.config.Configuration;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.ChatColor;

public class MessageHandler {
    private final Drugs plugin;
    private final Map<String, String> messages;
    private Configuration messageConfig;

    public MessageHandler(Drugs plugin) {
        this.plugin = plugin;
        this.messages = new HashMap<String, String>();
        this.messageConfig = new Configuration(new File(plugin.getDataFolder(), "messages.yml"));
        this.messageConfig.load();
        this.checkifexist();
        this.reloadMessages();
    }

    public void checkifexist() {
        String language = this.plugin.getConfig().getString("language", "en.yml");
        String[] lang = language.split("\\.");
        String configLanguage = this.messageConfig.getString("language");
        if (configLanguage != null && !configLanguage.equalsIgnoreCase(lang[0])) {
            this.messageConfig.getFile().delete();
            this.messageConfig = new Configuration(new File(this.plugin.getDataFolder(), "messages.yml"));
            this.messageConfig.setTemplateName("/languages/" + language);
        }
    }

    public void reloadMessages() {
        this.messages.clear();
        this.messageConfig.load();
        for (String key : this.messageConfig.getKeys(false)) {
            this.messages.put(key.toLowerCase(), ChatColor.translateAlternateColorCodes((char)'&', (String)this.messageConfig.getString(key)));
        }
    }

    public Optional<String> getMessage(String key) {
        return Optional.ofNullable(this.messages.get(key.toLowerCase()));
    }
}

