/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.listener;

import de.lars.drugs.Drugs;
import de.lars.drugs.manager.BlackMarketManager;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class BlackMarketListener
implements Listener {
    private final Drugs plugin;
    private final BlackMarketManager blackMarketManager;

    public BlackMarketListener(BlackMarketManager blackMarketManager, Drugs plugin) {
        this.blackMarketManager = blackMarketManager;
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getView().getTitle().equals(this.plugin.getMessageHandler().getMessage("blackmarket_name").orElse("\u00a7eBlack Market"))) {
            event.setCancelled(true);
            Player player = (Player)event.getWhoClicked();
            ItemStack clickedItem = event.getCurrentItem();
            if (clickedItem == null || !clickedItem.hasItemMeta()) {
                return;
            }
            String displayName = ChatColor.stripColor((String)clickedItem.getItemMeta().getDisplayName());
            if (this.plugin.getMessageHandler().getMessage("blackmarket_back_page").orElse("\u00a7ePrevious page").equals(displayName)) {
                int currentPage = this.getPageFromTitle(event.getView().getTitle());
                this.blackMarketManager.openBlackMarket(player, currentPage - 1);
            } else if (this.plugin.getMessageHandler().getMessage("blackmarket_next_page").orElse("\u00a7eNext page").equals(displayName)) {
                int currentPage = this.getPageFromTitle(event.getView().getTitle());
                this.blackMarketManager.openBlackMarket(player, currentPage + 1);
            } else {
                this.blackMarketManager.handlePurchase(player, clickedItem);
            }
        }
    }

    private int getPageFromTitle(String title) {
        String[] parts = ChatColor.stripColor((String)title).split(" ");
        return parts.length > 2 ? Integer.parseInt(parts[2]) : 1;
    }
}

