/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.listener.DrugEffectListener;

import de.lars.drugs.Drugs;
import de.lars.drugs.config.Configuration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class CustomJointEffectListener
implements Listener {
    private final Drugs plugin;
    private final Configuration config;
    private final Set<UUID> jointUsers = new HashSet<UUID>();

    public CustomJointEffectListener(Drugs plugin, Configuration config) {
        this.plugin = plugin;
        this.config = config;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        ItemStack item;
        Player player = event.getPlayer();
        if (event.getHand() == EquipmentSlot.HAND && (item = player.getInventory().getItemInMainHand()) != null && item.getType() == Material.STICK && item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
            String itemName = item.getItemMeta().getDisplayName();
            for (String weedType : this.config.getConfigurationSection("CustomWeedSeed").getKeys(false)) {
                String expectedName = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("CustomWeedSeed." + weedType + ".WeedName", "")) + " Joint";
                if (!itemName.equals(expectedName)) continue;
                this.applyEffects(player, weedType);
                item.setAmount(item.getAmount() - 1);
                return;
            }
        }
    }

    private void applyEffects(final Player player, String weedType) {
        List effects = this.config.getStringList("CustomWeedSeed." + weedType + ".Effects");
        for (String effectString : effects) {
            String[] parts = effectString.split(":");
            if (parts.length != 3) continue;
            try {
                PotionEffectType effectType = PotionEffectType.getByName((String)parts[0].toUpperCase());
                int amplifier = Integer.parseInt(parts[1]) - 1;
                int duration = Integer.parseInt(parts[2]) * 20;
                if (effectType == null) continue;
                player.addPotionEffect(new PotionEffect(effectType, duration, amplifier));
            }
            catch (NumberFormatException e) {
                this.plugin.getLogger().warning("Ung\u00fcltiges Effektformat f\u00fcr " + weedType + ": " + effectString);
            }
        }
        player.spawnParticle(Particle.SMOKE_LARGE, player.getLocation(), 5);
        player.sendMessage(this.plugin.getMessageHandler().getMessage("druginfo").orElse("%prefix% You took %drug%").replace("%drug%", this.config.getString("CustomWeedSeed." + weedType + ".WeedName", "Joint")).replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("[Drugs]")));
        this.jointUsers.add(player.getUniqueId());
        new BukkitRunnable(){

            public void run() {
                CustomJointEffectListener.this.jointUsers.remove(player.getUniqueId());
            }
        }.runTaskLater((Plugin)this.plugin, (long)(this.config.getInt("Weed_value_detectable", 30) * 20));
    }

    public boolean hasPlayerTakenJoint(Player player) {
        return this.jointUsers.contains(player.getUniqueId());
    }
}

