/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.listener.DrugEffectListener;

import de.lars.drugs.Drugs;
import de.lars.drugs.config.Configuration;
import de.lars.drugs.listener.SleepBlockListener;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class LSDEffectListener
implements Listener {
    private final Configuration config;
    private final double lsdkiller;
    private final Drugs plugin;
    private final Set<UUID> lsdUsers;

    public LSDEffectListener(Drugs plugin, Configuration config) {
        this.config = config;
        this.plugin = plugin;
        this.lsdkiller = config.getDouble("lsd_kill");
        this.lsdUsers = new HashSet<UUID>();
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        final Player player = event.getPlayer();
        ItemStack item = player.getItemInHand();
        if (item != null && item.getType() == Material.PAPER && item.hasItemMeta() && item.getItemMeta().hasDisplayName() && item.getItemMeta().getDisplayName().equals(this.plugin.getMessageHandler().getMessage("lsd_name").orElse("\u00a7eLSD")) && event.getAction().toString().contains("RIGHT_CLICK")) {
            int amount = item.getAmount();
            if (amount > 1) {
                item.setAmount(amount - 1);
            } else {
                player.setItemInHand(null);
            }
            this.applyEffects(player);
            this.lsdUsers.add(player.getUniqueId());
            player.sendMessage(this.plugin.getMessageHandler().getMessage("druginfo").orElse("%prefix% You took %drug%").replace("%drug%", this.plugin.getMessageHandler().getMessage("lsd_name").orElse("\u00a7eLSD")));
            new BukkitRunnable(){

                public void run() {
                    LSDEffectListener.this.lsdUsers.remove(player.getUniqueId());
                    player.sendMessage(LSDEffectListener.this.plugin.getMessageHandler().getMessage("druginfo_end").orElse("%prefix% %drug% is no longer detectable").replace("%drug%", LSDEffectListener.this.plugin.getMessageHandler().getMessage("lsd_name").orElse("\u00a7eLSD")).replace("%prefix%", LSDEffectListener.this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                }
            }.runTaskLater((Plugin)this.plugin, (long)(this.config.getInt("LSD_value_detectable") * 20));
            Random random = new Random();
            if (random.nextDouble() < this.lsdkiller) {
                player.damage(2000.0);
                Bukkit.getServer().broadcastMessage(this.plugin.getMessageHandler().getMessage("lsd_death").orElse("%prefix% &e%player% died because of an lsd overdose.").replace("%player%", player.getName()).replace("%prefix", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a7e\u00a7lDrugs\u00a70\u00a7l] ")));
            }
        }
    }

    private void applyEffects(Player player) {
        int time = this.config.getInt("lsd_duration", 30);
        int duration = time * 20;
        player.addPotionEffect(new PotionEffect(PotionEffectType.getByName((String)this.config.getString("lsd_effect_1")), duration, 1));
        player.addPotionEffect(new PotionEffect(PotionEffectType.getByName((String)this.config.getString("lsd_effect_2")), duration, 1));
        player.addPotionEffect(new PotionEffect(PotionEffectType.getByName((String)this.config.getString("lsd_effect_3")), duration, 1));
        SleepBlockListener sleepListener = new SleepBlockListener(this.plugin);
        sleepListener.onDrugUse(player);
    }

    public boolean hasPlayerTakenLSD(Player player) {
        return this.lsdUsers.contains(player.getUniqueId());
    }
}

