/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.listener.DrugEffectListener;

import de.lars.drugs.Drugs;
import de.lars.drugs.config.Configuration;
import de.lars.drugs.listener.SleepBlockListener;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class TobaccoEffectListener
implements Listener {
    private final double cigarettekill;
    private final Configuration config;
    private final Drugs plugin;
    private final Set<UUID> tobaccoUsers;

    public TobaccoEffectListener(Drugs plugin, Configuration config) {
        this.cigarettekill = config.getDouble("cigarette_kill");
        this.config = config;
        this.plugin = plugin;
        this.tobaccoUsers = new HashSet<UUID>();
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        final Player player = event.getPlayer();
        if (event.getHand() == EquipmentSlot.HAND) {
            ItemStack joint;
            ItemStack item = player.getInventory().getItemInOffHand();
            if (item != null && item.getType() == Material.FLINT_AND_STEEL && item.hasItemMeta() && item.getItemMeta().hasDisplayName() && item.getItemMeta().getDisplayName().equals(this.plugin.getMessageHandler().getMessage("zippo_name").orElse("\u00a7eZippo")) && (joint = player.getInventory().getItemInMainHand()) != null && joint.getType() == Material.STICK && joint.hasItemMeta() && joint.getItemMeta().hasDisplayName() && joint.getItemMeta().getDisplayName().equals(this.plugin.getMessageHandler().getMessage("cigarette_name").orElse("\u00a7eCigarette")) && event.getAction().toString().contains("RIGHT_CLICK")) {
                int amount = joint.getAmount();
                if (amount > 1) {
                    joint.setAmount(amount - 1);
                } else {
                    player.getInventory().setItemInMainHand(null);
                }
                this.applyEffects(player);
                event.setCancelled(true);
                this.tobaccoUsers.add(player.getUniqueId());
                player.sendMessage(this.plugin.getMessageHandler().getMessage("druginfo").orElse("%prefix% You took %drug%").replace("%drug%", this.plugin.getMessageHandler().getMessage("cigarette_name").orElse("\u00a7eCigarette")).replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                new BukkitRunnable(){

                    public void run() {
                        TobaccoEffectListener.this.tobaccoUsers.remove(player.getUniqueId());
                        player.sendMessage(TobaccoEffectListener.this.plugin.getMessageHandler().getMessage("druginfo_end").orElse("%prefix% %drug% is no longer detectable").replace("%drug%", TobaccoEffectListener.this.plugin.getMessageHandler().getMessage("cigarette_name").orElse("\u00a7eCigarette")).replace("%prefix%", TobaccoEffectListener.this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                    }
                }.runTaskLater((Plugin)this.plugin, (long)(this.config.getInt("Cigarette_value_detectable") * 20));
                Random random = new Random();
                if (random.nextDouble() < this.cigarettekill) {
                    player.damage(2000.0);
                    Bukkit.getServer().broadcastMessage(this.plugin.getMessageHandler().getMessage("lung_cancer").orElse("%prefix% %player% died because of lung cancer").replace("%player%", player.getName()).replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                }
                return;
            }
            joint = player.getInventory().getItemInMainHand();
            if (joint != null && joint.getType() == Material.STICK && joint.hasItemMeta() && joint.getItemMeta().hasDisplayName() && joint.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("cigarette_name", "\u00a7eCigarette")))) {
                player.sendMessage(this.plugin.getMessageHandler().getMessage("need_zippo").orElse("%preifx% \u00a7eYou need a zippo to light this up.").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            }
        }
    }

    private void applyEffects(Player player) {
        int time = this.config.getInt("tobacco_time", 30);
        int duration = time * 20;
        player.addPotionEffect(new PotionEffect(PotionEffectType.getByName((String)this.config.getString("tobacco_effect_1")), duration, 1));
        player.addPotionEffect(new PotionEffect(PotionEffectType.getByName((String)this.config.getString("tobacco_effect_2")), duration, 1));
        player.addPotionEffect(new PotionEffect(PotionEffectType.getByName((String)this.config.getString("tobacco_effect_3")), duration, 1));
        SleepBlockListener sleepListener = new SleepBlockListener(this.plugin);
        sleepListener.onDrugUse(player);
        player.spawnParticle(Particle.SMOKE_NORMAL, player.getLocation(), 3);
    }

    public boolean hasPlayerTakenTobacco(Player player) {
        return this.tobaccoUsers.contains(player.getUniqueId());
    }
}

