/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.listener.DrugEffectListener;

import de.lars.drugs.Drugs;
import de.lars.drugs.config.Configuration;
import de.lars.drugs.listener.SleepBlockListener;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class WeedEffectListener
implements Listener {
    private final double jointkill;
    private final Drugs plugin;
    private final Configuration config;
    private final Set<UUID> weedUsers = new HashSet<UUID>();

    public WeedEffectListener(Drugs plugin, Configuration config) {
        this.jointkill = config.getDouble("weed_kill");
        this.plugin = plugin;
        this.config = config;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        final Player player = event.getPlayer();
        if (event.getHand() == EquipmentSlot.HAND) {
            ItemStack joint;
            ItemStack item = player.getInventory().getItemInOffHand();
            if (item != null && item.getType() == Material.FLINT_AND_STEEL && item.hasItemMeta() && item.getItemMeta().hasDisplayName() && item.getItemMeta().getDisplayName().equals(this.plugin.getMessageHandler().getMessage("zippo_name").orElse("\u00a7eZippo")) && (joint = player.getInventory().getItemInMainHand()) != null && joint.getType() == Material.STICK && joint.hasItemMeta() && joint.getItemMeta().hasDisplayName() && joint.getItemMeta().getDisplayName().equals(this.plugin.getMessageHandler().getMessage("joint_name").orElse("\u00a7eJoint")) && event.getAction().toString().contains("RIGHT_CLICK")) {
                int amount = joint.getAmount();
                if (amount > 1) {
                    joint.setAmount(amount - 1);
                } else {
                    player.getInventory().setItemInMainHand(null);
                }
                this.applyEffects(player);
                event.setCancelled(true);
                this.weedUsers.add(player.getUniqueId());
                player.sendMessage(this.plugin.getMessageHandler().getMessage("druginfo").orElse("%prefix% You took %drug%").replace("%drug%", this.plugin.getMessageHandler().getMessage("joint_name").orElse("\u00a7eJoint")).replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                new BukkitRunnable(){

                    public void run() {
                        WeedEffectListener.this.weedUsers.remove(player.getUniqueId());
                        player.sendMessage(WeedEffectListener.this.plugin.getMessageHandler().getMessage("druginfo_end").orElse("%prefix% %drug% is no longer detectable").replace("%drug%", WeedEffectListener.this.plugin.getMessageHandler().getMessage("joint_name").orElse("\u00a7eJoint")).replace("%prefix%", WeedEffectListener.this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                    }
                }.runTaskLater((Plugin)this.plugin, (long)(this.config.getInt("Weed_value_detectable") * 20));
                Random random = new Random();
                if (random.nextDouble() < this.jointkill) {
                    player.damage(2000.0);
                    Bukkit.getServer().broadcastMessage(this.plugin.getMessageHandler().getMessage("weed_death").orElse("%prefix% %player% died because of an weed overdose").replace("%player%", player.getName()).replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                }
                return;
            }
            joint = player.getInventory().getItemInMainHand();
            if (joint != null && joint.getType() == Material.STICK && joint.hasItemMeta() && joint.getItemMeta().hasDisplayName() && joint.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("joint_name", "\u00a7eJoint")))) {
                player.sendMessage(this.plugin.getMessageHandler().getMessage("need_zippo").orElse("%preifx% \u00a7eYou need a zippo to light this up.").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            }
        }
    }

    private void applyEffects(Player player) {
        int time = this.config.getInt("tobacco_time", 30);
        int duration = time * 20;
        player.addPotionEffect(new PotionEffect(PotionEffectType.getByName((String)this.config.getString("joint_effect_1")), duration, 1));
        player.addPotionEffect(new PotionEffect(PotionEffectType.getByName((String)this.config.getString("joint_effect_2")), duration, 1));
        player.addPotionEffect(new PotionEffect(PotionEffectType.getByName((String)this.config.getString("joint_effect_3")), duration, 1));
        SleepBlockListener sleepListener = new SleepBlockListener(this.plugin);
        sleepListener.onDrugUse(player);
        player.spawnParticle(Particle.SMOKE_NORMAL, player.getLocation(), 3);
    }

    public boolean hasPlayerTakenWeed(Player player) {
        return this.weedUsers.contains(player.getUniqueId());
    }
}

