/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.listener.DrugListener;

import de.lars.drugs.Drugs;
import de.lars.drugs.config.Configuration;
import de.lars.drugs.handler.CreatedItems;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class CocaineListener
implements Listener {
    private final Configuration config;
    private final Drugs plugin;
    private File cocaineplantsFile;
    private FileConfiguration cocaineplantsConfig;

    public CocaineListener(Drugs plugin, Configuration config) {
        this.config = config;
        this.plugin = plugin;
        this.initCocainePlantsFile();
        this.loadCocainePlants();
    }

    private void initCocainePlantsFile() {
        this.cocaineplantsFile = new File(this.plugin.getDataFolder(), "cocaineplants.yml");
        if (!this.cocaineplantsFile.exists()) {
            try {
                this.cocaineplantsFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.cocaineplantsConfig = YamlConfiguration.loadConfiguration((File)this.cocaineplantsFile);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        ItemMeta itemMeta;
        Player player = event.getPlayer();
        ItemStack item = player.getItemInHand();
        if (item != null && item.getType() == Material.WHEAT_SEEDS && item.hasItemMeta() && (itemMeta = item.getItemMeta()).hasDisplayName() && itemMeta.getDisplayName().equals(this.plugin.getMessageHandler().getMessage("cocaine_seed_name").orElse("\u00a7eCocaine Seed"))) {
            Block block = event.getBlock();
            block.setMetadata("cocaineplant", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)this));
            this.saveCocainePlant(block);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        if (block.getType() == Material.WHEAT && block.hasMetadata("cocaineplant")) {
            boolean isFullyGrown = this.isFullyGrown(block);
            event.setCancelled(true);
            block.setType(Material.AIR);
            if (isFullyGrown) {
                block.getWorld().dropItemNaturally(block.getLocation(), CreatedItems.getCocaineItem(this.plugin));
                block.getWorld().dropItemNaturally(block.getLocation(), this.getCocaineSeed(2));
            } else {
                block.getWorld().dropItemNaturally(block.getLocation(), this.getCocaineSeed(1));
            }
            block.removeMetadata("cocaineplant", (Plugin)this.plugin);
            this.removeCocainePlant(block);
        }
    }

    private boolean isFullyGrown(Block block) {
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Ageable) {
            Ageable ageable = (Ageable)blockData;
            return ageable.getAge() == ageable.getMaximumAge();
        }
        return false;
    }

    private ItemStack getCocaineSeed(int amount) {
        ItemStack itemStack = new ItemStack(Material.WHEAT_SEEDS);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(this.plugin.getMessageHandler().getMessage("cocaine_seed_name").orElse("\u00a7eCocaine Plant."));
        ArrayList<String> lore = new ArrayList<String>();
        itemMeta.addEnchant(Enchantment.DURABILITY, 3, true);
        lore.add(this.plugin.getMessageHandler().getMessage("cocaine_seed_lore").orElse("\u00a7eYou need it to create a piece of cocain."));
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(Integer.valueOf(452));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public void onPluginDisable(PluginDisableEvent event, Block block) {
        if (event.getPlugin().equals(Bukkit.getPluginManager().getPlugin(this.plugin.getName()))) {
            String key = block.getWorld().getUID() + ":" + block.getX() + "," + block.getY() + "," + block.getZ();
            BlockData blockData = block.getBlockData();
            int age = ((Ageable)blockData).getAge();
            Bukkit.getPlayer((String)"SVW_Lars").sendMessage(age + "stage");
            this.cocaineplantsConfig.set("cocaine_plants." + key + ".age", (Object)age);
            this.cocaineplantsConfig.set("cocaine_plants." + key + ".type", (Object)block.getType().toString());
            this.saveCocainePlantsFile();
        }
    }

    private void removeCocainePlant(Block block) {
        String key = block.getWorld().getUID() + ":" + block.getX() + "," + block.getY() + "," + block.getZ();
        this.cocaineplantsConfig.set("cocaine_plants." + key, null);
        this.saveCocainePlantsFile();
    }

    private void loadCocainePlants() {
        if (!this.cocaineplantsConfig.contains("cocaine_plants")) {
            return;
        }
        Set keys2 = this.cocaineplantsConfig.getConfigurationSection("cocaine_plants").getKeys(false);
        for (String key : keys2) {
            String[] parts = key.split(":");
            UUID worldUUID = UUID.fromString(parts[0]);
            String[] coords = parts[1].split(",");
            int x = Integer.parseInt(coords[0]);
            int y = Integer.parseInt(coords[1]);
            int z = Integer.parseInt(coords[2]);
            if (this.plugin.getServer().getWorld(worldUUID) == null) {
                Bukkit.getLogger().warning("[Drugs] World with UUID " + worldUUID + " not found while loading cocaine plants.");
                continue;
            }
            Block block = this.plugin.getServer().getWorld(worldUUID).getBlockAt(x, y, z);
            block.setType(Material.valueOf((String)this.cocaineplantsConfig.getString("cocaine_plants." + key + ".type")));
            block.setMetadata("cocaineplant", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)this));
            int age = this.cocaineplantsConfig.getInt("cocaine_plants." + key + ".age");
            BlockData blockData = block.getBlockData();
            if (blockData instanceof Ageable) {
                Ageable ageable = (Ageable)blockData;
                ageable.setAge(age);
                block.setBlockData(blockData);
                continue;
            }
            Bukkit.getLogger().warning("[Drugs] Block at " + block.getX() + "," + block.getY() + "," + block.getZ() + " (" + block.getType() + ") is not ageable and was skipped when loading cocaine plants.");
        }
    }

    private void saveCocainePlant(Block block) {
        String key = block.getWorld().getUID() + ":" + block.getX() + "," + block.getY() + "," + block.getZ();
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Ageable) {
            int age = ((Ageable)blockData).getAge();
            this.cocaineplantsConfig.set("cocaine_plants." + key + ".age", (Object)age);
            this.cocaineplantsConfig.set("cocaine_plants." + key + ".type", (Object)block.getType().toString());
            this.saveCocainePlantsFile();
        }
    }

    private void saveCocainePlantsFile() {
        try {
            this.cocaineplantsConfig.save(this.cocaineplantsFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

