/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.listener.DrugListener;

import de.lars.drugs.Drugs;
import de.lars.drugs.config.Configuration;
import de.lars.drugs.handler.CreatedItems;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class TobaccoListener
implements Listener {
    private final Configuration config;
    private final Drugs plugin;
    private File tobaccoplantsFile;
    private FileConfiguration tobaccoplantsConfig;

    public TobaccoListener(Drugs plugin, Configuration config) {
        this.config = config;
        this.plugin = plugin;
        this.initTobaccoPlantsFile();
        this.loadTobaccoPlants();
    }

    private void initTobaccoPlantsFile() {
        this.tobaccoplantsFile = new File(this.plugin.getDataFolder(), "tobaccoplants.yml");
        if (!this.tobaccoplantsFile.exists()) {
            try {
                this.tobaccoplantsFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.tobaccoplantsConfig = YamlConfiguration.loadConfiguration((File)this.tobaccoplantsFile);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        ItemMeta itemMeta;
        Player player = event.getPlayer();
        ItemStack item = player.getItemInHand();
        if (item != null && item.getType() == Material.WHEAT_SEEDS && item.hasItemMeta() && (itemMeta = item.getItemMeta()).hasDisplayName() && itemMeta.getDisplayName().equals(this.plugin.getMessageHandler().getMessage("tobacco_seed_name").orElse("\u00a7eTobacco Seed"))) {
            Block block = event.getBlock();
            block.setMetadata("tobaccoplant", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)this));
            this.saveTobaccoPlant(block);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        if (block.getType() == Material.WHEAT && block.hasMetadata("tobaccoplant")) {
            boolean isFullyGrown = this.isFullyGrown(block);
            event.setCancelled(true);
            block.setType(Material.AIR);
            if (isFullyGrown) {
                block.getWorld().dropItemNaturally(block.getLocation(), CreatedItems.getTobaccoItem(this.plugin));
                block.getWorld().dropItemNaturally(block.getLocation(), this.getTobaccoSeed(2));
            } else {
                block.getWorld().dropItemNaturally(block.getLocation(), this.getTobaccoSeed(1));
            }
            block.removeMetadata("tobaccoplant", (Plugin)this.plugin);
            this.removeTobaccoPlant(block);
        }
    }

    private boolean isFullyGrown(Block block) {
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Ageable) {
            Ageable ageable = (Ageable)blockData;
            return ageable.getAge() == ageable.getMaximumAge();
        }
        return false;
    }

    private ItemStack getTobaccoSeed(int amount) {
        ItemStack itemStack = new ItemStack(Material.WHEAT_SEEDS);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(this.plugin.getMessageHandler().getMessage("tobacco_seed_name").orElse("\u00a7eTobacco Plant."));
        ArrayList<String> lore = new ArrayList<String>();
        itemMeta.addEnchant(Enchantment.DURABILITY, 3, true);
        lore.add(this.plugin.getMessageHandler().getMessage("tobacco_seed_lore").orElse("\u00a7eYou need it to create tobacco."));
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(Integer.valueOf(453));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public void onPluginDisable(PluginDisableEvent event, Block block) {
        if (event.getPlugin().equals(Bukkit.getPluginManager().getPlugin(this.plugin.getName()))) {
            String key = block.getWorld().getUID() + ":" + block.getX() + "," + block.getY() + "," + block.getZ();
            BlockData blockData = block.getBlockData();
            int age = ((Ageable)blockData).getAge();
            Bukkit.getPlayer((String)"SVW_Lars").sendMessage(age + "stage");
            this.tobaccoplantsConfig.set("tobacco_plants." + key + ".age", (Object)age);
            this.tobaccoplantsConfig.set("tobacco_plants." + key + ".type", (Object)block.getType().toString());
            this.saveTobaccoPlantsFile();
        }
    }

    private void removeTobaccoPlant(Block block) {
        String key = block.getWorld().getUID() + ":" + block.getX() + "," + block.getY() + "," + block.getZ();
        this.tobaccoplantsConfig.set("tobacco_plants." + key, null);
        this.saveTobaccoPlantsFile();
    }

    private void loadTobaccoPlants() {
        if (!this.tobaccoplantsConfig.contains("tobacco_plants")) {
            return;
        }
        Set keys2 = this.tobaccoplantsConfig.getConfigurationSection("tobacco_plants").getKeys(false);
        for (String key : keys2) {
            String[] parts = key.split(":");
            UUID worldUUID = UUID.fromString(parts[0]);
            String[] coords = parts[1].split(",");
            int x = Integer.parseInt(coords[0]);
            int y = Integer.parseInt(coords[1]);
            int z = Integer.parseInt(coords[2]);
            Block block = this.plugin.getServer().getWorld(worldUUID).getBlockAt(x, y, z);
            block.setType(Material.valueOf((String)this.tobaccoplantsConfig.getString("tobacco_plants." + key + ".type")));
            block.setMetadata("tobaccoplant", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)this));
            int age = this.tobaccoplantsConfig.getInt("tobacco_plants." + key + ".age");
            BlockData blockData = block.getBlockData();
            Ageable ageable = (Ageable)blockData;
            ageable.setAge(age);
            block.setBlockData(blockData);
        }
    }

    private void saveTobaccoPlant(Block block) {
        String key = block.getWorld().getUID() + ":" + block.getX() + "," + block.getY() + "," + block.getZ();
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Ageable) {
            int age = ((Ageable)blockData).getAge();
            this.tobaccoplantsConfig.set("tobacco_plants." + key + ".age", (Object)age);
            this.tobaccoplantsConfig.set("tobacco_plants." + key + ".type", (Object)block.getType().toString());
            this.saveTobaccoPlantsFile();
        }
    }

    private void saveTobaccoPlantsFile() {
        try {
            this.tobaccoplantsConfig.save(this.tobaccoplantsFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

