/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.listener.DrugListener;

import de.lars.drugs.Drugs;
import de.lars.drugs.config.Configuration;
import de.lars.drugs.handler.CreatedItems;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class WeedListener
implements Listener {
    private final Configuration config;
    private final Drugs plugin;
    private File weedplantsFile;
    private FileConfiguration weedplantsConfig;

    public WeedListener(Drugs plugin, Configuration config) {
        this.config = config;
        this.plugin = plugin;
        this.initWeedPlantsFile();
        this.loadWeedPlants();
    }

    private void initWeedPlantsFile() {
        this.weedplantsFile = new File(this.plugin.getDataFolder(), "weedplants.yml");
        if (!this.weedplantsFile.exists()) {
            try {
                this.weedplantsFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.weedplantsConfig = YamlConfiguration.loadConfiguration((File)this.weedplantsFile);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getItemInHand();
        if (item != null && item.getType() == Material.WHEAT_SEEDS && item.hasItemMeta()) {
            ItemMeta itemMeta = item.getItemMeta();
            ConfigurationSection customSeeds = this.config.getConfigurationSection("CustomWeedSeed");
            if (customSeeds != null) {
                for (String seedKey : customSeeds.getKeys(false)) {
                    ConfigurationSection seedConfig = customSeeds.getConfigurationSection(seedKey);
                    if (seedConfig == null || !itemMeta.hasDisplayName() || !itemMeta.getDisplayName().equals(seedConfig.getString("Name"))) continue;
                    Block block = event.getBlock();
                    block.setMetadata("weedplant", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)seedKey));
                    this.saveWeedPlant(block, seedKey);
                    return;
                }
            }
            if (itemMeta.hasDisplayName() && itemMeta.getDisplayName().equals(this.plugin.getMessageHandler().getMessage("weed_seed_name").orElse("\u00a7eWeed Seed"))) {
                Block block = event.getBlock();
                block.setMetadata("weedplant", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)"standard_weed"));
                this.saveWeedPlant(block, "standard_weed");
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        if (block.getType() == Material.WHEAT && block.hasMetadata("weedplant")) {
            boolean isFullyGrown;
            String seedKey = ((MetadataValue)block.getMetadata("weedplant").get(0)).asString();
            ConfigurationSection customSeeds = this.config.getConfigurationSection("CustomWeedSeed");
            if (customSeeds != null && customSeeds.contains(seedKey)) {
                isFullyGrown = this.isFullyGrown(block);
                event.setCancelled(true);
                block.setType(Material.AIR);
                ConfigurationSection seedConfig = customSeeds.getConfigurationSection(seedKey);
                if (isFullyGrown) {
                    this.dropCustomWeedItem(block, seedConfig);
                }
                this.dropCustomWeedSeeds(block, seedConfig);
                block.removeMetadata("weedplant", (Plugin)this.plugin);
                this.removeWeedPlant(block);
            }
            if (seedKey.equals("standard_weed")) {
                isFullyGrown = this.isFullyGrown(block);
                event.setCancelled(true);
                block.setType(Material.AIR);
                if (isFullyGrown) {
                    block.getWorld().dropItemNaturally(block.getLocation(), CreatedItems.getSuperWheatItem(this.plugin));
                    block.getWorld().dropItemNaturally(block.getLocation(), this.getWeedSeed(2));
                } else {
                    block.getWorld().dropItemNaturally(block.getLocation(), this.getWeedSeed(1));
                }
                block.removeMetadata("weedplant", (Plugin)this.plugin);
                this.removeWeedPlant(block);
            }
        }
    }

    private boolean isFullyGrown(Block block) {
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Ageable) {
            Ageable ageable = (Ageable)blockData;
            return ageable.getAge() == ageable.getMaximumAge();
        }
        return false;
    }

    private ItemStack getWeedSeed(int amount) {
        ItemStack itemStack = new ItemStack(Material.WHEAT_SEEDS);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(this.plugin.getMessageHandler().getMessage("weed_seed_name").orElse("\u00a7eWeed Seed"));
        ArrayList<String> lore = new ArrayList<String>();
        itemMeta.addEnchant(Enchantment.DURABILITY, 3, true);
        lore.add(this.plugin.getMessageHandler().getMessage("weed_seed_lore").orElse("\u00a7eYou need it to create weed."));
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(Integer.valueOf(451));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private void dropCustomWeedSeeds(Block block, ConfigurationSection seedConfig) {
        int amount = seedConfig.getInt("SeedDropAmount", 1);
        ItemStack item = this.getCustomWeedSeed(seedConfig, amount);
        block.getWorld().dropItemNaturally(block.getLocation(), item);
    }

    private void dropCustomWeedItem(Block block, ConfigurationSection seedConfig) {
        Random random = new Random();
        ConfigurationSection dropRates = seedConfig.getConfigurationSection("DropRates");
        if (dropRates != null) {
            for (String amountKey : dropRates.getKeys(false)) {
                double chance = dropRates.getDouble(amountKey);
                if (!(random.nextDouble() * 100.0 < chance)) continue;
                int amount = Integer.parseInt(amountKey);
                ItemStack item = this.getCustomWeedItem(seedConfig, amount);
                block.getWorld().dropItemNaturally(block.getLocation(), item);
                break;
            }
        }
    }

    private ItemStack getCustomWeedSeed(ConfigurationSection seedConfig, int amount) {
        ItemStack itemStack = new ItemStack(Material.WHEAT_SEEDS, amount);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(seedConfig.getString("Name"));
        itemMeta.setLore(seedConfig.getStringList("Lore"));
        itemMeta.addEnchant(Enchantment.DURABILITY, 3, true);
        itemMeta.setCustomModelData(Integer.valueOf(seedConfig.getInt("Custommodeldata")));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private ItemStack getCustomWeedItem(ConfigurationSection seedConfig, int amount) {
        ItemStack itemStack = new ItemStack(Material.WHEAT, amount);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(seedConfig.getString("WeedName", "\u00a7eWeed"));
        itemMeta.setLore(seedConfig.getStringList("WeedLore"));
        itemMeta.addEnchant(Enchantment.DURABILITY, 3, true);
        if (seedConfig.contains("WeedCustomModelData")) {
            itemMeta.setCustomModelData(Integer.valueOf(seedConfig.getInt("WeedCustomModelData")));
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private void removeWeedPlant(Block block) {
        String key = block.getWorld().getUID() + ":" + block.getX() + "," + block.getY() + "," + block.getZ();
        this.weedplantsConfig.set("weed_plants." + key, null);
        this.saveWeedPlantsFile();
    }

    private void saveWeedPlant(Block block, String seedKey) {
        String key = block.getWorld().getUID() + ":" + block.getX() + "," + block.getY() + "," + block.getZ();
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Ageable) {
            int age = ((Ageable)blockData).getAge();
            this.weedplantsConfig.set("weed_plants." + key + ".age", (Object)age);
            this.weedplantsConfig.set("weed_plants." + key + ".type", (Object)block.getType().toString());
            this.weedplantsConfig.set("weed_plants." + key + ".seedKey", (Object)seedKey);
            this.saveWeedPlantsFile();
        }
    }

    private void saveWeedPlantsFile() {
        try {
            this.weedplantsConfig.save(this.weedplantsFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadWeedPlants() {
        ConfigurationSection weedSection = this.weedplantsConfig.getConfigurationSection("weed_plants");
        if (weedSection == null) {
            return;
        }
        Set keys2 = weedSection.getKeys(false);
        for (String key : keys2) {
            String[] parts = key.split(":");
            UUID worldUUID = UUID.fromString(parts[0]);
            String[] coords = parts[1].split(",");
            int x = Integer.parseInt(coords[0]);
            int y = Integer.parseInt(coords[1]);
            int z = Integer.parseInt(coords[2]);
            Block block = this.plugin.getServer().getWorld(worldUUID).getBlockAt(x, y, z);
            block.setType(Material.WHEAT);
            block.setMetadata("weedplant", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)this));
            int age = this.weedplantsConfig.getInt("weed_plants." + key + ".age");
            BlockData blockData = block.getBlockData();
            if (!(blockData instanceof Ageable)) continue;
            Ageable ageable = (Ageable)blockData;
            ageable.setAge(age);
            block.setBlockData((BlockData)ageable);
        }
    }
}

