/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.listener;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;

public class ErrorLogListener
implements Listener {
    private final File logFolder;

    public ErrorLogListener(File pluginFolder) {
        this.logFolder = new File(pluginFolder, "errorlogs");
        if (!this.logFolder.exists()) {
            this.logFolder.mkdirs();
        }
        Thread.setDefaultUncaughtExceptionHandler((thread2, exception) -> this.logError(exception));
    }

    private void logError(Throwable exception) {
        String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        String baseFileName = date + "-LOGS.txt";
        File logFile = new File(this.logFolder, baseFileName);
        int counter = 1;
        while (logFile.exists()) {
            logFile = new File(this.logFolder, date + "-LOGS_" + counter + ".txt");
            ++counter;
        }
        try (FileWriter writer = new FileWriter(logFile, true);){
            writer.write("Error: " + exception.toString() + "\n");
            for (StackTraceElement element : exception.getStackTrace()) {
                writer.write("\tat " + element.toString() + "\n");
            }
            writer.write("\n");
        }
        catch (IOException e) {
            Bukkit.getLogger().severe("Could not write error log: " + e.getMessage());
        }
    }
}

