/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.listener;

import de.lars.drugs.Drugs;
import de.lars.drugs.config.Configuration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GrassBreakListener
implements Listener {
    private final double dropChanceCocaine;
    private final double dropChanceTobacco;
    private final double dropChanceWeed;
    private final Drugs plugin;
    private final Map<String, Double> customSeedDropChances;

    public GrassBreakListener(Drugs plugin, Configuration config) {
        ConfigurationSection section;
        this.plugin = plugin;
        this.dropChanceCocaine = config.getDouble("cocaine_chance");
        this.dropChanceTobacco = config.getDouble("tobacco_chance");
        this.dropChanceWeed = config.getDouble("weed_chance");
        this.customSeedDropChances = new HashMap<String, Double>();
        if (config.contains("CustomWeedSeed") && (section = config.getConfigurationSection("CustomWeedSeed")) != null) {
            for (String key : section.getKeys(false)) {
                String path = "CustomWeedSeed." + key + ".DropChance";
                double chance = 0.0;
                this.customSeedDropChances.put(key, chance);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onGrassBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getBlock().getType() == Material.GRASS) {
            Random random = new Random();
            if (random.nextDouble() < this.dropChanceWeed) {
                event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation(), this.getSuperSeedItem(1));
            }
            if (random.nextDouble() < this.dropChanceCocaine) {
                event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation(), this.getCocainePlantItem(1));
            }
            if (random.nextDouble() < this.dropChanceTobacco) {
                event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation(), this.getTobaccoPlant(1));
            }
            for (Map.Entry<String, Double> entry : this.customSeedDropChances.entrySet()) {
                if (!(random.nextDouble() < entry.getValue())) continue;
                event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation(), this.getCustomSeedItem(entry.getKey()));
            }
        }
    }

    private ItemStack getSuperSeedItem(int amount) {
        ItemStack itemStack = new ItemStack(Material.WHEAT_SEEDS);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(this.plugin.getMessageHandler().getMessage("weed_seed_name").orElse("\u00a7eWeed Seed"));
        ArrayList<String> lore = new ArrayList<String>();
        itemMeta.addEnchant(Enchantment.DURABILITY, 3, true);
        lore.add(this.plugin.getMessageHandler().getMessage("weed_seed_lore").orElse("\u00a7eYou need it to create weed."));
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(Integer.valueOf(451));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private ItemStack getCocainePlantItem(int amount) {
        ItemStack itemStack = new ItemStack(Material.WHEAT_SEEDS);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(this.plugin.getMessageHandler().getMessage("cocaine_seed_name").orElse("\u00a7eCocaine Plant."));
        ArrayList<String> lore = new ArrayList<String>();
        itemMeta.addEnchant(Enchantment.DURABILITY, 3, true);
        lore.add(this.plugin.getMessageHandler().getMessage("cocaine_seed_lore").orElse("\u00a7eYou need it to create a piece of cocaine."));
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(Integer.valueOf(452));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private ItemStack getTobaccoPlant(int amount) {
        ItemStack itemStack = new ItemStack(Material.WHEAT_SEEDS);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(this.plugin.getMessageHandler().getMessage("tobacco_seed_name").orElse("\u00a7eTobacco Plant."));
        ArrayList<String> lore = new ArrayList<String>();
        itemMeta.addEnchant(Enchantment.DURABILITY, 3, true);
        lore.add(this.plugin.getMessageHandler().getMessage("tobacco_seed_lore").orElse("\u00a7eYou need it to create tobacco."));
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(Integer.valueOf(453));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private ItemStack getCustomSeedItem(String seedKey) {
        Configuration config = this.plugin.getConfiguration();
        String basePath = "CustomWeedSeed." + seedKey;
        ItemStack itemStack = new ItemStack(Material.WHEAT_SEEDS);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(config.getString(basePath + ".Name", "\u00a7eCustom Seed"));
        List lore = config.getStringList(basePath + ".Lore");
        if (lore.isEmpty()) {
            lore.add("\u00a7eA special seed.");
        }
        itemMeta.setLore(lore);
        itemMeta.addEnchant(Enchantment.DURABILITY, 3, true);
        int modelData = config.getInt(basePath + ".Custommodeldata", 0);
        if (modelData > 0) {
            itemMeta.setCustomModelData(Integer.valueOf(modelData));
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }
}

