/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.listener;

import de.lars.drugs.Drugs;
import de.lars.drugs.data.HarvestData;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public class PlantHarvestListener
implements Listener {
    private final Map<UUID, HarvestData> playerData = new HashMap<UUID, HarvestData>();

    public PlantHarvestListener() {
        this.loadPlayerData();
    }

    @EventHandler
    public void onPlantHarvest(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        HarvestData data = this.playerData.computeIfAbsent(player.getUniqueId(), k -> new HarvestData());
        if (block.hasMetadata("weedplant")) {
            if (this.isFullyGrown(block)) {
                data.incrementWeedHarvested();
                data.incrementTotalHarvested();
            }
        } else if (block.hasMetadata("tobaccoplant")) {
            if (this.isFullyGrown(block)) {
                data.incrementTobaccoHarvested();
                data.incrementTotalHarvested();
            }
        } else if (block.hasMetadata("cocaineplant") && this.isFullyGrown(block)) {
            data.incrementCocaineHarvested();
            data.incrementTotalHarvested();
        }
        this.savePlayerData();
    }

    @EventHandler
    public void onPlantPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItemInHand();
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        int modelData = item.getItemMeta().hasCustomModelData() ? item.getItemMeta().getCustomModelData() : 0;
        HarvestData data = this.playerData.computeIfAbsent(player.getUniqueId(), k -> new HarvestData(0, 0, 0, 0, 0, 0, 0, 0));
        Block block = event.getBlock();
        if (modelData == 451) {
            data.incrementWeedPlanted();
        } else if (modelData == 452) {
            data.incrementCocainePlanted();
        } else if (modelData == 453) {
            data.incrementTobaccoPlanted();
        } else {
            return;
        }
        data.incrementTotalPlanted();
        this.savePlayerData();
    }

    private boolean isFullyGrown(Block block) {
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Ageable) {
            Ageable ageable = (Ageable)blockData;
            return ageable.getAge() == ageable.getMaximumAge();
        }
        return false;
    }

    public void savePlayerData() {
        try {
            Drugs.getInstance().getDataManager().saveHarvestData(this.playerData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadPlayerData() {
        try {
            this.playerData.putAll(Drugs.getInstance().getDataManager().loadHarvestData());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Map<UUID, HarvestData> getPlayerData() {
        return this.playerData;
    }
}

