/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.listener;

import de.lars.drugs.Drugs;
import de.lars.drugs.config.Configuration;
import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ShroomBreakListener
implements Listener {
    private final Configuration config;
    private final Drugs plugin;
    private final double dropChanceshrooms;

    public ShroomBreakListener(Drugs plugin, Configuration config) {
        this.config = config;
        this.plugin = plugin;
        this.dropChanceshrooms = config.getDouble("shrooms_chance");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onGrassBreak(BlockBreakEvent event) {
        Random random;
        if (event.isCancelled()) {
            return;
        }
        if (event.getBlock().getType() == Material.RED_MUSHROOM) {
            Random random2 = new Random();
            if (random2.nextDouble() < this.dropChanceshrooms) {
                ItemStack shroomItem = this.getShroomItem(this.plugin, 1);
                event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation(), shroomItem);
            }
        } else if (event.getBlock().getType() == Material.RED_MUSHROOM && (random = new Random()).nextDouble() < this.dropChanceshrooms) {
            ItemStack shroomItem = this.getShroomItem(this.plugin, 1);
            event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation(), shroomItem);
        }
    }

    private ItemStack getShroomItem(Drugs plugin, int amount) {
        ItemStack itemStack = new ItemStack(Material.RED_MUSHROOM);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(plugin.getMessageHandler().getMessage("shroom_name").orElse("\u00a7eShroom"));
        ArrayList<String> lore = new ArrayList<String>();
        itemMeta.addEnchant(Enchantment.DURABILITY, 3, true);
        lore.add(plugin.getMessageHandler().getMessage("shroom_lore").orElse("\u00a7eYou can use it to get high."));
        itemMeta.setLore(lore);
        itemMeta.setCustomModelData(Integer.valueOf(455));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }
}

