/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.listener;

import de.lars.drugs.Drugs;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBedEnterEvent;

public class SleepBlockListener
implements Listener {
    private final Drugs plugin;
    private final HashMap<UUID, Long> drugTimers = new HashMap();
    private final long sleepCooldown = 600000L;

    public SleepBlockListener(Drugs plugin) {
        this.plugin = plugin;
    }

    public void onDrugUse(Player player) {
        this.drugTimers.put(player.getUniqueId(), System.currentTimeMillis());
    }

    @EventHandler
    public void onPlayerBedEnter(PlayerBedEnterEvent event) {
        long timeSinceDrugUse;
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (this.drugTimers.containsKey(playerId) && (timeSinceDrugUse = System.currentTimeMillis() - this.drugTimers.get(playerId)) < 600000L) {
            long remainingTime = 600000L - timeSinceDrugUse;
            long minutesLeft = remainingTime / 1000L / 60L;
            player.sendMessage(ChatColor.RED + "Du kannst erst wieder in " + minutesLeft + " Minuten schlafen.");
            event.setCancelled(true);
        }
    }
}

