/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.listener.resourcepack;

import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ResourcePackListener
implements Listener {
    private final JavaPlugin plugin;

    public ResourcePackListener(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public static void registerIfEnabled(JavaPlugin plugin) {
        boolean isEnabled = plugin.getConfig().getBoolean("Resourcepack", false);
        if (isEnabled) {
            Bukkit.getPluginManager().registerEvents((Listener)new ResourcePackListener(plugin), (Plugin)plugin);
            plugin.getLogger().info("ResourcePackListener activated.");
        } else {
            plugin.getLogger().info("ResourcePackListener deactivated.");
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        String resourcePackUrl = this.plugin.getConfig().getString("resource_pack_url");
        String resourcePackHashString = this.plugin.getConfig().getString("resource_pack_hash");
        if (resourcePackUrl == null || resourcePackUrl.isEmpty()) {
            this.plugin.getLogger().warning("Resource pack URL is not set in the config!");
            return;
        }
        try {
            byte[] resourcePackHash = null;
            if (resourcePackHashString != null && !resourcePackHashString.isEmpty()) {
                resourcePackHash = this.fromHexString(resourcePackHashString);
            }
            player.setResourcePack(resourcePackUrl, resourcePackHash);
        }
        catch (IllegalArgumentException e) {
            player.sendMessage("The Resourcepack could not be loaded. Error: Invalid HASH Code.");
            this.plugin.getLogger().warning("Invalid HASH code for the resource pack: " + resourcePackHashString);
        }
        player.sendMessage("Hey! In order to use a plugin provided by this server, please use the resourcepack! If you already got it, you can ignore this message.");
    }

    private byte[] fromHexString(String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("Invalid length of the HASH string.");
        }
        byte[] bytes = new byte[hex.length() / 2];
        for (int i = 0; i < hex.length(); i += 2) {
            bytes[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return bytes;
    }

    @EventHandler
    public void onResourcePackStatus(PlayerResourcePackStatusEvent event) {
        Player player = event.getPlayer();
        PlayerResourcePackStatusEvent.Status status = event.getStatus();
        switch (status) {
            case SUCCESSFULLY_LOADED: {
                player.sendMessage("\u00a7aResource-Pack successfully loaded.");
                break;
            }
            case DECLINED: {
                player.sendMessage("\u00a7cYou declined the Resource-Pack. Some textures may not load correctly.");
                break;
            }
            case FAILED_DOWNLOAD: {
                player.sendMessage("\u00a7cFailed to download Resourcepack. Please try again.");
                break;
            }
            case ACCEPTED: {
                player.sendMessage("\u00a7eResource-pack is being downloaded...");
                break;
            }
        }
        this.plugin.getLogger().info("ResourcePack Status for " + player.getName() + ": " + status.name());
    }
}

