/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.manager;

import de.lars.drugs.Drugs;
import de.lars.drugs.config.Configuration;
import de.lars.drugs.handler.CreatedItems;
import de.lars.drugs.manager.MarketItem;
import de.lars.drugs.manager.SalesDataManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class BlackMarketManager {
    private final Economy economy;
    private final Drugs plugin;
    private final Configuration config;
    private final Map<String, List<MarketItem>> marketItems = new HashMap<String, List<MarketItem>>();
    private final Map<String, Long> itemTimestamps = new HashMap<String, Long>();
    private final Map<UUID, List<String>> offlineNotifications = new HashMap<UUID, List<String>>();
    private Map<UUID, Integer> playerSales = new HashMap<UUID, Integer>();
    private final SalesDataManager salesDataManager;
    private long itemExpirationTime;

    public BlackMarketManager(SalesDataManager salesDataManager, Drugs plugin, Economy economy, Configuration config) {
        this.economy = economy;
        this.config = config;
        this.plugin = plugin;
        this.itemExpirationTime = config.getLong("blackmarket_expiration_time", 86400L);
        this.salesDataManager = salesDataManager;
    }

    public void openBlackMarket(Player player, int page) {
        ItemMeta meta;
        int inventorySize = 54;
        Inventory inventory = Bukkit.createInventory(null, (int)inventorySize, (String)this.plugin.getMessageHandler().getMessage("blackmarket_name").orElse("\u00a7eBlack Market"));
        List<MarketItem> items = this.getAllItems();
        if (items.isEmpty()) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("blackmarket_empty").orElse("%prefix% \u00a7eBlack Market is empty.").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return;
        }
        int maxItemsPerPage = inventorySize - 9;
        if (page < 1) {
            page = 1;
        }
        int startIndex = (page - 1) * maxItemsPerPage;
        int endIndex = Math.min(startIndex + maxItemsPerPage, items.size());
        if (startIndex >= items.size()) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("blackmarket_no_site").orElse("%prefix% \u00a7eThis site is not available.").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return;
        }
        for (int i = startIndex; i < endIndex; ++i) {
            if (i >= 0 && i < items.size()) {
                inventory.addItem(new ItemStack[]{items.get(i).toItemStack()});
                continue;
            }
            Bukkit.getLogger().warning("Invalid Index: " + i);
        }
        if (page > 1) {
            ItemStack previousPage = new ItemStack(Material.ARROW);
            meta = previousPage.getItemMeta();
            meta.setDisplayName(this.plugin.getMessageHandler().getMessage("blackmarket_back_page").orElse("\u00a7ePrevious Page"));
            previousPage.setItemMeta(meta);
            inventory.setItem(inventorySize - 9, previousPage);
        }
        if (endIndex < items.size()) {
            ItemStack nextPage = new ItemStack(Material.ARROW);
            meta = nextPage.getItemMeta();
            meta.setDisplayName(this.plugin.getMessageHandler().getMessage("blackmarket_next_page").orElse("\u00a7eNext Page"));
            nextPage.setItemMeta(meta);
            inventory.setItem(inventorySize - 1, nextPage);
        }
        player.openInventory(inventory);
    }

    public void handlePurchase(Player player, ItemStack clickedItem) {
        if (clickedItem == null || !clickedItem.hasItemMeta()) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("blackmarket_no_meta").orElse("%prefix% \u00a7eItem has no meta").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        if (meta == null || meta.getLore() == null) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("blackmarket_no_lore").orElse("%prefix% \u00a7eItem has no lore.").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return;
        }
        List lore = meta.getLore();
        UUID sellerUUID = null;
        int price = -1;
        for (String line : lore) {
            String sellerName;
            OfflinePlayer seller;
            String strippedLine = ChatColor.stripColor((String)line);
            if (strippedLine.startsWith("Seller: ") && ((seller = Bukkit.getOfflinePlayer((String)(sellerName = strippedLine.replace("Seller: ", "")))).hasPlayedBefore() || seller.isOnline())) {
                sellerUUID = seller.getUniqueId();
            }
            if (!strippedLine.startsWith("Price: ")) continue;
            try {
                price = Integer.parseInt(strippedLine.replace("Price: ", "").replace(" $", ""));
            }
            catch (NumberFormatException e) {
                player.sendMessage(this.plugin.getMessageHandler().getMessage("blackmarket_failed_price").orElse("%prefix% \u00a7ePrice valuation failed.").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
                return;
            }
        }
        if (sellerUUID == null || price == -1) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("blackmarket_purchase_failed").orElse("%prefix% \u00a7ePurchase of the item failed").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return;
        }
        if (!this.economy.has((OfflinePlayer)player, (double)price)) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("blackmarket_no_money").orElse("%prefix% \u00a7eNot enough money").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return;
        }
        String uniqueId = (String)meta.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "unique_id"), PersistentDataType.STRING);
        if (uniqueId == null) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("blackmarket_no_unique_identifier").orElse("%prefix% \u00a7eThe item has no unique identifier").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return;
        }
        ItemStack copiedItem = clickedItem.clone();
        boolean itemRemoved = this.removeItemFromMarketById(uniqueId);
        if (!itemRemoved) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("blackmarket_not_available").orElse("%prefix% \u00a7eItem expired.").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return;
        }
        this.economy.withdrawPlayer((OfflinePlayer)player, (double)price);
        ItemStack pluginItem = this.getOriginalItem(clickedItem);
        if (pluginItem == null) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("failed_retrieve_original").orElse("%prefix% \u00a7eFailed to retrieve the original item.").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            this.economy.depositPlayer((OfflinePlayer)player, (double)price);
            return;
        }
        pluginItem.setAmount(copiedItem.getAmount());
        HashMap remainingItems = player.getInventory().addItem(new ItemStack[]{pluginItem});
        if (!remainingItems.isEmpty()) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("blackmarket_no_inv_space").orElse("%prefix% \u00a7eYou don't have enough space in your inventory.").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            this.economy.depositPlayer((OfflinePlayer)player, (double)price);
            ItemStack unsoldItem = (ItemStack)remainingItems.values().iterator().next();
            ItemMeta unsoldMeta = unsoldItem.getItemMeta();
            if (unsoldMeta != null) {
                unsoldMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "unique_id"), PersistentDataType.STRING, (Object)uniqueId);
                unsoldItem.setItemMeta(unsoldMeta);
                this.marketItems.computeIfAbsent(player.getName(), k -> new ArrayList()).add(new MarketItem(player.getName(), unsoldItem, price));
            }
            return;
        }
        player.sendMessage(this.plugin.getMessageHandler().getMessage("blackmarket_purchase " + copiedItem.getAmount() + " x " + pluginItem.getItemMeta().getDisplayName() + " = " + price + "$").orElse("%prefix% \u00a7eYou purchased" + copiedItem.getAmount() + " x " + pluginItem.getItemMeta().getDisplayName() + " = " + price + "$").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
        OfflinePlayer seller = Bukkit.getOfflinePlayer((UUID)sellerUUID);
        if (seller.isOnline()) {
            Player onlineSeller = seller.getPlayer();
            this.economy.depositPlayer((OfflinePlayer)onlineSeller, (double)price);
            onlineSeller.sendMessage(this.plugin.getMessageHandler().getMessage("blackmarket_sold" + pluginItem.getItemMeta().getDisplayName() + " = " + price + "$").orElse("%prefix% \u00a7eYou sold " + pluginItem.getItemMeta().getDisplayName() + " = " + price + "$").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
        } else {
            this.economy.depositPlayer(seller, (double)price);
            List notifications = this.offlineNotifications.getOrDefault(sellerUUID, new ArrayList());
            notifications.add(this.plugin.getMessageHandler().getMessage("blackmarket_sold_off" + pluginItem.getItemMeta().getDisplayName() + " = " + price + "$").orElse("%prefix% \u00a7eYou sold" + copiedItem.getAmount() + " x " + pluginItem.getItemMeta().getDisplayName() + " = " + price + "$").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            this.offlineNotifications.put(sellerUUID, notifications);
        }
        this.closeAndUpdateBlackMarketForAll();
        this.playerSales.put(player.getUniqueId(), this.playerSales.getOrDefault(player.getUniqueId(), 0) + 1);
        this.salesDataManager.setSalesCount(player.getUniqueId(), this.salesDataManager.getSalesCount(player.getUniqueId()) + 1);
    }

    public void insertItem(Player player, int price) {
        int stackSize;
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        if (!this.isAllowedItem(heldItem)) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("blackmarket_only_pl_items").orElse("%prefix% \u00a7eOnly items created by this plugin can be sold.").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return;
        }
        for (int totalAmount = heldItem.getAmount(); totalAmount > 0; totalAmount -= stackSize) {
            stackSize = Math.min(totalAmount, 64);
            ItemStack marketItemStack = heldItem.clone();
            marketItemStack.setAmount(stackSize);
            ItemMeta meta = marketItemStack.getItemMeta();
            meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "unique_id"), PersistentDataType.STRING, (Object)UUID.randomUUID().toString());
            marketItemStack.setItemMeta(meta);
            MarketItem marketItem = new MarketItem(player.getName(), marketItemStack, price);
            this.marketItems.computeIfAbsent(player.getName(), k -> new ArrayList()).add(marketItem);
        }
        player.getInventory().removeItem(new ItemStack[]{heldItem});
        player.sendMessage(this.plugin.getMessageHandler().getMessage("blackmarket_item_listed").orElse("%prefix% \u00a7eYou inserted your item for").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")) + " " + ChatColor.GOLD + price + " $");
    }

    public void checkExpiredItems() {
        long currentTime = System.currentTimeMillis();
        for (Map.Entry<String, Long> entry : this.itemTimestamps.entrySet()) {
            long timeDifference = currentTime - entry.getValue();
            if (timeDifference <= this.itemExpirationTime * 1000L) continue;
            String itemName = entry.getKey();
            this.marketItems.forEach((seller, items) -> items.removeIf(item -> item.getDisplayName().equals(itemName)));
            String sellerName = itemName;
            Player seller2 = Bukkit.getPlayer((String)sellerName);
            if (seller2 == null || !seller2.isOnline()) continue;
            seller2.getInventory().addItem(new ItemStack[]{new ItemStack(Material.DIRT)});
            seller2.sendMessage(ChatColor.RED + "Your item " + itemName + " has expired and has been returned.");
        }
    }

    private boolean isAllowedItem(ItemStack item) {
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName()) {
            return false;
        }
        String displayName = item.getItemMeta().getDisplayName();
        return displayName.equals(CreatedItems.createHydrogen(this.plugin, this.config).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.createLSD(this.plugin, this.config).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.createLysergicAcid(this.plugin, this.config).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.createNatrium(this.plugin, this.config).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.createpropanolamine(this.plugin, this.config).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.createcigarette(this.plugin, this.config).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.createGlue(this.plugin, this.config).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.createjoint(this.plugin, this.config).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.createLongPapes(this.plugin, this.config).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.getPapeItem(this.plugin, this.config).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.createZippo(this.plugin, this.config).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.getSuperSeedItem(this.plugin).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.getCocainePlantItem(this.plugin).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.getTobaccoPlant(this.plugin).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.getSuperWheatItem(this.plugin).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.getShroomItem(this.plugin).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.getCocaineItem(this.plugin).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.getTobaccoItem(this.plugin).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.createXTC(this.plugin, this.config).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.createIsoSafrole(this.plugin, this.config).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.createpiperonal(this.plugin, this.config).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.createSafrole(this.plugin, this.config).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.createPhenyl(this.plugin, this.config).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.createSpeed(this.plugin, this.config).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.createLiquid(this.plugin, this.config).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.createHeroin(this.plugin, this.config).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.createSyringe(this.plugin, this.config).getItemMeta().getDisplayName()) || displayName.equals(CreatedItems.getShroomItem(this.plugin).getItemMeta().getDisplayName());
    }

    private List<MarketItem> getAllItems() {
        return this.marketItems.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        if (this.offlineNotifications.containsKey(playerUUID)) {
            List<String> notifications = this.offlineNotifications.remove(playerUUID);
            for (String message : notifications) {
                player.sendMessage(ChatColor.YELLOW + message);
            }
        }
    }

    private void removeItemFromMarket(ItemStack itemStack) {
        String uniqueId = (String)itemStack.getItemMeta().getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "unique_id"), PersistentDataType.STRING);
        this.marketItems.values().forEach(itemList -> itemList.removeIf(item -> {
            String itemUniqueId = (String)item.getItemStack().getItemMeta().getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "unique_id"), PersistentDataType.STRING);
            return uniqueId != null && uniqueId.equals(itemUniqueId);
        }));
    }

    private ItemStack getOriginalItem(ItemStack marketItem) {
        String displayName = marketItem.getItemMeta().getDisplayName();
        if (displayName.equals(CreatedItems.createHydrogen(this.plugin, this.config).getItemMeta().getDisplayName())) {
            return CreatedItems.createHydrogen(this.plugin, this.config);
        }
        if (displayName.equals(CreatedItems.createLSD(this.plugin, this.config).getItemMeta().getDisplayName())) {
            return CreatedItems.createLSD(this.plugin, this.config);
        }
        if (displayName.equals(CreatedItems.createLysergicAcid(this.plugin, this.config).getItemMeta().getDisplayName())) {
            return CreatedItems.createLysergicAcid(this.plugin, this.config);
        }
        if (displayName.equals(CreatedItems.createNatrium(this.plugin, this.config).getItemMeta().getDisplayName())) {
            return CreatedItems.createNatrium(this.plugin, this.config);
        }
        if (displayName.equals(CreatedItems.createpropanolamine(this.plugin, this.config).getItemMeta().getDisplayName())) {
            return CreatedItems.createpropanolamine(this.plugin, this.config);
        }
        if (displayName.equals(CreatedItems.createcigarette(this.plugin, this.config).getItemMeta().getDisplayName())) {
            return CreatedItems.createcigarette(this.plugin, this.config);
        }
        if (displayName.equals(CreatedItems.createGlue(this.plugin, this.config).getItemMeta().getDisplayName())) {
            return CreatedItems.createGlue(this.plugin, this.config);
        }
        if (displayName.equals(CreatedItems.createjoint(this.plugin, this.config).getItemMeta().getDisplayName())) {
            return CreatedItems.createjoint(this.plugin, this.config);
        }
        if (displayName.equals(CreatedItems.createLongPapes(this.plugin, this.config).getItemMeta().getDisplayName())) {
            return CreatedItems.createLongPapes(this.plugin, this.config);
        }
        if (displayName.equals(CreatedItems.getPapeItem(this.plugin, this.config).getItemMeta().getDisplayName())) {
            return CreatedItems.getPapeItem(this.plugin, this.config);
        }
        if (displayName.equals(CreatedItems.createZippo(this.plugin, this.config).getItemMeta().getDisplayName())) {
            return CreatedItems.createZippo(this.plugin, this.config);
        }
        if (displayName.equals(CreatedItems.getSuperSeedItem(this.plugin).getItemMeta().getDisplayName())) {
            return CreatedItems.getSuperSeedItem(this.plugin);
        }
        if (displayName.equals(CreatedItems.getCocainePlantItem(this.plugin).getItemMeta().getDisplayName())) {
            return CreatedItems.getCocainePlantItem(this.plugin);
        }
        if (displayName.equals(CreatedItems.getTobaccoPlant(this.plugin).getItemMeta().getDisplayName())) {
            return CreatedItems.getTobaccoPlant(this.plugin);
        }
        if (displayName.equals(CreatedItems.getSuperWheatItem(this.plugin).getItemMeta().getDisplayName())) {
            return CreatedItems.getSuperWheatItem(this.plugin);
        }
        if (displayName.equals(CreatedItems.getCocaineItem(this.plugin).getItemMeta().getDisplayName())) {
            return CreatedItems.getCocaineItem(this.plugin);
        }
        if (displayName.equals(CreatedItems.getTobaccoItem(this.plugin).getItemMeta().getDisplayName())) {
            return CreatedItems.getTobaccoItem(this.plugin);
        }
        if (displayName.equals(CreatedItems.createXTC(this.plugin, this.config).getItemMeta().getDisplayName())) {
            return CreatedItems.createXTC(this.plugin, this.config);
        }
        if (displayName.equals(CreatedItems.createIsoSafrole(this.plugin, this.config).getItemMeta().getDisplayName())) {
            return CreatedItems.createIsoSafrole(this.plugin, this.config);
        }
        if (displayName.equals(CreatedItems.createpiperonal(this.plugin, this.config).getItemMeta().getDisplayName())) {
            return CreatedItems.createpiperonal(this.plugin, this.config);
        }
        if (displayName.equals(CreatedItems.createSafrole(this.plugin, this.config).getItemMeta().getDisplayName())) {
            return CreatedItems.createSafrole(this.plugin, this.config);
        }
        if (displayName.equals(CreatedItems.createPhenyl(this.plugin, this.config).getItemMeta().getDisplayName())) {
            return CreatedItems.createPhenyl(this.plugin, this.config);
        }
        if (displayName.equals(CreatedItems.createSpeed(this.plugin, this.config).getItemMeta().getDisplayName())) {
            return CreatedItems.createSpeed(this.plugin, this.config);
        }
        if (displayName.equals(CreatedItems.createLiquid(this.plugin, this.config).getItemMeta().getDisplayName())) {
            return CreatedItems.createLiquid(this.plugin, this.config);
        }
        if (displayName.equals(CreatedItems.createHeroin(this.plugin, this.config).getItemMeta().getDisplayName())) {
            return CreatedItems.createHeroin(this.plugin, this.config);
        }
        if (displayName.equals(CreatedItems.createSyringe(this.plugin, this.config).getItemMeta().getDisplayName())) {
            return CreatedItems.createSyringe(this.plugin, this.config);
        }
        if (displayName.equals(CreatedItems.createDrugtest(this.plugin, this.config).getItemMeta().getDisplayName())) {
            return CreatedItems.createDrugtest(this.plugin, this.config);
        }
        return null;
    }

    private boolean removeItemFromMarketById(String uniqueId) {
        for (List<MarketItem> itemList : this.marketItems.values()) {
            Iterator<MarketItem> iterator2 = itemList.iterator();
            while (iterator2.hasNext()) {
                MarketItem marketItem = iterator2.next();
                String itemUniqueId = (String)marketItem.getItemStack().getItemMeta().getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "unique_id"), PersistentDataType.STRING);
                if (!uniqueId.equals(itemUniqueId)) continue;
                iterator2.remove();
                return true;
            }
        }
        return false;
    }

    private void closeAndUpdateBlackMarketForAll() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player.getOpenInventory() == null || !player.getOpenInventory().getTitle().equals(this.plugin.getMessageHandler().getMessage("blackmarket_name").orElse("\u00a7eBlack Market"))) continue;
            player.closeInventory();
            this.openBlackMarket(player, 1);
        }
    }

    public void saveMarketItems() {
        File file = new File(this.plugin.getDataFolder(), "market_items.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        List<MarketItem> allItems = this.getAllItems();
        for (int i = 0; i < allItems.size(); ++i) {
            MarketItem item = allItems.get(i);
            String path = "items.item" + i;
            config.set(path + ".seller", (Object)item.getSeller());
            config.set(path + ".price", (Object)item.getPrice());
            config.set(path + ".itemStack", (Object)item.toItemStack().serialize());
        }
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadMarketItems() {
        File file = new File(this.plugin.getDataFolder(), "market_items.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        if (config.contains("items")) {
            for (String key : config.getConfigurationSection("items").getKeys(false)) {
                String seller = config.getString("items." + key + ".seller");
                int price = config.getInt("items." + key + ".price");
                ItemStack itemStack = ItemStack.deserialize((Map)config.getConfigurationSection("items." + key + ".itemStack").getValues(false));
                MarketItem item = new MarketItem(seller, itemStack, price);
                this.addItemToMarket(item);
            }
        }
    }

    public void addItemToMarket(MarketItem item) {
        this.marketItems.computeIfAbsent(item.getSeller(), k -> new ArrayList()).add(item);
    }

    public void showMySales(Player player) {
        UUID playerUUID = player.getUniqueId();
        int salesCount = this.salesDataManager.getSalesCount(playerUUID);
        player.sendMessage(this.plugin.getMessageHandler().getMessage("blackmarket_your_score").orElse("%prefix% \u00a7eYour total sales").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")) + " " + salesCount);
    }

    public void showTopSales(Player player) {
        ArrayList<Map.Entry<UUID, Integer>> sortedSales = new ArrayList<Map.Entry<UUID, Integer>>(this.playerSales.entrySet());
        sortedSales.sort((entry1, entry2) -> ((Integer)entry2.getValue()).compareTo((Integer)entry1.getValue()));
        player.sendMessage(ChatColor.GREEN + "Top 10 Sales:");
        for (int i = 0; i < Math.min(10, sortedSales.size()); ++i) {
            UUID playerUUID = (UUID)((Map.Entry)sortedSales.get(i)).getKey();
            Player topPlayer = Bukkit.getPlayer((UUID)playerUUID);
            int sales = (Integer)((Map.Entry)sortedSales.get(i)).getValue();
            player.sendMessage(i + 1 + ". " + (topPlayer != null ? topPlayer.getName() : "Offline player") + ": " + sales + " sales");
        }
    }

    public void showSalesList(Player player, int page) {
        ArrayList<Map.Entry<UUID, Integer>> sortedSales = new ArrayList<Map.Entry<UUID, Integer>>(this.playerSales.entrySet());
        sortedSales.sort((entry1, entry2) -> ((Integer)entry2.getValue()).compareTo((Integer)entry1.getValue()));
        int totalPlayers = sortedSales.size();
        int totalPages = (int)Math.ceil((double)totalPlayers / 10.0);
        if (page > totalPages || page < 1) {
            player.sendMessage(this.plugin.getMessageHandler().getMessage("blackmarket_invalid_page").orElse("%prefix% \u00a7eInvalid Page").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")));
            return;
        }
        int start = (page - 1) * 10;
        int end = Math.min(page * 10, totalPlayers);
        player.sendMessage(this.plugin.getMessageHandler().getMessage("blackmarket_sales_pages " + page + "/" + totalPages).orElse("%prefix% \u00a7ePage:").replace("%prefix%", this.plugin.getMessageHandler().getMessage("prefix").orElse("\u00a70\u00a7l[\u00a73\u00a7lDrugs\u00a70\u00a7l]")) + " " + page + "/" + totalPages);
        for (int i = start; i < end; ++i) {
            UUID playerUUID = (UUID)((Map.Entry)sortedSales.get(i)).getKey();
            Player listedPlayer = Bukkit.getPlayer((UUID)playerUUID);
            int sales = (Integer)((Map.Entry)sortedSales.get(i)).getValue();
            player.sendMessage(i + 1 + ". " + (listedPlayer != null ? listedPlayer.getName() : "Offline player") + ": " + sales + " sales");
        }
    }
}

