/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.manager;

import de.lars.drugs.manager.CustomWeedItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class CustomWeedManager {
    private final Map<String, CustomWeedItem> weedItems = new HashMap<String, CustomWeedItem>();
    private final Logger logger;

    public CustomWeedManager(JavaPlugin plugin) {
        this.logger = plugin.getLogger();
        this.loadWeedItems(plugin.getConfig());
    }

    private void loadWeedItems(FileConfiguration config) {
        ConfigurationSection section = config.getConfigurationSection("CustomWeedSeed");
        if (section == null) {
            this.logger.warning("No 'Weed' section found in config!");
            return;
        }
        for (String key : section.getKeys(false)) {
            ConfigurationSection weedSection = section.getConfigurationSection(key);
            if (weedSection == null) continue;
            String weedName = weedSection.getString("WeedName", "");
            String weedLore = weedSection.getString("WeedLore", "");
            int weedCustomModelData = weedSection.getInt("WeedCustomModelData", 0);
            int customModelData = weedSection.getInt("Custommodeldata", 0);
            double dropChance = weedSection.getDouble("DropChance", 0.0);
            int seedDropAmount = weedSection.getInt("SeedDropAmount", 1);
            List lore = weedSection.getStringList("Lore");
            List effects = weedSection.getStringList("Effects");
            HashMap<Integer, Integer> dropRates = new HashMap<Integer, Integer>();
            ConfigurationSection dropRateSection = weedSection.getConfigurationSection("DropRates");
            if (dropRateSection != null) {
                for (String dropKey : dropRateSection.getKeys(false)) {
                    dropRates.put(Integer.parseInt(dropKey), dropRateSection.getInt(dropKey));
                }
            }
            CustomWeedItem weedItem = new CustomWeedItem(weedName, weedLore, weedCustomModelData, customModelData, dropChance, seedDropAmount, lore, effects, dropRates);
            this.weedItems.put(key, weedItem);
            this.logger.info("Loaded custom weed: " + key);
        }
        this.logger.info("Total weeds loaded: " + this.weedItems.size());
    }

    public ItemStack createWeedItem(CustomWeedItem customWeedItem) {
        if (customWeedItem == null) {
            return null;
        }
        ItemStack item = new ItemStack(Material.STICK);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(customWeedItem.getWeedName() + " Joint");
            meta.setCustomModelData(Integer.valueOf(customWeedItem.getCustomModelData()));
            meta.setLore(customWeedItem.getLore());
            item.setItemMeta(meta);
        }
        return item;
    }

    public CustomWeedItem getWeed(String name) {
        this.logger.info("Checking for weed: " + name);
        this.logger.info("Available weeds: " + this.weedItems.keySet());
        return this.weedItems.get(name);
    }
}

