/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.manager;

import java.util.List;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MarketItem {
    private final String seller;
    private final ItemStack itemStack;
    private final int price;

    public MarketItem(String seller, ItemStack itemStack, int price) {
        this.seller = seller;
        this.itemStack = itemStack;
        this.price = price;
    }

    public String getSeller() {
        return this.seller;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public int getPrice() {
        return this.price;
    }

    public String getDisplayName() {
        ItemMeta meta = this.itemStack.getItemMeta();
        return meta != null && meta.hasDisplayName() ? meta.getDisplayName() : this.itemStack.getType().toString();
    }

    public ItemStack toItemStack() {
        ItemStack clonedItem = this.itemStack.clone();
        ItemMeta meta = clonedItem.getItemMeta();
        if (meta != null) {
            meta.setLore(List.of("Seller: " + this.seller, "Price: " + this.price + " $"));
            clonedItem.setItemMeta(meta);
        }
        return clonedItem;
    }
}

