/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.manager;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Optional;

public class OptionalTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (!Optional.class.isAssignableFrom(type.getRawType())) {
            return null;
        }
        final TypeAdapter delegate = gson.getAdapter(Object.class);
        return new TypeAdapter<Optional<?>>(){

            public void write(JsonWriter out, Optional<?> value) throws IOException {
                if (value == null || !value.isPresent()) {
                    out.nullValue();
                } else {
                    delegate.write(out, value.get());
                }
            }

            public Optional<?> read(JsonReader in) throws IOException {
                if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                    return Optional.empty();
                }
                return Optional.of(delegate.read(in));
            }
        };
    }
}

