/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.manager;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SalesDataManager {
    private File salesFile;
    private YamlConfiguration salesConfig;
    private Map<UUID, Integer> playerSales;
    private JavaPlugin plugin;

    public SalesDataManager(JavaPlugin plugin) {
        this.plugin = plugin;
        File pluginFolder = plugin.getDataFolder();
        if (!pluginFolder.exists()) {
            pluginFolder.mkdirs();
        }
        this.salesFile = new File(pluginFolder, "sales.yml");
        if (!this.salesFile.exists()) {
            try {
                this.salesFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.salesConfig = YamlConfiguration.loadConfiguration((File)this.salesFile);
        this.playerSales = new HashMap<UUID, Integer>();
        this.loadSalesData();
    }

    public void loadSalesData() {
        if (this.salesConfig.contains("sales")) {
            System.out.println("[Drugs] Loading salesdata...");
            for (String key : this.salesConfig.getConfigurationSection("sales").getKeys(false)) {
                UUID playerUUID = UUID.fromString(key);
                int salesCount = this.salesConfig.getInt("sales." + key);
                this.playerSales.put(playerUUID, salesCount);
                System.out.println("[Drugs] Loaded salesdata for Player " + playerUUID + ": " + salesCount);
            }
        } else {
            System.out.println("[Drugs] No Sold\u00b4s data found starting with a new one :) .");
        }
    }

    public void saveSalesData() {
        for (Map.Entry<UUID, Integer> entry : this.playerSales.entrySet()) {
            this.salesConfig.set("sales." + entry.getKey().toString(), (Object)entry.getValue());
        }
        try {
            this.salesConfig.save(this.salesFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getSalesCount(UUID playerUUID) {
        int salesCount = this.playerSales.getOrDefault(playerUUID, 0);
        return salesCount;
    }

    public void setSalesCount(UUID playerUUID, int salesCount) {
        this.playerSales.put(playerUUID, salesCount);
        this.saveSalesData();
    }

    public void saveSalesDataPeriodically() {
        new BukkitRunnable(){

            public void run() {
                SalesDataManager.this.saveSalesData();
            }
        }.runTaskTimer((Plugin)this.plugin, 6000L, 6000L);
    }
}

