/*
 * Decompiled with CFR 0.152.
 */
package de.lars.drugs.placeholders;

import de.lars.drugs.Drugs;
import de.lars.drugs.commands.HarvestCommand;
import de.lars.drugs.config.Configuration;
import de.lars.drugs.data.DataManager;
import de.lars.drugs.data.HarvestData;
import de.lars.drugs.handler.CreatedItems;
import de.lars.drugs.listener.PlantHarvestListener;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;

public class DrugPlaceholderExpansion
extends PlaceholderExpansion {
    private final Drugs plugin;
    private final DataManager dataManager;
    private final Configuration config;

    public DrugPlaceholderExpansion(Drugs plugin, Configuration config) {
        this.plugin = plugin;
        this.dataManager = plugin.getDataManager();
        this.config = config;
    }

    public String getIdentifier() {
        return "drugs";
    }

    public String getAuthor() {
        return "Lars_SVW";
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer player, String params) {
        Map<UUID, HarvestData> harvestDataMap;
        if (player == null || !player.hasPlayedBefore()) {
            return "0";
        }
        UUID uuid = player.getUniqueId();
        try {
            harvestDataMap = this.dataManager.loadHarvestData();
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Error: " + e.getMessage());
            e.printStackTrace();
            return "0";
        }
        if (harvestDataMap == null || !harvestDataMap.containsKey(uuid)) {
            return "0";
        }
        HarvestData data = harvestDataMap.get(uuid);
        PlantHarvestListener plantHarvestListener = new PlantHarvestListener();
        HarvestCommand harvestCommand = new HarvestCommand(plantHarvestListener, this.plugin);
        switch (params.toLowerCase()) {
            case "top_1_player_harvested_all": {
                return this.getTopPlayer(harvestDataMap, "all", false, 1);
            }
            case "top_2_player_harvested_all": {
                return this.getTopPlayer(harvestDataMap, "all", false, 2);
            }
            case "top_3_player_harvested_all": {
                return this.getTopPlayer(harvestDataMap, "all", false, 3);
            }
            case "top_1_player_planted_all": {
                return this.getTopPlayer(harvestDataMap, "all", true, 1);
            }
            case "top_2_player_planted_all": {
                return this.getTopPlayer(harvestDataMap, "all", true, 2);
            }
            case "top_3_player_planted_all": {
                return this.getTopPlayer(harvestDataMap, "all", true, 3);
            }
            case "top_1_player_harvested_cocaine": {
                return this.getTopPlayer(harvestDataMap, "cocaine", false, 1);
            }
            case "top_2_player_harvested_cocaine": {
                return this.getTopPlayer(harvestDataMap, "cocaine", false, 2);
            }
            case "top_3_player_harvested_cocaine": {
                return this.getTopPlayer(harvestDataMap, "cocaine", false, 3);
            }
            case "top_1_player_planted_cocaine": {
                return this.getTopPlayer(harvestDataMap, "cocaine", true, 1);
            }
            case "top_2_player_planted_cocaine": {
                return this.getTopPlayer(harvestDataMap, "cocaine", true, 2);
            }
            case "top_3_player_planted_cocaine": {
                return this.getTopPlayer(harvestDataMap, "cocaine", true, 3);
            }
            case "top_1_player_harvested_tobacco": {
                return this.getTopPlayer(harvestDataMap, "tobacco", false, 1);
            }
            case "top_2_player_harvested_tobacco": {
                return this.getTopPlayer(harvestDataMap, "tobacco", false, 2);
            }
            case "top_3_player_harvested_tobacco": {
                return this.getTopPlayer(harvestDataMap, "tobacco", false, 3);
            }
            case "top_1_player_planted_tobacco": {
                return this.getTopPlayer(harvestDataMap, "tobacco", true, 1);
            }
            case "top_2_player_planted_tobacco": {
                return this.getTopPlayer(harvestDataMap, "tobacco", true, 2);
            }
            case "top_3_player_planted_tobacco": {
                return this.getTopPlayer(harvestDataMap, "tobacco", true, 3);
            }
            case "top_1_player_harvested_weed": {
                return this.getTopPlayer(harvestDataMap, "weed", false, 1);
            }
            case "top_2_player_harvested_weed": {
                return this.getTopPlayer(harvestDataMap, "weed", false, 2);
            }
            case "top_3_player_harvested_weed": {
                return this.getTopPlayer(harvestDataMap, "weed", false, 3);
            }
            case "top_1_player_planted_weed": {
                return this.getTopPlayer(harvestDataMap, "weed", true, 1);
            }
            case "top_2_player_planted_weed": {
                return this.getTopPlayer(harvestDataMap, "weed", true, 2);
            }
            case "top_3_player_planted_weed": {
                return this.getTopPlayer(harvestDataMap, "weed", true, 3);
            }
            case "harvestedtobacco": {
                return String.valueOf(data.getTobaccoHarvested());
            }
            case "plantedtobacco": {
                return String.valueOf(data.getTobaccoPlanted());
            }
            case "harvestedall": {
                return String.valueOf(data.getTotalHarvested());
            }
            case "plantedall": {
                return String.valueOf(data.getTotalPlanted());
            }
            case "harvestedcocaine": {
                return String.valueOf(data.getCocaineHarvested());
            }
            case "plantedcocaine": {
                return String.valueOf(data.getCocainePlanted());
            }
            case "harvestedweed": {
                return String.valueOf(data.getWeedHarvested());
            }
            case "plantedweed": {
                return String.valueOf(data.getWeedPlanted());
            }
            case "hydrogen": {
                ItemStack hydrogen = CreatedItems.createHydrogen(this.plugin, this.config);
                if (hydrogen != null) {
                    return hydrogen.getType().name();
                }
                return "Item not found";
            }
            case "lsd": {
                ItemStack lsd = CreatedItems.createLSD(this.plugin, this.config);
                if (lsd != null) {
                    return lsd.getType().name();
                }
                return "Item not found";
            }
            case "lysergicacid": {
                ItemStack lysergicacid = CreatedItems.createLysergicAcid(this.plugin, this.config);
                if (lysergicacid != null) {
                    return lysergicacid.getType().name();
                }
                return "Item not found";
            }
            case "sodium": {
                ItemStack sodium = CreatedItems.createNatrium(this.plugin, this.config);
                if (sodium != null) {
                    return sodium.getType().name();
                }
                return "Item not found";
            }
            case "propanolamine": {
                ItemStack propanolamine = CreatedItems.createpropanolamine(this.plugin, this.config);
                if (propanolamine != null) {
                    return propanolamine.getType().name();
                }
                return "Item not found";
            }
            case "cigarette": {
                ItemStack cigarette = CreatedItems.createcigarette(this.plugin, this.config);
                if (cigarette != null) {
                    return cigarette.getType().name();
                }
                return "Item not found";
            }
            case "glue": {
                ItemStack glue = CreatedItems.createGlue(this.plugin, this.config);
                if (glue != null) {
                    return glue.getType().name();
                }
                return "Item not found";
            }
            case "joint": {
                ItemStack joint = CreatedItems.createjoint(this.plugin, this.config);
                if (joint != null) {
                    return joint.getType().name();
                }
                return "Item not found";
            }
            case "longpapes": {
                ItemStack longpapes = CreatedItems.createLongPapes(this.plugin, this.config);
                if (longpapes != null) {
                    return longpapes.getType().name();
                }
                return "Item not found";
            }
            case "papes": {
                ItemStack papes = CreatedItems.getPapeItem(this.plugin, this.config);
                if (papes != null) {
                    return papes.getType().name();
                }
                return "Item not found";
            }
            case "zippo": {
                ItemStack zippo = CreatedItems.createZippo(this.plugin, this.config);
                if (zippo != null) {
                    return zippo.getType().name();
                }
                return "Item not found";
            }
            case "weedseed": {
                ItemStack weedseed = CreatedItems.getSuperSeedItem(this.plugin);
                if (weedseed != null) {
                    return weedseed.getType().name();
                }
                return "Item not found";
            }
            case "cocaineseed": {
                ItemStack cocaineseed = CreatedItems.getCocainePlantItem(this.plugin);
                if (cocaineseed != null) {
                    return cocaineseed.getType().name();
                }
                return "Item not found";
            }
            case "tobaccoseed": {
                ItemStack tobaccoseed = CreatedItems.getTobaccoPlant(this.plugin);
                if (tobaccoseed != null) {
                    return tobaccoseed.getType().name();
                }
                return "Item not found";
            }
            case "weed": {
                ItemStack weed = CreatedItems.getSuperWheatItem(this.plugin);
                if (weed != null) {
                    return weed.getType().name();
                }
                return "Item not found";
            }
            case "shroom": {
                ItemStack shroom = CreatedItems.getShroomItem(this.plugin);
                if (shroom != null) {
                    return shroom.getType().name();
                }
                return "Item not found";
            }
            case "cocaine": {
                ItemStack cocaineItem = CreatedItems.getCocaineItem(this.plugin);
                if (cocaineItem != null) {
                    return cocaineItem.getType().name();
                }
                return "Item not found";
            }
            case "tobacco": {
                ItemStack tobacco = CreatedItems.getTobaccoItem(this.plugin);
                if (tobacco != null) {
                    return tobacco.getType().name();
                }
                return "Item not found";
            }
            case "ecstasy": {
                ItemStack ecstasy = CreatedItems.createXTC(this.plugin, this.config);
                if (ecstasy != null) {
                    return ecstasy.getType().name();
                }
                return "Item not found";
            }
            case "xtc": {
                ItemStack xtc = CreatedItems.createXTC(this.plugin, this.config);
                if (xtc != null) {
                    return xtc.getType().name();
                }
                return "Item not found";
            }
            case "isosafrole": {
                ItemStack isosafrole = CreatedItems.createIsoSafrole(this.plugin, this.config);
                if (isosafrole != null) {
                    return isosafrole.getType().name();
                }
                return "Item not found";
            }
            case "piperonal": {
                ItemStack piperonal = CreatedItems.createpiperonal(this.plugin, this.config);
                if (piperonal != null) {
                    return piperonal.getType().name();
                }
                return "Item not found";
            }
            case "safrole": {
                ItemStack safrole = CreatedItems.createSafrole(this.plugin, this.config);
                if (safrole != null) {
                    return safrole.getType().name();
                }
                return "Item not found";
            }
            case "phenyl": {
                ItemStack phenyl = CreatedItems.createPhenyl(this.plugin, this.config);
                if (phenyl != null) {
                    return phenyl.getType().name();
                }
                return "Item not found";
            }
            case "speed": {
                ItemStack speed = CreatedItems.createSpeed(this.plugin, this.config);
                if (speed != null) {
                    return speed.getType().name();
                }
                return "Item not found";
            }
            case "heroinliquid": {
                ItemStack heroinliquid = CreatedItems.createLiquid(this.plugin, this.config);
                if (heroinliquid != null) {
                    return heroinliquid.getType().name();
                }
                return "Item not found";
            }
            case "heroin": {
                ItemStack heroin = CreatedItems.createHeroin(this.plugin, this.config);
                if (heroin != null) {
                    return heroin.getType().name();
                }
                return "Item not found";
            }
            case "syringe": {
                ItemStack syringe = CreatedItems.createSyringe(this.plugin, this.config);
                if (syringe != null) {
                    return syringe.getType().name();
                }
                return "Item not found";
            }
            case "drugtest": {
                ItemStack drugtest = CreatedItems.createDrugtest(this.plugin, this.config);
                if (drugtest != null) {
                    return drugtest.getType().name();
                }
                return "Item not found";
            }
            case "crack": {
                ItemStack crack = CreatedItems.getCrackitem(this.plugin);
                if (crack != null) {
                    return crack.getType().name();
                }
                return "Item not found";
            }
        }
        return "Invalid placeholder: " + params;
    }

    private String getTopPlayer(Map<UUID, HarvestData> dataMap, String drug, boolean planted, int rank) {
        return dataMap.entrySet().stream().sorted(Comparator.comparingInt(entry -> {
            HarvestData data = (HarvestData)entry.getValue();
            if ("all".equalsIgnoreCase(drug)) {
                return planted ? data.getTotalPlanted() : data.getTotalHarvested();
            }
            switch (drug.toLowerCase()) {
                case "cocaine": {
                    return planted ? data.getCocainePlanted() : data.getCocaineHarvested();
                }
                case "tobacco": {
                    return planted ? data.getTobaccoPlanted() : data.getTobaccoHarvested();
                }
                case "weed": {
                    return planted ? data.getWeedPlanted() : data.getWeedHarvested();
                }
            }
            return 0;
        }).reversed()).skip(rank - 1).map(entry -> Bukkit.getOfflinePlayer((UUID)((UUID)entry.getKey())).getName()).findFirst().orElse("No Data");
    }

    private int getCount(HarvestData data, String type, boolean isPlanted) {
        switch (type.toLowerCase()) {
            case "all": {
                return isPlanted ? data.getTotalPlanted() : data.getTotalHarvested();
            }
            case "cocaine": {
                return isPlanted ? data.getCocainePlanted() : data.getCocaineHarvested();
            }
            case "tobacco": {
                return isPlanted ? data.getTobaccoPlanted() : data.getTobaccoHarvested();
            }
            case "weed": {
                return isPlanted ? data.getWeedPlanted() : data.getWeedHarvested();
            }
        }
        return 0;
    }
}

