/*
 * Decompiled with CFR 0.152.
 */
package de.lars.inventoryframework.abstraction;

import de.lars.inventoryframework.abstraction.util.ObservableValue;
import de.lars.inventoryframework.adventuresupport.StringHolder;
import de.lars.inventoryframework.adventuresupport.TextHolder;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AnvilInventory {
    @NotNull
    protected InventoryHolder inventoryHolder;
    @Deprecated
    @NotNull
    protected String text = "";
    @NotNull
    protected final @NotNull ObservableValue<@NotNull String> observableText = new ObservableValue<String>("");
    protected short cost;

    public AnvilInventory(@NotNull InventoryHolder inventoryHolder) {
        this.inventoryHolder = inventoryHolder;
    }

    public void setCost(short cost) {
        if (cost < 0) {
            throw new IllegalArgumentException("Cost must be non-negative");
        }
        this.cost = cost;
    }

    public final void openInventory(@NotNull Player player, @NotNull String title, @Nullable ItemStack[] items) {
        this.openInventory(player, StringHolder.of(title), items);
    }

    public abstract Inventory openInventory(@NotNull Player var1, @NotNull TextHolder var2, @Nullable ItemStack[] var3);

    @Deprecated
    public abstract void sendItems(@NotNull Player var1, @Nullable ItemStack[] var2);

    @Deprecated
    public abstract void sendResultItem(@NotNull Player var1, @Nullable ItemStack var2);

    @Deprecated
    public abstract void sendFirstItem(@NotNull Player var1, @Nullable ItemStack var2);

    @Deprecated
    public abstract void sendSecondItem(@NotNull Player var1, @Nullable ItemStack var2);

    @Deprecated
    public abstract void setCursor(@NotNull Player var1, @NotNull ItemStack var2);

    @Deprecated
    public abstract void clearCursor(@NotNull Player var1);

    @Deprecated
    public abstract void clearResultItem(@NotNull Player var1);

    @NotNull
    @Contract(pure=true)
    public String getRenameText() {
        String text = this.observableText.get();
        if (text == null) {
            throw new IllegalStateException("Rename text is null");
        }
        return text;
    }

    public void subscribeToNameInputChanges(@NotNull Consumer<? super String> onNameInputChanged) {
        this.observableText.subscribe(onNameInputChanged);
    }
}

