/*
 * Decompiled with CFR 0.152.
 */
package de.lars.inventoryframework.adventuresupport;

import de.lars.inventoryframework.adventuresupport.ComponentHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

class NativeComponentHolder
extends ComponentHolder {
    NativeComponentHolder(@NotNull Component value) {
        super(value);
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Inventory asInventoryTitle(InventoryHolder holder, InventoryType type) {
        return Bukkit.createInventory((InventoryHolder)holder, (InventoryType)type, (Component)this.value);
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Inventory asInventoryTitle(InventoryHolder holder, int size) {
        return Bukkit.createInventory((InventoryHolder)holder, (int)size, (Component)this.value);
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Merchant asMerchantTitle() {
        return Bukkit.createMerchant((Component)this.value);
    }

    @Override
    public void asItemDisplayName(ItemMeta meta) {
        meta.displayName(this.value);
    }

    @Override
    public void asItemLoreAtEnd(ItemMeta meta) {
        List<Component> lore = meta.hasLore() ? Objects.requireNonNull(meta.lore()) : new ArrayList();
        lore.add(this.value);
        meta.lore(lore);
    }
}

