/*
 * Decompiled with CFR 0.152.
 */
package de.lars.inventoryframework.gui.type;

import de.lars.inventoryframework.HumanEntityCache;
import de.lars.inventoryframework.adventuresupport.TextHolder;
import de.lars.inventoryframework.exception.XMLLoadException;
import de.lars.inventoryframework.gui.InventoryComponent;
import de.lars.inventoryframework.gui.type.util.InventoryBased;
import de.lars.inventoryframework.gui.type.util.NamedGui;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SmokerGui
extends NamedGui
implements InventoryBased {
    @NotNull
    private InventoryComponent ingredientComponent = new InventoryComponent(1, 1);
    @NotNull
    private InventoryComponent fuelComponent = new InventoryComponent(1, 1);
    @NotNull
    private InventoryComponent outputComponent = new InventoryComponent(1, 1);
    @NotNull
    private InventoryComponent playerInventoryComponent = new InventoryComponent(9, 4);

    public SmokerGui(@NotNull String title) {
        super(title);
    }

    public SmokerGui(@NotNull TextHolder title) {
        super(title);
    }

    public SmokerGui(@NotNull String title, @NotNull Plugin plugin) {
        super(title, plugin);
    }

    public SmokerGui(@NotNull TextHolder title, @NotNull Plugin plugin) {
        super(title, plugin);
    }

    @Override
    public void show(@NotNull HumanEntity humanEntity) {
        if (this.isDirty()) {
            this.inventory = this.createInventory();
            this.markChanges();
        }
        this.getInventory().clear();
        this.getIngredientComponent().display(this.getInventory(), 0);
        this.getFuelComponent().display(this.getInventory(), 1);
        this.getOutputComponent().display(this.getInventory(), 2);
        this.getPlayerInventoryComponent().display();
        if (this.getPlayerInventoryComponent().hasItem()) {
            HumanEntityCache humanEntityCache = this.getHumanEntityCache();
            if (!humanEntityCache.contains(humanEntity)) {
                humanEntityCache.storeAndClear(humanEntity);
            }
            this.getPlayerInventoryComponent().placeItems(humanEntity.getInventory(), 0);
        }
        humanEntity.openInventory(this.getInventory());
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public SmokerGui copy() {
        SmokerGui gui = new SmokerGui(this.getTitleHolder(), this.plugin);
        gui.ingredientComponent = this.ingredientComponent.copy();
        gui.fuelComponent = this.fuelComponent.copy();
        gui.outputComponent = this.outputComponent.copy();
        gui.playerInventoryComponent = this.playerInventoryComponent.copy();
        gui.setOnTopClick(this.onTopClick);
        gui.setOnBottomClick(this.onBottomClick);
        gui.setOnGlobalClick(this.onGlobalClick);
        gui.setOnOutsideClick(this.onOutsideClick);
        gui.setOnClose(this.onClose);
        return gui;
    }

    @Override
    public void click(@NotNull InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        if (rawSlot == 0) {
            this.getIngredientComponent().click(this, event, 0);
        } else if (rawSlot == 1) {
            this.getFuelComponent().click(this, event, 0);
        } else if (rawSlot == 2) {
            this.getOutputComponent().click(this, event, 0);
        } else {
            this.getPlayerInventoryComponent().click(this, event, rawSlot - 3);
        }
    }

    @NotNull
    public Inventory getInventory() {
        if (this.inventory == null) {
            this.inventory = this.createInventory();
        }
        return this.inventory;
    }

    @Override
    @Contract(pure=true)
    public boolean isPlayerInventoryUsed() {
        return this.getPlayerInventoryComponent().hasItem();
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Inventory createInventory() {
        return this.getTitleHolder().asInventoryTitle((InventoryHolder)this, InventoryType.SMOKER);
    }

    @Override
    @Contract(pure=true)
    public int getViewerCount() {
        return this.getInventory().getViewers().size();
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public List<HumanEntity> getViewers() {
        return new ArrayList<HumanEntity>(this.getInventory().getViewers());
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getIngredientComponent() {
        return this.ingredientComponent;
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getFuelComponent() {
        return this.fuelComponent;
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getOutputComponent() {
        return this.outputComponent;
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getPlayerInventoryComponent() {
        return this.playerInventoryComponent;
    }

    @Nullable
    @Contract(pure=true)
    public static SmokerGui load(@NotNull Object instance, @NotNull InputStream inputStream2, @NotNull Plugin plugin) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream2);
            Element documentElement = document.getDocumentElement();
            documentElement.normalize();
            return SmokerGui.load(instance, documentElement, plugin);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
            return null;
        }
    }

    @NotNull
    public static SmokerGui load(@NotNull Object instance, @NotNull Element element, @NotNull Plugin plugin) {
        if (!element.hasAttribute("title")) {
            throw new XMLLoadException("Provided XML element's gui tag doesn't have the mandatory title attribute set");
        }
        SmokerGui smokerGui = new SmokerGui(element.getAttribute("title"), plugin);
        smokerGui.initializeOrThrow(instance, element);
        if (element.hasAttribute("populate")) {
            return smokerGui;
        }
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            InventoryComponent component;
            Node item = childNodes.item(index);
            if (item.getNodeType() != 1) continue;
            Element componentElement = (Element)item;
            if (!componentElement.getTagName().equalsIgnoreCase("component")) {
                throw new XMLLoadException("Gui element contains non-component tags");
            }
            if (!componentElement.hasAttribute("name")) {
                throw new XMLLoadException("Component tag does not have a name specified");
            }
            switch (componentElement.getAttribute("name")) {
                case "ingredient": {
                    component = smokerGui.getIngredientComponent();
                    break;
                }
                case "fuel": {
                    component = smokerGui.getFuelComponent();
                    break;
                }
                case "output": {
                    component = smokerGui.getOutputComponent();
                    break;
                }
                case "player-inventory": {
                    component = smokerGui.getPlayerInventoryComponent();
                    break;
                }
                default: {
                    throw new XMLLoadException("Unknown component name");
                }
            }
            component.load(instance, componentElement, plugin);
        }
        return smokerGui;
    }

    @Nullable
    @Contract(pure=true)
    public static SmokerGui load(@NotNull Object instance, @NotNull InputStream inputStream2) {
        return SmokerGui.load(instance, inputStream2, (Plugin)JavaPlugin.getProvidingPlugin(SmokerGui.class));
    }

    @NotNull
    public static SmokerGui load(@NotNull Object instance, @NotNull Element element) {
        return SmokerGui.load(instance, element, (Plugin)JavaPlugin.getProvidingPlugin(SmokerGui.class));
    }
}

