/*
 * Decompiled with CFR 0.152.
 */
package de.lars.inventoryframework.nms.v1_14;

import de.lars.inventoryframework.abstraction.BeaconInventory;
import java.lang.reflect.Field;
import net.minecraft.server.v1_14_R1.ChatMessage;
import net.minecraft.server.v1_14_R1.Container;
import net.minecraft.server.v1_14_R1.ContainerBeacon;
import net.minecraft.server.v1_14_R1.Containers;
import net.minecraft.server.v1_14_R1.EntityHuman;
import net.minecraft.server.v1_14_R1.EntityPlayer;
import net.minecraft.server.v1_14_R1.IChatBaseComponent;
import net.minecraft.server.v1_14_R1.IInventory;
import net.minecraft.server.v1_14_R1.NonNullList;
import net.minecraft.server.v1_14_R1.Packet;
import net.minecraft.server.v1_14_R1.PacketPlayOutOpenWindow;
import net.minecraft.server.v1_14_R1.PacketPlayOutSetSlot;
import net.minecraft.server.v1_14_R1.PacketPlayOutWindowItems;
import net.minecraft.server.v1_14_R1.PlayerConnection;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftInventoryBeacon;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeaconInventoryImpl
extends BeaconInventory {
    public BeaconInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public void openInventory(@NotNull Player player, @Nullable ItemStack item) {
        EntityPlayer entityPlayer = this.getEntityPlayer(player);
        ContainerBeaconImpl containerBeacon = new ContainerBeaconImpl(entityPlayer, item);
        entityPlayer.activeContainer = containerBeacon;
        int id = containerBeacon.windowId;
        ChatMessage message = new ChatMessage("Beacon", new Object[0]);
        entityPlayer.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(id, Containers.BEACON, (IChatBaseComponent)message));
        this.sendItem(player, item);
    }

    @Override
    public void sendItem(@NotNull Player player, @Nullable ItemStack item) {
        NonNullList items = NonNullList.a((Object)net.minecraft.server.v1_14_R1.ItemStack.a, (Object[])new net.minecraft.server.v1_14_R1.ItemStack[]{CraftItemStack.asNMSCopy((ItemStack)item)});
        EntityPlayer entityPlayer = this.getEntityPlayer(player);
        this.getPlayerConnection(entityPlayer).sendPacket((Packet)new PacketPlayOutWindowItems(this.getWindowId(entityPlayer), items));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        this.getPlayerConnection(this.getEntityPlayer(player)).sendPacket((Packet)new PacketPlayOutSetSlot(-1, -1, net.minecraft.server.v1_14_R1.ItemStack.a));
    }

    @Contract(pure=true)
    private int getWindowId(@NotNull EntityPlayer entityPlayer) {
        return entityPlayer.activeContainer.windowId;
    }

    @NotNull
    @Contract(pure=true)
    private PlayerConnection getPlayerConnection(@NotNull EntityPlayer entityPlayer) {
        return entityPlayer.playerConnection;
    }

    @NotNull
    @Contract(pure=true)
    private EntityPlayer getEntityPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private class ContainerBeaconImpl
    extends ContainerBeacon {
        @NotNull
        private final Player player;
        @Nullable
        private CraftInventoryView bukkitEntity;
        @NotNull
        private final Field beaconField;

        public ContainerBeaconImpl(@Nullable EntityPlayer entityPlayer, ItemStack item) {
            super(entityPlayer.nextContainerCounter(), (IInventory)entityPlayer.inventory);
            this.player = entityPlayer.getBukkitEntity();
            try {
                this.beaconField = ContainerBeacon.class.getDeclaredField("beacon");
                this.beaconField.setAccessible(true);
            }
            catch (NoSuchFieldException exception) {
                throw new RuntimeException(exception);
            }
            try {
                net.minecraft.server.v1_14_R1.ItemStack itemStack = CraftItemStack.asNMSCopy((ItemStack)item);
                ((IInventory)this.beaconField.get((Object)this)).setItem(0, itemStack);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
        }

        @NotNull
        public CraftInventoryView getBukkitView() {
            if (this.bukkitEntity == null) {
                try {
                    CraftInventoryBeacon inventory = new CraftInventoryBeacon((IInventory)this.beaconField.get((Object)this)){

                        @NotNull
                        @Contract(pure=true)
                        public InventoryHolder getHolder() {
                            return BeaconInventoryImpl.this.inventoryHolder;
                        }
                    };
                    this.bukkitEntity = new CraftInventoryView((HumanEntity)this.player, (Inventory)inventory, (Container)this);
                }
                catch (IllegalAccessException exception) {
                    throw new RuntimeException(exception);
                }
            }
            return this.bukkitEntity;
        }

        @Contract(pure=true, value="_ -> true")
        public boolean canUse(@Nullable EntityHuman entityhuman) {
            return true;
        }

        public void a(IInventory inventory) {
        }

        public void b(EntityHuman entityhuman) {
        }
    }
}

