/*
 * Decompiled with CFR 0.152.
 */
package de.lars.inventoryframework.nms.v1_16_2_3;

import de.lars.inventoryframework.abstraction.MerchantInventory;
import java.util.List;
import java.util.Map;
import net.minecraft.server.v1_16_R2.EntityPlayer;
import net.minecraft.server.v1_16_R2.MerchantRecipeList;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R2.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class MerchantInventoryImpl
extends MerchantInventory {
    @Override
    public void sendMerchantOffers(@NotNull Player player, @NotNull List<? extends Map.Entry<? extends MerchantRecipe, ? extends Integer>> trades, int level, int experience) {
        MerchantRecipeList offers = new MerchantRecipeList();
        for (Map.Entry<? extends MerchantRecipe, ? extends Integer> entry : trades) {
            MerchantRecipe recipe = entry.getKey();
            List ingredients = recipe.getIngredients();
            if (ingredients.size() < 1) {
                throw new IllegalStateException("Merchant recipe has no ingredients");
            }
            ItemStack itemA = (ItemStack)ingredients.get(0);
            ItemStack itemB = null;
            if (ingredients.size() >= 2) {
                itemB = (ItemStack)ingredients.get(1);
            }
            net.minecraft.server.v1_16_R2.ItemStack nmsItemA = CraftItemStack.asNMSCopy((ItemStack)itemA);
            net.minecraft.server.v1_16_R2.ItemStack nmsItemB = net.minecraft.server.v1_16_R2.ItemStack.b;
            net.minecraft.server.v1_16_R2.ItemStack nmsItemResult = CraftItemStack.asNMSCopy((ItemStack)recipe.getResult());
            if (itemB != null) {
                nmsItemB = CraftItemStack.asNMSCopy((ItemStack)itemB);
            }
            int uses = recipe.getUses();
            int maxUses = recipe.getMaxUses();
            int exp = recipe.getVillagerExperience();
            float multiplier = recipe.getPriceMultiplier();
            net.minecraft.server.v1_16_R2.MerchantRecipe merchantOffer = new net.minecraft.server.v1_16_R2.MerchantRecipe(nmsItemA, nmsItemB, nmsItemResult, uses, maxUses, exp, multiplier);
            merchantOffer.setSpecialPrice(entry.getValue().intValue());
            offers.add((Object)merchantOffer);
        }
        EntityPlayer entityPlayer = this.getEntityPlayer(player);
        entityPlayer.openTrade(this.getWindowId(entityPlayer), offers, level, experience, true, false);
    }

    @NotNull
    @Contract(pure=true)
    private EntityPlayer getEntityPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    @Contract(pure=true)
    private int getWindowId(@NotNull EntityPlayer entityPlayer) {
        return entityPlayer.activeContainer.windowId;
    }
}

