/*
 * Decompiled with CFR 0.152.
 */
package de.lars.inventoryframework.nms.v1_16_4_5;

import de.lars.inventoryframework.abstraction.GrindstoneInventory;
import de.lars.inventoryframework.adventuresupport.TextHolder;
import de.lars.inventoryframework.nms.v1_16_4_5.util.TextHolderUtil;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.v1_16_R3.Container;
import net.minecraft.server.v1_16_R3.ContainerGrindstone;
import net.minecraft.server.v1_16_R3.Containers;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.ICrafting;
import net.minecraft.server.v1_16_R3.IInventory;
import net.minecraft.server.v1_16_R3.IMaterial;
import net.minecraft.server.v1_16_R3.InventoryClickType;
import net.minecraft.server.v1_16_R3.Items;
import net.minecraft.server.v1_16_R3.NBTBase;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.NBTTagLongArray;
import net.minecraft.server.v1_16_R3.NonNullList;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketPlayOutOpenWindow;
import net.minecraft.server.v1_16_R3.PacketPlayOutSetSlot;
import net.minecraft.server.v1_16_R3.PacketPlayOutWindowItems;
import net.minecraft.server.v1_16_R3.PlayerConnection;
import net.minecraft.server.v1_16_R3.Slot;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrindstoneInventoryImpl
extends GrindstoneInventory {
    public GrindstoneInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public Inventory openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 3) {
            throw new IllegalArgumentException("The amount of items for a grindstone should be 3, but is '" + itemAmount + "'");
        }
        EntityPlayer entityPlayer = this.getEntityPlayer(player);
        CraftEventFactory.handleInventoryCloseEvent((EntityHuman)entityPlayer);
        entityPlayer.activeContainer = entityPlayer.defaultContainer;
        IChatBaseComponent message = TextHolderUtil.toComponent(title);
        ContainerGrindstoneImpl containerGrindstone = new ContainerGrindstoneImpl(entityPlayer);
        Inventory inventory = containerGrindstone.getBukkitView().getTopInventory();
        inventory.setItem(0, items[0]);
        inventory.setItem(1, items[1]);
        inventory.setItem(2, items[2]);
        int windowId = containerGrindstone.getWindowId();
        entityPlayer.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(windowId, Containers.GRINDSTONE, message));
        entityPlayer.activeContainer = containerGrindstone;
        entityPlayer.syncInventory();
        return inventory;
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items, @Nullable ItemStack cursor) {
        NonNullList nmsItems = NonNullList.a((Object)net.minecraft.server.v1_16_R3.ItemStack.b, (Object[])new net.minecraft.server.v1_16_R3.ItemStack[]{CraftItemStack.asNMSCopy((ItemStack)items[0]), CraftItemStack.asNMSCopy((ItemStack)items[1]), CraftItemStack.asNMSCopy((ItemStack)items[2])});
        EntityPlayer entityPlayer = this.getEntityPlayer(player);
        this.getPlayerConnection(entityPlayer).sendPacket((Packet)new PacketPlayOutWindowItems(this.getWindowId(entityPlayer), nmsItems));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        this.getPlayerConnection(this.getEntityPlayer(player)).sendPacket((Packet)new PacketPlayOutSetSlot(-1, -1, net.minecraft.server.v1_16_R3.ItemStack.b));
    }

    @Contract(pure=true)
    private int getWindowId(@NotNull EntityPlayer entityPlayer) {
        return entityPlayer.activeContainer.windowId;
    }

    @NotNull
    @Contract(pure=true)
    private PlayerConnection getPlayerConnection(@NotNull EntityPlayer entityPlayer) {
        return entityPlayer.playerConnection;
    }

    @NotNull
    @Contract(pure=true)
    private EntityPlayer getEntityPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private static class ContainerGrindstoneImpl
    extends ContainerGrindstone {
        @NotNull
        private final net.minecraft.server.v1_16_R3.ItemStack uniqueItem;
        @NotNull
        private final Field listenersField;

        public ContainerGrindstoneImpl(@NotNull EntityPlayer entityPlayer) {
            super(entityPlayer.nextContainerCounter(), entityPlayer.inventory);
            try {
                this.listenersField = Container.class.getDeclaredField("listeners");
                this.listenersField.setAccessible(true);
            }
            catch (NoSuchFieldException exception) {
                throw new RuntimeException("Unable to access field 'listeners'", exception);
            }
            Slot firstSlot = (Slot)this.slots.get(0);
            Slot secondSlot = (Slot)this.slots.get(1);
            Slot thirdSlot = (Slot)this.slots.get(2);
            this.slots.set(0, new Slot(firstSlot.inventory, firstSlot.rawSlotIndex, firstSlot.e, firstSlot.f){

                public boolean isAllowed(net.minecraft.server.v1_16_R3.ItemStack stack) {
                    return true;
                }
            });
            this.slots.set(1, new Slot(secondSlot.inventory, secondSlot.rawSlotIndex, secondSlot.e, secondSlot.f){

                public boolean isAllowed(net.minecraft.server.v1_16_R3.ItemStack stack) {
                    return true;
                }
            });
            this.slots.set(2, new Slot(thirdSlot.inventory, thirdSlot.rawSlotIndex, thirdSlot.e, thirdSlot.f){

                public boolean isAllowed(net.minecraft.server.v1_16_R3.ItemStack stack) {
                    return true;
                }

                public net.minecraft.server.v1_16_R3.ItemStack a(EntityHuman entityHuman, net.minecraft.server.v1_16_R3.ItemStack itemStack) {
                    return itemStack;
                }
            });
            this.uniqueItem = new net.minecraft.server.v1_16_R3.ItemStack((IMaterial)Items.COOKIE);
            UUID uuid = UUID.randomUUID();
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.set("uuid", (NBTBase)new NBTTagLongArray(new long[]{uuid.getLeastSignificantBits(), uuid.getMostSignificantBits()}));
            this.uniqueItem.setTag(nbtTagCompound);
        }

        public void forceUpdate() {
            List listeners;
            Collections.fill(this.items, this.uniqueItem);
            this.notifyListeners();
            try {
                listeners = (List)this.listenersField.get((Object)this);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException("Unable to access field 'listeners'", exception);
            }
            for (ICrafting listener : listeners) {
                if (!(listener instanceof EntityPlayer)) continue;
                EntityPlayer player = (EntityPlayer)listener;
                player.e = false;
                player.broadcastCarriedItem();
            }
        }

        public net.minecraft.server.v1_16_R3.ItemStack a(int i, int j, InventoryClickType inventoryclicktype, EntityHuman entityhuman) {
            net.minecraft.server.v1_16_R3.ItemStack itemStack = super.a(i, j, inventoryclicktype, entityhuman);
            this.forceUpdate();
            return itemStack;
        }

        @Contract(pure=true, value="_ -> true")
        public boolean canUse(@Nullable EntityHuman entityHuman) {
            return true;
        }

        public void a(IInventory inventory) {
        }

        public void b(EntityHuman entityHuman) {
        }

        public int getWindowId() {
            return this.windowId;
        }
    }
}

