/*
 * Decompiled with CFR 0.152.
 */
package de.lars.inventoryframework.nms.v1_17_0;

import de.lars.inventoryframework.abstraction.SmithingTableInventory;
import de.lars.inventoryframework.adventuresupport.TextHolder;
import de.lars.inventoryframework.nms.v1_17_0.util.CustomInventoryUtil;
import de.lars.inventoryframework.nms.v1_17_0.util.TextHolderUtil;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftInventorySmithing;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmithingTableInventoryImpl
extends SmithingTableInventory {
    public SmithingTableInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    @Nullable
    public Inventory openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 3) {
            throw new IllegalArgumentException("The amount of items for a smithing table should be 3, but is '" + itemAmount + "'");
        }
        abs serverPlayer = this.getServerPlayer(player);
        ContainerSmithingTableImpl containerSmithingTable = new ContainerSmithingTableImpl(serverPlayer, items);
        serverPlayer.bV = containerSmithingTable;
        int id = containerSmithingTable.j;
        os message = TextHolderUtil.toComponent(title);
        serverPlayer.b.a((pk)new rg(id, bnn.u, message));
        this.sendItems(player, items, null);
        return null;
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items, @Nullable ItemStack item) {
        gs<bqp> nmsItems = CustomInventoryUtil.convertToNMSItems(items);
        abs serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((bkd)serverPlayer);
        this.getPlayerConnection(serverPlayer).a((pk)new qi(containerId, nmsItems));
    }

    @Override
    public void sendFirstItem(@NotNull Player player, @Nullable ItemStack item) {
        abs serverPlayer = this.getServerPlayer(player);
        bqp nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        int containerId = this.getContainerId((bkd)serverPlayer);
        this.getPlayerConnection(serverPlayer).a((pk)new qk(containerId, 0, nmsItem));
    }

    @Override
    public void sendSecondItem(@NotNull Player player, @Nullable ItemStack item) {
        abs serverPlayer = this.getServerPlayer(player);
        bqp nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        int containerId = this.getContainerId((bkd)serverPlayer);
        this.getPlayerConnection(serverPlayer).a((pk)new qk(containerId, 1, nmsItem));
    }

    @Override
    public void sendResultItem(@NotNull Player player, @Nullable ItemStack item) {
        this.sendResultItem(player, CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public void clearResultItem(@NotNull Player player) {
        this.sendResultItem(player, bqp.b);
    }

    @Override
    public void setCursor(@NotNull Player player, @NotNull ItemStack item) {
        this.setCursor(player, CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        qk packet = new qk(-1, -1, bqp.b);
        this.getPlayerConnection(this.getServerPlayer(player)).a((pk)packet);
    }

    private void setCursor(@NotNull Player player, @NotNull bqp item) {
        this.getPlayerConnection(this.getServerPlayer(player)).a((pk)new qk(-1, -1, item));
    }

    private void sendResultItem(@NotNull Player player, @NotNull bqp item) {
        abs serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((bkd)serverPlayer);
        this.getPlayerConnection(serverPlayer).a((pk)new qk(containerId, 2, item));
    }

    @Contract(pure=true)
    private int getContainerId(@NotNull bkd nmsPlayer) {
        return nmsPlayer.bV.j;
    }

    @NotNull
    @Contract(pure=true)
    private acm getPlayerConnection(@NotNull abs serverPlayer) {
        return serverPlayer.b;
    }

    @NotNull
    @Contract(pure=true)
    private abs getServerPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private class ContainerSmithingTableImpl
    extends bob {
        @NotNull
        private final Player player;
        @Nullable
        private CraftInventoryView bukkitEntity;

        public ContainerSmithingTableImpl(@Nullable abs serverPlayer, ItemStack[] items) {
            super(serverPlayer.nextContainerCounter(), serverPlayer.fj(), bmu.a((bwp)serverPlayer.cv(), (gg)new gg(0, 0, 0)));
            this.player = serverPlayer.getBukkitEntity();
            this.p.a(0, CraftItemStack.asNMSCopy((ItemStack)items[0]));
            this.p.a(1, CraftItemStack.asNMSCopy((ItemStack)items[1]));
            this.o.a(0, CraftItemStack.asNMSCopy((ItemStack)items[2]));
        }

        @NotNull
        public CraftInventoryView getBukkitView() {
            if (this.bukkitEntity == null) {
                CraftInventorySmithing inventory = new CraftInventorySmithing(this.q.getLocation(), this.p, this.o){

                    @NotNull
                    @Contract(pure=true)
                    public InventoryHolder getHolder() {
                        return SmithingTableInventoryImpl.this.inventoryHolder;
                    }
                };
                this.bukkitEntity = new CraftInventoryView((HumanEntity)this.player, (Inventory)inventory, (bmj)this);
            }
            return this.bukkitEntity;
        }

        @Contract(pure=true, value="_ -> true")
        public boolean a(@Nullable bkd nmsPlayer) {
            return true;
        }

        public void a(art container) {
        }

        public void b(bkd nmsPlayer) {
        }
    }
}

