/*
 * Decompiled with CFR 0.152.
 */
package de.lars.inventoryframework.nms.v1_18_1;

import de.lars.inventoryframework.abstraction.BeaconInventory;
import java.lang.reflect.Field;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerBeacon;
import net.minecraft.world.inventory.Containers;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftInventoryBeacon;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeaconInventoryImpl
extends BeaconInventory {
    public BeaconInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public void openInventory(@NotNull Player player, @Nullable ItemStack item) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        ContainerBeaconImpl containerBeacon = new ContainerBeaconImpl(serverPlayer, item);
        serverPlayer.bW = containerBeacon;
        int id = containerBeacon.j;
        ChatMessage message = new ChatMessage("Beacon");
        serverPlayer.b.a((Packet)new PacketPlayOutOpenWindow(id, Containers.i, (IChatBaseComponent)message));
        this.sendItem(player, item);
    }

    @Override
    public void sendItem(@NotNull Player player, @Nullable ItemStack item) {
        NonNullList items = NonNullList.a((Object)net.minecraft.world.item.ItemStack.b, (Object[])new net.minecraft.world.item.ItemStack[]{CraftItemStack.asNMSCopy((ItemStack)item)});
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((EntityHuman)serverPlayer);
        int state = serverPlayer.bW.k();
        net.minecraft.world.item.ItemStack cursor = CraftItemStack.asNMSCopy((ItemStack)player.getItemOnCursor());
        ServerPlayerConnection playerConnection = this.getPlayerConnection(serverPlayer);
        playerConnection.a((Packet)new PacketPlayOutWindowItems(containerId, state, items, cursor));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int state = serverPlayer.bW.k();
        this.getPlayerConnection(serverPlayer).a((Packet)new PacketPlayOutSetSlot(-1, state, -1, net.minecraft.world.item.ItemStack.b));
    }

    @Contract(pure=true)
    private int getContainerId(@NotNull EntityHuman nmsPlayer) {
        return nmsPlayer.bW.j;
    }

    @NotNull
    @Contract(pure=true)
    private ServerPlayerConnection getPlayerConnection(@NotNull EntityPlayer serverPlayer) {
        return serverPlayer.b;
    }

    @NotNull
    @Contract(pure=true)
    private EntityPlayer getServerPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private class ContainerBeaconImpl
    extends ContainerBeacon {
        @NotNull
        private final Player player;
        @Nullable
        private CraftInventoryView bukkitEntity;
        @NotNull
        private final Field beaconField;

        public ContainerBeaconImpl(@Nullable EntityPlayer serverPlayer, ItemStack item) {
            super(serverPlayer.nextContainerCounter(), (IInventory)serverPlayer.fq());
            this.player = serverPlayer.getBukkitEntity();
            try {
                this.beaconField = ContainerBeacon.class.getDeclaredField("r");
                this.beaconField.setAccessible(true);
            }
            catch (NoSuchFieldException exception) {
                throw new RuntimeException(exception);
            }
            try {
                net.minecraft.world.item.ItemStack itemStack = CraftItemStack.asNMSCopy((ItemStack)item);
                ((IInventory)this.beaconField.get((Object)this)).a(0, itemStack);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
        }

        @NotNull
        public CraftInventoryView getBukkitView() {
            if (this.bukkitEntity == null) {
                try {
                    CraftInventoryBeacon inventory = new CraftInventoryBeacon((IInventory)this.beaconField.get((Object)this)){

                        @NotNull
                        @Contract(pure=true)
                        public InventoryHolder getHolder() {
                            return BeaconInventoryImpl.this.inventoryHolder;
                        }
                    };
                    this.bukkitEntity = new CraftInventoryView((HumanEntity)this.player, (Inventory)inventory, (Container)this);
                }
                catch (IllegalAccessException exception) {
                    throw new RuntimeException(exception);
                }
            }
            return this.bukkitEntity;
        }

        @Contract(pure=true, value="_ -> true")
        public boolean a(@Nullable EntityHuman nmsPlayer) {
            return true;
        }

        public void a(IInventory container) {
        }

        public void b(EntityHuman nmsPlayer) {
        }
    }
}

