/*
 * Decompiled with CFR 0.152.
 */
package de.lars.inventoryframework.nms.v1_19_1;

import de.lars.inventoryframework.abstraction.CartographyTableInventory;
import de.lars.inventoryframework.adventuresupport.TextHolder;
import de.lars.inventoryframework.nms.v1_19_1.util.CustomInventoryUtil;
import de.lars.inventoryframework.nms.v1_19_1.util.TextHolderUtil;
import java.lang.reflect.Field;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerCartography;
import net.minecraft.world.inventory.Containers;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R1.inventory.CraftInventoryCartography;
import org.bukkit.craftbukkit.v1_19_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_19_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CartographyTableInventoryImpl
extends CartographyTableInventory {
    public CartographyTableInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public void openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 3) {
            throw new IllegalArgumentException("The amount of items for a cartography table should be 3, but is '" + itemAmount + "'");
        }
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        ContainerCartographyTableImpl containerCartographyTable = new ContainerCartographyTableImpl(serverPlayer, items);
        serverPlayer.bU = containerCartographyTable;
        int id = containerCartographyTable.j;
        IChatBaseComponent message = TextHolderUtil.toComponent(title);
        serverPlayer.b.a((Packet)new PacketPlayOutOpenWindow(id, Containers.w, message));
        this.sendItems(player, items);
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items) {
        NonNullList<net.minecraft.world.item.ItemStack> nmsItems = CustomInventoryUtil.convertToNMSItems(items);
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((EntityHuman)serverPlayer);
        int state = serverPlayer.bU.k();
        net.minecraft.world.item.ItemStack cursor = CraftItemStack.asNMSCopy((ItemStack)player.getItemOnCursor());
        ServerPlayerConnection playerConnection = this.getPlayerConnection(serverPlayer);
        playerConnection.a((Packet)new PacketPlayOutWindowItems(containerId, state, nmsItems, cursor));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int state = serverPlayer.bU.k();
        this.getPlayerConnection(serverPlayer).a((Packet)new PacketPlayOutSetSlot(-1, state, -1, net.minecraft.world.item.ItemStack.b));
    }

    @Contract(pure=true)
    private int getContainerId(@NotNull EntityHuman nmsPlayer) {
        return nmsPlayer.bU.j;
    }

    @NotNull
    @Contract(pure=true)
    private ServerPlayerConnection getPlayerConnection(@NotNull EntityPlayer serverPlayer) {
        return serverPlayer.b;
    }

    @NotNull
    @Contract(pure=true)
    private EntityPlayer getServerPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private class ContainerCartographyTableImpl
    extends ContainerCartography {
        @NotNull
        private final Player player;
        @Nullable
        private CraftInventoryView bukkitEntity;
        @NotNull
        private final Field resultContainerField;

        public ContainerCartographyTableImpl(@Nullable EntityPlayer serverPlayer, ItemStack[] items) {
            super(serverPlayer.nextContainerCounter(), serverPlayer.fA());
            this.player = serverPlayer.getBukkitEntity();
            try {
                this.resultContainerField = ContainerCartography.class.getDeclaredField("u");
                this.resultContainerField.setAccessible(true);
            }
            catch (NoSuchFieldException exception) {
                throw new RuntimeException(exception);
            }
            this.n.a(0, CraftItemStack.asNMSCopy((ItemStack)items[0]));
            this.n.a(1, CraftItemStack.asNMSCopy((ItemStack)items[1]));
            this.getResultInventory().a(0, CraftItemStack.asNMSCopy((ItemStack)items[2]));
        }

        @NotNull
        public CraftInventoryView getBukkitView() {
            if (this.bukkitEntity == null) {
                CraftInventoryCartography inventory = new CraftInventoryCartography(this.n, this.getResultInventory()){

                    @NotNull
                    @Contract(pure=true)
                    public InventoryHolder getHolder() {
                        return CartographyTableInventoryImpl.this.inventoryHolder;
                    }
                };
                this.bukkitEntity = new CraftInventoryView((HumanEntity)this.player, (Inventory)inventory, (Container)this);
            }
            return this.bukkitEntity;
        }

        @Contract(pure=true, value="_ -> true")
        public boolean a(@Nullable EntityHuman nmsPlayer) {
            return true;
        }

        public void a(IInventory container) {
        }

        public void b(EntityHuman nmsPlayer) {
        }

        @NotNull
        @Contract(pure=true)
        private IInventory getResultInventory() {
            try {
                return (IInventory)this.resultContainerField.get((Object)this);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

