/*
 * Decompiled with CFR 0.152.
 */
package de.lars.inventoryframework.nms.v1_20_0;

import de.lars.inventoryframework.abstraction.AnvilInventory;
import de.lars.inventoryframework.adventuresupport.TextHolder;
import de.lars.inventoryframework.nms.v1_20_0.util.CustomInventoryUtil;
import de.lars.inventoryframework.nms.v1_20_0.util.TextHolderUtil;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnvilInventoryImpl
extends AnvilInventory {
    public AnvilInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public Inventory openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 3) {
            throw new IllegalArgumentException("The amount of items for an anvil should be 3, but is '" + itemAmount + "'");
        }
        aig serverPlayer = this.getServerPlayer(player);
        CraftEventFactory.handleInventoryCloseEvent((byo)serverPlayer);
        serverPlayer.bR = serverPlayer.bQ;
        sw message = TextHolderUtil.toComponent(title);
        ContainerAnvilImpl containerAnvil = new ContainerAnvilImpl(serverPlayer, message);
        Inventory inventory = containerAnvil.getBukkitView().getTopInventory();
        inventory.setItem(0, items[0]);
        inventory.setItem(1, items[1]);
        inventory.setItem(2, items[2]);
        int containerId = containerAnvil.getContainerId();
        serverPlayer.c.a((uo)new wo(containerId, cck.h, message));
        serverPlayer.bR = containerAnvil;
        serverPlayer.a((cbf)containerAnvil);
        return inventory;
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items) {
        hn<cfz> nmsItems = CustomInventoryUtil.convertToNMSItems(items);
        aig serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((byo)serverPlayer);
        int state = serverPlayer.bR.k();
        cfz cursor = CraftItemStack.asNMSCopy((ItemStack)player.getItemOnCursor());
        ajb playerConnection = this.getPlayerConnection(serverPlayer);
        playerConnection.a((uo)new vk(containerId, state, nmsItems, cursor));
    }

    @Override
    public void sendFirstItem(@NotNull Player player, @Nullable ItemStack item) {
        aig serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((byo)serverPlayer);
        cfz nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        int state = serverPlayer.bR.k();
        this.getPlayerConnection(serverPlayer).a((uo)new vm(containerId, state, 0, nmsItem));
    }

    @Override
    public void sendSecondItem(@NotNull Player player, @Nullable ItemStack item) {
        aig serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((byo)serverPlayer);
        cfz nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        int state = serverPlayer.bR.k();
        this.getPlayerConnection(serverPlayer).a((uo)new vm(containerId, state, 1, nmsItem));
    }

    @Override
    public void sendResultItem(@NotNull Player player, @Nullable ItemStack item) {
        this.sendResultItem(player, CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public void clearResultItem(@NotNull Player player) {
        this.sendResultItem(player, cfz.b);
    }

    @Override
    public void setCursor(@NotNull Player player, @NotNull ItemStack item) {
        this.setCursor(player, CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        aig serverPlayer = this.getServerPlayer(player);
        int state = serverPlayer.bR.k();
        this.getPlayerConnection(serverPlayer).a((uo)new vm(-1, state, -1, cfz.b));
    }

    @Deprecated
    private void setCursor(@NotNull Player player, @NotNull cfz item) {
        aig serverPlayer = this.getServerPlayer(player);
        int state = serverPlayer.bR.k();
        this.getPlayerConnection(serverPlayer).a((uo)new vm(-1, state, -1, item));
    }

    @Deprecated
    private void sendResultItem(@NotNull Player player, @NotNull cfz item) {
        aig serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((byo)serverPlayer);
        int state = serverPlayer.bR.k();
        this.getPlayerConnection(serverPlayer).a((uo)new vm(containerId, state, 2, item));
    }

    @Deprecated
    @Contract(pure=true)
    private int getContainerId(@NotNull byo nmsPlayer) {
        return nmsPlayer.bR.j;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    private ajb getPlayerConnection(@NotNull aig serverPlayer) {
        return serverPlayer.c;
    }

    @NotNull
    @Contract(pure=true)
    private aig getServerPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private class ContainerAnvilImpl
    extends cbh {
        public ContainerAnvilImpl(@NotNull aig serverPlayer, sw title) {
            super(serverPlayer.nextContainerCounter(), serverPlayer.fN(), cbq.a((cmm)serverPlayer.cH(), (gu)new gu(0, 0, 0)));
            this.checkReachable = false;
            this.w.a((int)AnvilInventoryImpl.this.cost);
            this.setTitle(title);
            final ccx originalSlot = (ccx)this.i.get(2);
            this.i.set(2, (Object)new ccx(originalSlot.d, originalSlot.e, originalSlot.f, originalSlot.g){

                public boolean a(@NotNull cfz stack) {
                    return true;
                }

                public boolean a(@NotNull byo playerEntity) {
                    return true;
                }

                public void a(@NotNull byo player, @NotNull cfz stack) {
                    originalSlot.a(player, stack);
                }
            });
        }

        public boolean a(@Nullable String name) {
            String string = name = name == null ? "" : name;
            if (!name.equals(AnvilInventoryImpl.this.observableText.get())) {
                AnvilInventoryImpl.this.observableText.set(name);
            }
            this.e();
            return true;
        }

        public void m() {
        }

        public void b(@NotNull byo nmsPlayer) {
        }

        protected void a(@NotNull byo player, @NotNull bdq inventory) {
        }

        protected void a(@NotNull byo player, @NotNull cfz stack) {
        }

        public int getContainerId() {
            return this.j;
        }
    }
}

