/*
 * Decompiled with CFR 0.152.
 */
package de.lars.inventoryframework.nms.v1_20_0;

import de.lars.inventoryframework.abstraction.CartographyTableInventory;
import de.lars.inventoryframework.adventuresupport.TextHolder;
import de.lars.inventoryframework.nms.v1_20_0.util.CustomInventoryUtil;
import de.lars.inventoryframework.nms.v1_20_0.util.TextHolderUtil;
import java.lang.reflect.Field;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryCartography;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CartographyTableInventoryImpl
extends CartographyTableInventory {
    public CartographyTableInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public void openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 3) {
            throw new IllegalArgumentException("The amount of items for a cartography table should be 3, but is '" + itemAmount + "'");
        }
        aig serverPlayer = this.getServerPlayer(player);
        sw message = TextHolderUtil.toComponent(title);
        ContainerCartographyTableImpl containerCartographyTable = new ContainerCartographyTableImpl(serverPlayer, items, message);
        serverPlayer.bR = containerCartographyTable;
        int id = containerCartographyTable.j;
        serverPlayer.c.a((uo)new wo(id, cck.w, message));
        this.sendItems(player, items);
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items) {
        hn<cfz> nmsItems = CustomInventoryUtil.convertToNMSItems(items);
        aig serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((byo)serverPlayer);
        int state = serverPlayer.bR.k();
        cfz cursor = CraftItemStack.asNMSCopy((ItemStack)player.getItemOnCursor());
        ajb playerConnection = this.getPlayerConnection(serverPlayer);
        playerConnection.a((uo)new vk(containerId, state, nmsItems, cursor));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        aig serverPlayer = this.getServerPlayer(player);
        int state = serverPlayer.bR.k();
        this.getPlayerConnection(serverPlayer).a((uo)new vm(-1, state, -1, cfz.b));
    }

    @Contract(pure=true)
    private int getContainerId(@NotNull byo nmsPlayer) {
        return nmsPlayer.bR.j;
    }

    @NotNull
    @Contract(pure=true)
    private ajb getPlayerConnection(@NotNull aig serverPlayer) {
        return serverPlayer.c;
    }

    @NotNull
    @Contract(pure=true)
    private aig getServerPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private class ContainerCartographyTableImpl
    extends cbl {
        @NotNull
        private final Player player;
        @Nullable
        private CraftInventoryView bukkitEntity;
        @NotNull
        private final Field resultContainerField;

        public ContainerCartographyTableImpl(@Nullable aig serverPlayer, @NotNull ItemStack[] items, sw title) {
            super(serverPlayer.nextContainerCounter(), serverPlayer.fN());
            this.player = serverPlayer.getBukkitEntity();
            this.setTitle(title);
            try {
                this.resultContainerField = cbl.class.getDeclaredField("u");
                this.resultContainerField.setAccessible(true);
            }
            catch (NoSuchFieldException exception) {
                throw new RuntimeException(exception);
            }
            this.n.a(0, CraftItemStack.asNMSCopy((ItemStack)items[0]));
            this.n.a(1, CraftItemStack.asNMSCopy((ItemStack)items[1]));
            this.getResultInventory().a(0, CraftItemStack.asNMSCopy((ItemStack)items[2]));
        }

        @NotNull
        public CraftInventoryView getBukkitView() {
            if (this.bukkitEntity == null) {
                CraftInventoryCartography inventory = new CraftInventoryCartography(this.n, this.getResultInventory()){

                    @NotNull
                    @Contract(pure=true)
                    public InventoryHolder getHolder() {
                        return CartographyTableInventoryImpl.this.inventoryHolder;
                    }
                };
                this.bukkitEntity = new CraftInventoryView((HumanEntity)this.player, (Inventory)inventory, (cbf)this);
            }
            return this.bukkitEntity;
        }

        @Contract(pure=true, value="_ -> true")
        public boolean a(@Nullable byo nmsPlayer) {
            return true;
        }

        public void a(bdq container) {
        }

        public void b(byo nmsPlayer) {
        }

        @NotNull
        @Contract(pure=true)
        private bdq getResultInventory() {
            try {
                return (bdq)this.resultContainerField.get((Object)this);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

