/*
 * Decompiled with CFR 0.152.
 */
package de.lars.inventoryframework.nms.v1_20_0;

import de.lars.inventoryframework.abstraction.SmithingTableInventory;
import de.lars.inventoryframework.adventuresupport.TextHolder;
import de.lars.inventoryframework.nms.v1_20_0.util.CustomInventoryUtil;
import de.lars.inventoryframework.nms.v1_20_0.util.TextHolderUtil;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmithingTableInventoryImpl
extends SmithingTableInventory {
    public SmithingTableInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    @NotNull
    public Inventory openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 4) {
            throw new IllegalArgumentException("The amount of items for a smithing table should be 4, but is '" + itemAmount + "'");
        }
        aig serverPlayer = this.getServerPlayer(player);
        CraftEventFactory.handleInventoryCloseEvent((byo)serverPlayer);
        serverPlayer.bR = serverPlayer.bQ;
        sw message = TextHolderUtil.toComponent(title);
        ContainerSmithingTableImpl containerSmithingTable = new ContainerSmithingTableImpl(serverPlayer, message);
        Inventory inventory = containerSmithingTable.getBukkitView().getTopInventory();
        inventory.setItem(0, items[0]);
        inventory.setItem(1, items[1]);
        inventory.setItem(2, items[2]);
        inventory.setItem(3, items[3]);
        int containerId = containerSmithingTable.getContainerId();
        serverPlayer.c.a((uo)new wo(containerId, cck.u, message));
        serverPlayer.bR = containerSmithingTable;
        serverPlayer.a((cbf)containerSmithingTable);
        return inventory;
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items, @Nullable ItemStack cursor) {
        hn<cfz> nmsItems = CustomInventoryUtil.convertToNMSItems(items);
        aig serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((byo)serverPlayer);
        int state = serverPlayer.bR.k();
        cfz nmsCursor = CraftItemStack.asNMSCopy((ItemStack)cursor);
        ajb playerConnection = this.getPlayerConnection(serverPlayer);
        playerConnection.a((uo)new vk(containerId, state, nmsItems, nmsCursor));
    }

    @Override
    public void sendFirstItem(@NotNull Player player, @Nullable ItemStack item) {
        aig serverPlayer = this.getServerPlayer(player);
        cfz nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        int containerId = this.getContainerId((byo)serverPlayer);
        int state = serverPlayer.bR.k();
        this.getPlayerConnection(serverPlayer).a((uo)new vm(containerId, state, 0, nmsItem));
    }

    @Override
    public void sendSecondItem(@NotNull Player player, @Nullable ItemStack item) {
        aig serverPlayer = this.getServerPlayer(player);
        cfz nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        int containerId = this.getContainerId((byo)serverPlayer);
        int state = serverPlayer.bR.k();
        this.getPlayerConnection(serverPlayer).a((uo)new vm(containerId, state, 1, nmsItem));
    }

    @Override
    public void sendResultItem(@NotNull Player player, @Nullable ItemStack item) {
        this.sendResultItem(player, CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public void clearResultItem(@NotNull Player player) {
        this.sendResultItem(player, cfz.b);
    }

    @Override
    public void setCursor(@NotNull Player player, @NotNull ItemStack item) {
        this.setCursor(player, CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        aig serverPlayer = this.getServerPlayer(player);
        int state = serverPlayer.bR.k();
        this.getPlayerConnection(serverPlayer).a((uo)new vm(-1, state, -1, cfz.b));
    }

    @Deprecated
    private void setCursor(@NotNull Player player, @NotNull cfz item) {
        aig serverPlayer = this.getServerPlayer(player);
        int state = serverPlayer.bR.k();
        this.getPlayerConnection(serverPlayer).a((uo)new vm(-1, state, -1, item));
    }

    @Deprecated
    private void sendResultItem(@NotNull Player player, @NotNull cfz item) {
        aig serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((byo)serverPlayer);
        int state = serverPlayer.bR.k();
        this.getPlayerConnection(serverPlayer).a((uo)new vm(containerId, state, 2, item));
    }

    @Deprecated
    @Contract(pure=true)
    private int getContainerId(@NotNull byo nmsPlayer) {
        return nmsPlayer.bR.j;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    private ajb getPlayerConnection(@NotNull aig serverPlayer) {
        return serverPlayer.c;
    }

    @NotNull
    @Contract(pure=true)
    private aig getServerPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private static class ContainerSmithingTableImpl
    extends ccy {
        public ContainerSmithingTableImpl(@NotNull aig serverPlayer, @NotNull sw title) {
            super(serverPlayer.nextContainerCounter(), serverPlayer.fN(), cbq.a((cmm)serverPlayer.cH(), (gu)new gu(0, 0, 0)));
            this.setTitle(title);
            this.checkReachable = false;
            final ccx slotOne = (ccx)this.i.get(0);
            final ccx slotTwo = (ccx)this.i.get(1);
            final ccx slotThree = (ccx)this.i.get(2);
            final ccx slotFour = (ccx)this.i.get(3);
            this.i.set(0, (Object)new ccx(slotOne.d, slotOne.e, slotOne.f, slotOne.g){

                public boolean a(@NotNull cfz stack) {
                    return true;
                }

                public boolean a(@NotNull byo playerEntity) {
                    return true;
                }

                public void a(@NotNull byo player, @NotNull cfz stack) {
                    slotOne.a(player, stack);
                }
            });
            this.i.set(1, (Object)new ccx(slotTwo.d, slotTwo.e, slotTwo.f, slotTwo.g){

                public boolean a(@NotNull cfz stack) {
                    return true;
                }

                public boolean a(@NotNull byo playerEntity) {
                    return true;
                }

                public void a(@NotNull byo player, @NotNull cfz stack) {
                    slotTwo.a(player, stack);
                }
            });
            this.i.set(2, (Object)new ccx(slotThree.d, slotThree.e, slotThree.f, slotThree.g){

                public boolean a(@NotNull cfz stack) {
                    return true;
                }

                public boolean a(@NotNull byo playerEntity) {
                    return true;
                }

                public void a(@NotNull byo player, @NotNull cfz stack) {
                    slotThree.a(player, stack);
                }
            });
            this.i.set(3, (Object)new ccx(slotFour.d, slotFour.e, slotFour.f, slotFour.g){

                public boolean a(@NotNull cfz stack) {
                    return true;
                }

                public boolean a(@NotNull byo playerEntity) {
                    return true;
                }

                public void a(@NotNull byo player, @NotNull cfz stack) {
                    slotFour.a(player, stack);
                }
            });
        }

        @Contract(pure=true, value="_ -> true")
        public boolean a(@Nullable byo nmsPlayer) {
            return true;
        }

        public void a(bdq container) {
        }

        public void b(byo nmsPlayer) {
        }

        public void m() {
        }

        protected void a(byo player, cfz stack) {
        }

        protected boolean a(byo player, boolean present) {
            return true;
        }

        public int getContainerId() {
            return this.j;
        }
    }
}

