/*
 * Decompiled with CFR 0.152.
 */
package de.lars.inventoryframework.nms.v1_21_0;

import de.lars.inventoryframework.abstraction.BeaconInventory;
import java.lang.reflect.Field;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ContainerBeacon;
import net.minecraft.world.inventory.Containers;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryBeacon;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.view.CraftBeaconView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeaconInventoryImpl
extends BeaconInventory {
    public BeaconInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public void openInventory(@NotNull Player player, @Nullable ItemStack item) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        ContainerBeaconImpl containerBeacon = new ContainerBeaconImpl(serverPlayer, item);
        serverPlayer.cd = containerBeacon;
        int id = containerBeacon.j;
        IChatMutableComponent beacon = IChatBaseComponent.b((String)"Beacon");
        serverPlayer.c.b((Packet)new PacketPlayOutOpenWindow(id, Containers.j, (IChatBaseComponent)beacon));
        this.sendItem(player, item);
    }

    @Override
    public void sendItem(@NotNull Player player, @Nullable ItemStack item) {
        NonNullList items = NonNullList.a((Object)net.minecraft.world.item.ItemStack.l, (Object[])new net.minecraft.world.item.ItemStack[]{CraftItemStack.asNMSCopy((ItemStack)item)});
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((EntityHuman)serverPlayer);
        int state = serverPlayer.cd.k();
        net.minecraft.world.item.ItemStack cursor = CraftItemStack.asNMSCopy((ItemStack)player.getItemOnCursor());
        ServerPlayerConnection playerConnection = this.getPlayerConnection(serverPlayer);
        playerConnection.b((Packet)new PacketPlayOutWindowItems(containerId, state, items, cursor));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int state = serverPlayer.cd.k();
        this.getPlayerConnection(serverPlayer).b((Packet)new PacketPlayOutSetSlot(-1, state, -1, net.minecraft.world.item.ItemStack.l));
    }

    @Contract(pure=true)
    private int getContainerId(@NotNull EntityHuman nmsPlayer) {
        return nmsPlayer.cd.j;
    }

    @NotNull
    @Contract(pure=true)
    private ServerPlayerConnection getPlayerConnection(@NotNull EntityPlayer serverPlayer) {
        return serverPlayer.c;
    }

    @NotNull
    @Contract(pure=true)
    private EntityPlayer getServerPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private class ContainerBeaconImpl
    extends ContainerBeacon {
        @NotNull
        private final Player player;
        @Nullable
        private CraftBeaconView bukkitEntity;
        @NotNull
        private final Field beaconField;

        public ContainerBeaconImpl(@Nullable EntityPlayer serverPlayer, ItemStack item) {
            super(serverPlayer.nextContainerCounter(), (IInventory)serverPlayer.fY());
            this.player = serverPlayer.getBukkitEntity();
            this.setTitle((IChatBaseComponent)IChatBaseComponent.i());
            try {
                this.beaconField = ContainerBeacon.class.getDeclaredField("s");
                this.beaconField.setAccessible(true);
            }
            catch (NoSuchFieldException exception) {
                throw new RuntimeException(exception);
            }
            try {
                net.minecraft.world.item.ItemStack itemStack = CraftItemStack.asNMSCopy((ItemStack)item);
                ((IInventory)this.beaconField.get((Object)this)).a(0, itemStack);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
        }

        @NotNull
        public CraftBeaconView getBukkitView() {
            if (this.bukkitEntity == null) {
                try {
                    IInventory container = (IInventory)this.beaconField.get((Object)this);
                    CraftInventoryBeacon inventory = new CraftInventoryBeacon(container){

                        @NotNull
                        @Contract(pure=true)
                        public InventoryHolder getHolder() {
                            return BeaconInventoryImpl.this.inventoryHolder;
                        }
                    };
                    this.bukkitEntity = new CraftBeaconView((HumanEntity)this.player, (Inventory)inventory, (ContainerBeacon)this);
                }
                catch (IllegalAccessException exception) {
                    throw new RuntimeException(exception);
                }
            }
            return this.bukkitEntity;
        }

        @Contract(pure=true, value="_ -> true")
        public boolean b(@Nullable EntityHuman nmsPlayer) {
            return true;
        }

        public void a(IInventory container) {
        }

        public void a(EntityHuman nmsPlayer) {
        }
    }
}

