/*
 * Decompiled with CFR 0.152.
 */
package de.lars.inventoryframework.nms.v1_21_0;

import de.lars.inventoryframework.abstraction.MerchantInventory;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class MerchantInventoryImpl
extends MerchantInventory {
    @Override
    public void sendMerchantOffers(@NotNull Player player, @NotNull List<? extends Map.Entry<? extends org.bukkit.inventory.MerchantRecipe, ? extends Integer>> trades, int level, int experience) {
        MerchantRecipeList offers = new MerchantRecipeList();
        for (Map.Entry<? extends org.bukkit.inventory.MerchantRecipe, ? extends Integer> entry : trades) {
            org.bukkit.inventory.MerchantRecipe recipe = entry.getKey();
            List ingredients = recipe.getIngredients();
            if (ingredients.size() < 1) {
                throw new IllegalStateException("Merchant recipe has no ingredients");
            }
            ItemStack itemA = (ItemStack)ingredients.get(0);
            ItemStack itemB = null;
            if (ingredients.size() >= 2) {
                itemB = (ItemStack)ingredients.get(1);
            }
            net.minecraft.world.item.ItemStack nmsItemA = CraftItemStack.asNMSCopy((ItemStack)itemA);
            net.minecraft.world.item.ItemStack nmsItemB = net.minecraft.world.item.ItemStack.l;
            net.minecraft.world.item.ItemStack nmsItemResult = CraftItemStack.asNMSCopy((ItemStack)recipe.getResult());
            if (itemB != null) {
                nmsItemB = CraftItemStack.asNMSCopy((ItemStack)itemB);
            }
            ItemCost itemCostA = this.convertItemStackToItemCost(nmsItemA);
            ItemCost itemCostB = this.convertItemStackToItemCost(nmsItemB);
            int uses = recipe.getUses();
            int maxUses = recipe.getMaxUses();
            int exp = recipe.getVillagerExperience();
            float multiplier = recipe.getPriceMultiplier();
            MerchantRecipe merchantOffer = new MerchantRecipe(itemCostA, Optional.of(itemCostB), nmsItemResult, uses, maxUses, exp, multiplier);
            merchantOffer.b(entry.getValue().intValue());
            offers.add((Object)merchantOffer);
        }
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int n = this.getContainerId((EntityHuman)serverPlayer);
        serverPlayer.a(n, offers, level, experience, true, false);
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    private ItemCost convertItemStackToItemCost(@NotNull net.minecraft.world.item.ItemStack itemStack) {
        DataComponentPredicate predicate = DataComponentPredicate.a((DataComponentMap)itemStack.a());
        return new ItemCost(itemStack.h(), itemStack.H(), predicate, itemStack);
    }

    @NotNull
    @Contract(pure=true)
    private EntityPlayer getServerPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    @Contract(pure=true)
    private int getContainerId(@NotNull EntityHuman nmsPlayer) {
        return nmsPlayer.cd.j;
    }
}

