/*
 * Decompiled with CFR 0.152.
 */
package de.lars.inventoryframework.nms.v1_21_1;

import de.lars.inventoryframework.abstraction.StonecutterInventory;
import de.lars.inventoryframework.adventuresupport.TextHolder;
import de.lars.inventoryframework.nms.v1_21_1.util.TextHolderUtil;
import java.lang.reflect.Field;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ContainerStonecutter;
import net.minecraft.world.inventory.Containers;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryStonecutter;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.view.CraftStonecutterView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StonecutterInventoryImpl
extends StonecutterInventory {
    public StonecutterInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public void openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 2) {
            throw new IllegalArgumentException("The amount of items for a stonecutter should be 2, but is '" + itemAmount + "'");
        }
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        IChatBaseComponent message = TextHolderUtil.toComponent(title);
        ContainerStonecutterImpl containerEnchantmentTable = new ContainerStonecutterImpl(serverPlayer, items, message);
        serverPlayer.cd = containerEnchantmentTable;
        int id = containerEnchantmentTable.j;
        PacketPlayOutOpenWindow packet = new PacketPlayOutOpenWindow(id, Containers.y, message);
        serverPlayer.c.b((Packet)packet);
        this.sendItems(player, items);
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items) {
        NonNullList nmsItems = NonNullList.a((Object)net.minecraft.world.item.ItemStack.l, (Object[])new net.minecraft.world.item.ItemStack[]{CraftItemStack.asNMSCopy((ItemStack)items[0]), CraftItemStack.asNMSCopy((ItemStack)items[1])});
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((EntityHuman)serverPlayer);
        int state = serverPlayer.cd.k();
        net.minecraft.world.item.ItemStack cursor = CraftItemStack.asNMSCopy((ItemStack)player.getItemOnCursor());
        ServerPlayerConnection playerConnection = this.getPlayerConnection(serverPlayer);
        playerConnection.b((Packet)new PacketPlayOutWindowItems(containerId, state, nmsItems, cursor));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int state = serverPlayer.cd.k();
        this.getPlayerConnection(serverPlayer).b((Packet)new PacketPlayOutSetSlot(-1, state, -1, net.minecraft.world.item.ItemStack.l));
    }

    @Contract(pure=true)
    private int getContainerId(@NotNull EntityHuman nmsPlayer) {
        return nmsPlayer.cd.j;
    }

    @NotNull
    @Contract(pure=true)
    private ServerPlayerConnection getPlayerConnection(@NotNull EntityPlayer serverPlayer) {
        return serverPlayer.c;
    }

    @NotNull
    @Contract(pure=true)
    private EntityPlayer getServerPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private class ContainerStonecutterImpl
    extends ContainerStonecutter {
        @NotNull
        private final Player player;
        @Nullable
        private CraftStonecutterView bukkitEntity;
        @NotNull
        private final Field resultContainerField;

        public ContainerStonecutterImpl(@Nullable EntityPlayer entityPlayer, @NotNull ItemStack[] items, IChatBaseComponent title) {
            super(entityPlayer.nextContainerCounter(), entityPlayer.fY());
            this.player = entityPlayer.getBukkitEntity();
            this.setTitle(title);
            try {
                this.resultContainerField = ContainerStonecutter.class.getDeclaredField("A");
                this.resultContainerField.setAccessible(true);
            }
            catch (NoSuchFieldException exception) {
                throw new RuntimeException(exception);
            }
            this.o.a(0, CraftItemStack.asNMSCopy((ItemStack)items[0]));
            this.getResultInventory().a(0, CraftItemStack.asNMSCopy((ItemStack)items[1]));
        }

        @NotNull
        public CraftStonecutterView getBukkitView() {
            if (this.bukkitEntity == null) {
                CraftInventoryStonecutter inventory = new CraftInventoryStonecutter(this.o, this.getResultInventory()){

                    @NotNull
                    @Contract(pure=true)
                    public InventoryHolder getHolder() {
                        return StonecutterInventoryImpl.this.inventoryHolder;
                    }
                };
                this.bukkitEntity = new CraftStonecutterView((HumanEntity)this.player, (org.bukkit.inventory.StonecutterInventory)inventory, (ContainerStonecutter)this);
            }
            return this.bukkitEntity;
        }

        @Contract(pure=true, value="_ -> true")
        public boolean b(@Nullable EntityHuman nmsPlayer) {
            return true;
        }

        public void a(IInventory container) {
        }

        public void a(EntityHuman nmsPlayer) {
        }

        @NotNull
        @Contract(pure=true)
        public IInventory getResultInventory() {
            try {
                return (IInventory)this.resultContainerField.get((Object)this);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

