/*
 * Decompiled with CFR 0.152.
 */
package de.lars.inventoryframework.nms.v1_21_2_3;

import de.lars.inventoryframework.abstraction.EnchantingTableInventory;
import de.lars.inventoryframework.adventuresupport.TextHolder;
import de.lars.inventoryframework.nms.v1_21_2_3.util.TextHolderUtil;
import java.lang.reflect.Field;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ContainerEnchantTable;
import net.minecraft.world.inventory.Containers;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftInventoryEnchanting;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R2.inventory.view.CraftEnchantmentView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EnchantingInventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchantingTableInventoryImpl
extends EnchantingTableInventory {
    public EnchantingTableInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public void openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 2) {
            throw new IllegalArgumentException("The amount of items for an enchanting table should be 2, but is '" + itemAmount + "'");
        }
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        IChatBaseComponent message = TextHolderUtil.toComponent(title);
        ContainerEnchantingTableImpl containerEnchantmentTable = new ContainerEnchantingTableImpl(serverPlayer, items, message);
        serverPlayer.cd = containerEnchantmentTable;
        int id = containerEnchantmentTable.l;
        serverPlayer.f.b((Packet)new PacketPlayOutOpenWindow(id, Containers.n, message));
        this.sendItems(player, items);
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items) {
        NonNullList nmsItems = NonNullList.a((Object)net.minecraft.world.item.ItemStack.j, (Object[])new net.minecraft.world.item.ItemStack[]{CraftItemStack.asNMSCopy((ItemStack)items[0]), CraftItemStack.asNMSCopy((ItemStack)items[1])});
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((EntityHuman)serverPlayer);
        int state = serverPlayer.cd.k();
        net.minecraft.world.item.ItemStack cursor = CraftItemStack.asNMSCopy((ItemStack)player.getItemOnCursor());
        ServerPlayerConnection playerConnection = this.getPlayerConnection(serverPlayer);
        playerConnection.b((Packet)new PacketPlayOutWindowItems(containerId, state, nmsItems, cursor));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int state = serverPlayer.cd.k();
        this.getPlayerConnection(serverPlayer).b((Packet)new PacketPlayOutSetSlot(-1, state, -1, net.minecraft.world.item.ItemStack.j));
    }

    @Contract(pure=true)
    private int getContainerId(@NotNull EntityHuman nmsPlayer) {
        return nmsPlayer.cd.l;
    }

    @NotNull
    @Contract(pure=true)
    private ServerPlayerConnection getPlayerConnection(@NotNull EntityPlayer serverPlayer) {
        return serverPlayer.f;
    }

    @NotNull
    @Contract(pure=true)
    private EntityPlayer getServerPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private class ContainerEnchantingTableImpl
    extends ContainerEnchantTable {
        @NotNull
        private final Player player;
        @Nullable
        private CraftEnchantmentView bukkitEntity;
        @NotNull
        private final Field enchantSlotsField;

        public ContainerEnchantingTableImpl(@Nullable EntityPlayer serverPlayer, @NotNull ItemStack[] items, IChatBaseComponent title) {
            super(serverPlayer.nextContainerCounter(), serverPlayer.gi());
            this.player = serverPlayer.getBukkitEntity();
            this.setTitle(title);
            try {
                this.enchantSlotsField = ContainerEnchantTable.class.getDeclaredField("q");
                this.enchantSlotsField.setAccessible(true);
            }
            catch (NoSuchFieldException exception) {
                throw new RuntimeException(exception);
            }
            try {
                IInventory input = (IInventory)this.enchantSlotsField.get((Object)this);
                input.a(0, CraftItemStack.asNMSCopy((ItemStack)items[0]));
                input.a(1, CraftItemStack.asNMSCopy((ItemStack)items[1]));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        @NotNull
        public CraftEnchantmentView getBukkitView() {
            if (this.bukkitEntity == null) {
                try {
                    IInventory container = (IInventory)this.enchantSlotsField.get((Object)this);
                    CraftInventoryEnchanting inventory = new CraftInventoryEnchanting(container){

                        @NotNull
                        @Contract(pure=true)
                        public InventoryHolder getHolder() {
                            return EnchantingTableInventoryImpl.this.inventoryHolder;
                        }
                    };
                    this.bukkitEntity = new CraftEnchantmentView((HumanEntity)this.player, (EnchantingInventory)inventory, (ContainerEnchantTable)this);
                }
                catch (IllegalAccessException exception) {
                    exception.printStackTrace();
                }
            }
            return this.bukkitEntity;
        }

        @Contract(pure=true, value="_ -> true")
        public boolean b(@Nullable EntityHuman nmsPlayer) {
            return true;
        }

        public void a(IInventory container) {
        }

        public void a(EntityHuman nmsPlayer) {
        }
    }
}

