/*
 * Decompiled with CFR 0.152.
 */
package de.lars.inventoryframework.nms.v1_21_4;

import de.lars.inventoryframework.abstraction.GrindstoneInventory;
import de.lars.inventoryframework.adventuresupport.TextHolder;
import de.lars.inventoryframework.nms.v1_21_4.util.CustomInventoryUtil;
import de.lars.inventoryframework.nms.v1_21_4.util.TextHolderUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerGrindstone;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrindstoneInventoryImpl
extends GrindstoneInventory {
    public GrindstoneInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public Inventory openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 3) {
            throw new IllegalArgumentException("The amount of items for a grindstone should be 3, but is '" + itemAmount + "'");
        }
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        CraftEventFactory.handleInventoryCloseEvent((EntityHuman)serverPlayer);
        serverPlayer.cd = serverPlayer.cc;
        IChatBaseComponent message = TextHolderUtil.toComponent(title);
        ContainerGrindstoneImpl containerGrindstone = new ContainerGrindstoneImpl(serverPlayer, message);
        Inventory inventory = containerGrindstone.getBukkitView().getTopInventory();
        inventory.setItem(0, items[0]);
        inventory.setItem(1, items[1]);
        inventory.setItem(2, items[2]);
        int containerId = containerGrindstone.getContainerId();
        serverPlayer.f.b((Packet)new PacketPlayOutOpenWindow(containerId, Containers.p, message));
        serverPlayer.cd = containerGrindstone;
        serverPlayer.a((Container)containerGrindstone);
        return inventory;
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items, @Nullable ItemStack cursor) {
        if (cursor == null) {
            throw new IllegalArgumentException("Cursor may not be null on version 1.19.2");
        }
        NonNullList<net.minecraft.world.item.ItemStack> nmsItems = CustomInventoryUtil.convertToNMSItems(items);
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((EntityHuman)serverPlayer);
        int state = serverPlayer.cd.k();
        net.minecraft.world.item.ItemStack nmsCursor = CraftItemStack.asNMSCopy((ItemStack)cursor);
        ServerPlayerConnection playerConnection = this.getPlayerConnection(serverPlayer);
        playerConnection.b((Packet)new PacketPlayOutWindowItems(containerId, state, nmsItems, nmsCursor));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int state = serverPlayer.cd.k();
        this.getPlayerConnection(serverPlayer).b((Packet)new PacketPlayOutSetSlot(-1, state, -1, net.minecraft.world.item.ItemStack.j));
    }

    @Deprecated
    @Contract(pure=true)
    private int getContainerId(@NotNull EntityHuman nmsPlayer) {
        return nmsPlayer.cd.l;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    private ServerPlayerConnection getPlayerConnection(@NotNull EntityPlayer serverPlayer) {
        return serverPlayer.f;
    }

    @NotNull
    @Contract(pure=true)
    private EntityPlayer getServerPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private static class ContainerGrindstoneImpl
    extends ContainerGrindstone {
        public ContainerGrindstoneImpl(@NotNull EntityPlayer serverPlayer, @NotNull IChatBaseComponent title) {
            super(serverPlayer.nextContainerCounter(), serverPlayer.gi());
            this.setTitle(title);
            Slot firstSlot = (Slot)this.k.get(0);
            Slot secondSlot = (Slot)this.k.get(1);
            Slot thirdSlot = (Slot)this.k.get(2);
            this.k.set(0, (Object)new Slot(firstSlot.c, firstSlot.d, firstSlot.e, firstSlot.f){

                public boolean a(net.minecraft.world.item.ItemStack stack) {
                    return true;
                }
            });
            this.k.set(1, (Object)new Slot(secondSlot.c, secondSlot.d, secondSlot.e, secondSlot.f){

                public boolean a(net.minecraft.world.item.ItemStack stack) {
                    return true;
                }
            });
            this.k.set(2, (Object)new Slot(thirdSlot.c, thirdSlot.d, thirdSlot.e, thirdSlot.f){

                public boolean a(net.minecraft.world.item.ItemStack stack) {
                    return true;
                }

                public void a(EntityHuman player, net.minecraft.world.item.ItemStack stack) {
                }
            });
        }

        @Contract(pure=true, value="_ -> true")
        public boolean b(@Nullable EntityHuman nmsPlayer) {
            return true;
        }

        public void a(IInventory container) {
        }

        public void a(EntityHuman nmsPlayer) {
        }

        public int getContainerId() {
            return this.l;
        }
    }
}

